/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.GetSCFSingle;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.util.ArrayList;
import java.util.List;

public class GetCommissioningFile
extends ToolImpl {
    private static final String STATUS_FAILED = "Failed";
    private static final String STATUS_SUCCESSFUL = "Successful";
    private static final String COLUMN_SCF_STATUS = "Get Configuration";
    private List<OperationResult> myResults = new ArrayList<OperationResult>();

    public GetCommissioningFile(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return COLUMN_SCF_STATUS;
    }

    @Override
    public String getVersion() {
        return "2.0";
    }

    @Override
    public String getFilePrefix() {
        return "GetConfiguration";
    }

    @Override
    public String getResults() {
        ToolSummaryTable t = new ToolSummaryTable();
        t.addColumn("Site");
        t.addColumn("Site Status");
        t.addColumn(COLUMN_SCF_STATUS);
        for (OperationResult r : this.myResults) {
            t.addRow(r.getAddress(), this.getStatusText(r), this.getSCFResult(r));
        }
        return t.toString();
    }

    @Override
    public String getShortResult() {
        if (this.myResults.size() > 0) {
            return this.getSCFResult(this.myResults.get(0));
        }
        return "No results";
    }

    private String getSCFResult(OperationResult result) {
        return result.isOK() ? STATUS_SUCCESSFUL : STATUS_FAILED;
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new GetSCFSingle();
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add(result);
        if (result.isOK()) {
            Console.info("Successfully got configuration from " + result.getAddress());
        } else {
            Console.error("Failed to get configuration from " + result.getAddress());
        }
    }
}

