/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.CheckAlarmsImpl;
import com.nokia.em.bts.coreasset.application.tools.GPSStatusChecker;
import com.nokia.em.bts.coreasset.application.tools.GPSStatusResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.Product;
import com.nokia.em.bts.coreasset.application.util.ProductInfo;
import com.nokia.em.bts.coreasset.application.util.TextFormattingUtils;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.rp.master.alarm.Alarm;
import com.nokia.em.poseidon.util.TextUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GetGPSStatus
extends CheckAlarmsImpl {
    private static final String UNDETECTED = "Not found";
    private static final String GPS_UNIT_TYPE = "FYG";
    private static final String GPS_ALARM_FILE = "conf/GPS_Alarms.txt";
    private Map<String, GPSStatusResult> myResults = new HashMap<String, GPSStatusResult>();
    private String myShortResult = "";

    public GetGPSStatus(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return "Get GPS Status";
    }

    @Override
    public String getVersion() {
        return "2.2";
    }

    @Override
    public String getFilePrefix() {
        return "GetGPSStatus";
    }

    @Override
    public String getResults() {
        ArrayList<String[]> gpsAlarmSummary = new ArrayList<String[]>();
        ToolSummaryTable gpsInfoTable = new ToolSummaryTable("Site", "Status", "Name", "Product code", "Serial number", "Cable length", "ANT line delay", "LNA power", "Working state", "PPS output", "Self-survey", "Latitude", "Longitude", "Altitude");
        for (GPSStatusResult result : this.myResults.values()) {
            List<Alarm> gpsAlarms = this.getGPSAlarms(result);
            if (gpsAlarms.isEmpty()) {
                gpsInfoTable.addRow(this.formatGPSInfo(result));
                continue;
            }
            gpsAlarmSummary.addAll(this.formatResult(result, gpsAlarms));
        }
        StringBuilder sb = new StringBuilder();
        if (!gpsAlarmSummary.isEmpty()) {
            int alarmcount = gpsAlarmSummary.size();
            this.myShortResult = String.valueOf(alarmcount) + TextFormattingUtils.getPlural(" alarm", alarmcount);
            sb.append("GPS Alarms");
            sb.append(LF);
            sb.append(LF);
            String[] columnNames = new String[]{"Site", "Status", "Alarm", "Detail", "Severity", "Time", "Description"};
            sb.append(this.formatSummaryTable(gpsAlarmSummary, columnNames));
            sb.append(LF);
            sb.append(LF);
        }
        if (gpsInfoTable.getRowCount() > 0) {
            this.myShortResult = "Status fetched";
            sb.append("GPS Statuses");
            sb.append(LF);
            sb.append(LF);
            sb.append(gpsInfoTable.toString());
        }
        return sb.toString();
    }

    private List<String> formatGPSInfo(GPSStatusResult result) {
        ArrayList<String> gpsInfo = new ArrayList<String>();
        gpsInfo.add(result.getAddress());
        gpsInfo.add(result.getOperationalState());
        Site siteModel = result.getSite();
        if (siteModel != null && siteModel.getCabinet() != null && siteModel.getCabinet().getUnits() != null) {
            for (Unit unit : siteModel.getCabinet().getUnits()) {
                if (!GPS_UNIT_TYPE.equalsIgnoreCase(unit.getUnitType())) continue;
                gpsInfo.addAll(new GPSModel(unit, result.getProduct()).getValues());
                return gpsInfo;
            }
        }
        gpsInfo.add(UNDETECTED);
        return gpsInfo;
    }

    private List<Alarm> getGPSAlarms(GPSStatusResult result) {
        ArrayList<String> gpsAlarmFile = new ArrayList<String>();
        gpsAlarmFile.add(GPS_ALARM_FILE);
        List<String> alarmsToBeChecked = this.getSearchedAlarmList(gpsAlarmFile);
        ArrayList<Alarm> gpsAlarms = new ArrayList<Alarm>();
        List<Alarm> alarmList = result.getAlarmList();
        if (alarmList != null) {
            for (Alarm alarm : alarmList) {
                if (!alarmsToBeChecked.contains(String.valueOf(alarm.getAlarmNumber())) && !alarmsToBeChecked.contains(String.valueOf(alarm.getAlarmDetailNbr()))) continue;
                gpsAlarms.add(alarm);
            }
        }
        return gpsAlarms;
    }

    private List<String[]> formatResult(GPSStatusResult result, List<Alarm> gpsAlarms) {
        ArrayList<String[]> alarmSummaries = new ArrayList<String[]>();
        boolean firstRow = true;
        for (Alarm alarm : gpsAlarms) {
            String[] resultInTable = new String[7];
            if (firstRow) {
                resultInTable[0] = result.getAddress();
                resultInTable[1] = result.getOperationalState();
            }
            resultInTable[2] = Long.toHexString(alarm.getAlarmNumber());
            resultInTable[3] = "" + alarm.getAlarmDetailNbr();
            resultInTable[4] = this.convertSeverity(alarm.getSeverity());
            resultInTable[5] = this.convertTimeStamp(alarm.getObservationTime());
            resultInTable[6] = alarm.getAlarmDetail();
            alarmSummaries.add(resultInTable);
            firstRow = false;
        }
        return alarmSummaries;
    }

    @Override
    public String getShortResult() {
        return this.myShortResult;
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new GPSStatusChecker();
    }

    @Override
    protected void updateResults(OperationResult result) {
        GPSStatusResult gpsResult = (GPSStatusResult)result;
        this.myResults.put(result.getAddress(), gpsResult);
        if (result.isConnected() && result.isLoggedIn()) {
            int gpsAlarmCount = this.getGPSAlarms(gpsResult).size();
            if (gpsAlarmCount == 0) {
                if (gpsResult.getSite() == null) {
                    Console.error("Failed to get GPS status from " + result.getAddress());
                    result.setExitCode(60);
                } else if (!this.containsGPSInfo(gpsResult)) {
                    Console.error("GPS Unit not found from " + result.getAddress());
                    result.setExitCode(61);
                } else {
                    Console.info("Successfully got GPS status from " + result.getAddress());
                }
            } else {
                Console.info("Successfully got " + gpsAlarmCount + " GPS alarms from " + result.getAddress());
                result.setExitCode(59);
            }
        }
    }

    private boolean containsGPSInfo(GPSStatusResult result) {
        Site site = result.getSite();
        if (site != null && site.getCabinet() != null && site.getCabinet().getUnits() != null) {
            for (Unit unit : site.getCabinet().getUnits()) {
                if (!GPS_UNIT_TYPE.equalsIgnoreCase(unit.getUnitType())) continue;
                return true;
            }
        }
        return false;
    }

    private String convertLocation(String decimalValue, String endMask) {
        try {
            double value = Double.parseDouble(decimalValue);
            double reminder = value - Math.floor(value);
            int deg = (int)Math.floor(value);
            int min = (int)Math.floor(3600.0 * reminder) / 60 % 60;
            int sec = (int)Math.floor(3600.0 * reminder) % 60;
            return String.format("%s%s %s' %s\" %s", deg, Character.valueOf('\u00b0'), min, sec, endMask);
        }
        catch (Exception ex) {
            Console.error("Error in converting GPS location value", ex);
            return "";
        }
    }

    private class GPSModel {
        private static final String VALUE_NOT_USED = "notUsed";
        private static final String ATTR_ACT_GPS_OUTPUT_LNA_POWER_SUPPLY = "ActGpsOutputLNAPowerSupply";
        private static final String ATTR_GPS_TOTAL_ANTENNA_LINE_DELAY = "gpsTotalAntennaLineDelay";
        private static final String ATTR_GPS_CABLE_LENGTH = "gpsCableLength";
        private static final String ATTR_GPS_ALTITUDE = "GpsAltitude";
        private static final String ATTR_GPS_LONGITUDE = "GpsLongitude";
        private static final String ATTR_GPS_LATITUDE = "GpsLatitude";
        private static final String ATTR_NAME_FOR_EM = "Name.For.EM";
        private static final String ATTR_GPS_SELF_SURVEY_PROGRESS = "GpsSelfSurveyProgress";
        private static final String ATTR_CLOCK_PPS = "ClockPPS";
        private static final String ATTR_INTERNAL_GPS = "InternalGPS";
        private static final String ATTR_CLOCK_INT_PPS = "ClockIntPPS";
        private static final String ATTR_CLOCK_EXT_PPS = "ClockExtPPS";
        private static final String GPS_PPS = "GPS/PPS";
        private static final String CURRENT = "Current";
        private static final String ACTIVE = "Active";
        private Unit myUnit;
        private Product myProduct;

        public GPSModel(Unit caUnit, Product prod) {
            this.myUnit = caUnit;
            this.myProduct = prod;
        }

        public List<String> getValues() {
            ArrayList<String> gpsValues = new ArrayList<String>();
            gpsValues.add(this.getGPSName());
            gpsValues.add(this.getGPSProductCode());
            gpsValues.add(this.getGPSSerialNumber());
            gpsValues.add(this.getCableLength());
            gpsValues.add(this.getLineDelay());
            gpsValues.add(this.getLNAPowerSupply());
            gpsValues.add(this.getGPSWorkingState());
            gpsValues.add(this.getGPSOutputStatus());
            gpsValues.add(this.getGPSSelfSurvey());
            gpsValues.add(this.getGPSLatitude());
            gpsValues.add(this.getGPSLongitude());
            gpsValues.add(this.getGPSAltitude());
            return gpsValues;
        }

        private String getLNAPowerSupply() {
            String gpsLnaPowerSupplyEnabled = this.myUnit.getCustomAttributeValue(ATTR_ACT_GPS_OUTPUT_LNA_POWER_SUPPLY);
            if (gpsLnaPowerSupplyEnabled == null || gpsLnaPowerSupplyEnabled.isEmpty()) {
                return "-";
            }
            return gpsLnaPowerSupplyEnabled.equalsIgnoreCase("enabled") ? "Enabled" : "Disabled";
        }

        private String getLineDelay() {
            String text = "-";
            String gpsAntennaLineDelay = this.myUnit.getSite().getCustomAttributeValue(ATTR_GPS_TOTAL_ANTENNA_LINE_DELAY);
            if (!(gpsAntennaLineDelay == null || "0".equals(gpsAntennaLineDelay.trim()) || VALUE_NOT_USED.equals(gpsAntennaLineDelay.trim()) || gpsAntennaLineDelay.equals("Coreasset_Unknown"))) {
                text = String.valueOf(gpsAntennaLineDelay) + " ns";
            }
            return text;
        }

        private String getCableLength() {
            String text = "-";
            String cableLength = this.myUnit.getSite().getCustomAttributeValue(ATTR_GPS_CABLE_LENGTH);
            if (cableLength != null && !VALUE_NOT_USED.equals(cableLength.trim()) && !cableLength.equals("Coreasset_Unknown")) {
                text = cableLength;
            }
            return text;
        }

        private String getGPSAltitude() {
            String altitude = this.myUnit.getCustomAttributeValue(ATTR_GPS_ALTITUDE);
            if (altitude == null || altitude.equals("Coreasset_Unknown")) {
                return null;
            }
            try {
                BigDecimal bd = new BigDecimal(altitude);
                return bd.setScale(1, 4).toString();
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).debug((Object)"Failed to read GPS altitude", (Throwable)e);
                return "Coreasset_Unknown";
            }
        }

        private String getGPSLongitude() {
            String text = "Updating";
            String longitude = this.myUnit.getCustomAttributeValue(ATTR_GPS_LONGITUDE);
            if (longitude != null && !longitude.equals("Coreasset_Unknown")) {
                String endMark;
                boolean isMinusFound = longitude.indexOf("-") > -1;
                String string = endMark = isMinusFound ? "W" : "E";
                if (isMinusFound) {
                    longitude = longitude.replace("-", "");
                }
                text = GetGPSStatus.this.convertLocation(longitude, endMark);
            }
            return text;
        }

        private String getGPSLatitude() {
            String text = "Updating";
            String latitude = this.myUnit.getCustomAttributeValue(ATTR_GPS_LATITUDE);
            if (latitude != null && !latitude.equals("Coreasset_Unknown")) {
                String endMark;
                boolean isMinusFound = latitude.indexOf("-") > -1;
                String string = endMark = isMinusFound ? "S" : "N";
                if (isMinusFound) {
                    latitude = latitude.replace("-", "");
                }
                text = GetGPSStatus.this.convertLocation(latitude, endMark);
            }
            return text;
        }

        private String getGPSSelfSurvey() {
            int progressValue;
            String gpsSelfSurveyProgressText = "";
            String progress = this.myUnit.getCustomAttributeValue(ATTR_GPS_SELF_SURVEY_PROGRESS);
            if (TextUtils.isInteger((String)progress) && (progressValue = Integer.parseInt(this.myUnit.getCustomAttributeValue(ATTR_GPS_SELF_SURVEY_PROGRESS))) != -1) {
                gpsSelfSurveyProgressText = progressValue < 100 ? "In progress " + progressValue + " %" : "Completed";
            }
            return gpsSelfSurveyProgressText;
        }

        private String getGPSOutputStatus() {
            String outputStatusText = "-";
            String currentClock = this.myUnit.getSite().getCustomAttributeValue(ATTR_CLOCK_PPS);
            if (ProductInfo.isBeforeLTEOrSC15A(this.myProduct) || ProductInfo.isBeforeWBTS16(this.myProduct)) {
                if (CURRENT.equals(currentClock)) {
                    outputStatusText = "Generated";
                }
            } else if (ProductInfo.isLTEOrSC15A(this.myProduct) || ProductInfo.isSinceWBTS16(this.myProduct)) {
                if (ACTIVE.equals(currentClock) || CURRENT.equals(currentClock)) {
                    outputStatusText = "Generated";
                }
            } else if (ProductInfo.isAfterLTEOrSC15A(this.myProduct)) {
                String internalGPS = this.myUnit.getCustomAttributeValue(ATTR_INTERNAL_GPS);
                if ("TRUE".equalsIgnoreCase(internalGPS)) {
                    String clockIntPPS = this.myUnit.getSite().getCustomAttributeValue(ATTR_CLOCK_INT_PPS);
                    if (ACTIVE.equals(clockIntPPS) || CURRENT.equals(clockIntPPS)) {
                        outputStatusText = "Generated";
                    }
                } else {
                    String clockExtPPS = this.myUnit.getSite().getCustomAttributeValue(ATTR_CLOCK_EXT_PPS);
                    if (ACTIVE.equals(clockExtPPS) || CURRENT.equals(clockExtPPS)) {
                        outputStatusText = "Generated";
                    }
                }
            }
            return outputStatusText;
        }

        private String getGPSSerialNumber() {
            return this.myUnit.getSerialNro();
        }

        private String getGPSProductCode() {
            return this.myUnit.getProductCode();
        }

        private String getGPSName() {
            return this.myUnit.getCustomAttributeValue(ATTR_NAME_FOR_EM);
        }

        public String getGPSWorkingState() {
            String value = "";
            switch (this.myUnit.getState()) {
                case 52: {
                    value = "Working";
                    break;
                }
                case 53: {
                    value = "Degraded";
                    break;
                }
                case 54: {
                    value = "Faulty";
                    break;
                }
                case 58: {
                    value = "Resetting";
                    break;
                }
                default: {
                    value = "Unknown";
                }
            }
            return value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator iter = this.myUnit.getCustomAttributeKeys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                sb.append(String.valueOf(key) + ": " + this.myUnit.getCustomAttributeValue(key));
                sb.append(LF);
            }
            return sb.toString();
        }
    }
}

