/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.scenario.ScenarioManager;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams.ACNonOpBackhaulParamsBean;
import com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams.ACNonOpBackhaulParamsScenarioListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class GetNonOpBackhaulSingle
extends ToolBase {
    private static final String BACKHAUL_PARAMS = "BackhaulParams";
    private boolean myTimeouted = true;
    private String myAddress;

    @Override
    protected void reset() {
        this.myTimeouted = true;
    }

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(btsInformation.getBTSAddress(), btsInformation.getUserName(), btsInformation.getPassword(), this.getCredentialsFrom(args));
            disconnect = true;
        }
        this.myAddress = connectionInfo.getAddress();
        FeedbackResult result = new FeedbackResult(this.myAddress);
        if (connectionInfo.isConnected()) {
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connectionInfo.getConnection());
            }
            result.setOperationalState(this.getOperationalStateText(site));
            BTSConnection connection = connectionInfo.getConnection();
            ScenarioManagerImpl scenarioManager = new ScenarioManagerImpl(connection);
            File f = this.getACNonOpBackhaulParams((ScenarioManager)scenarioManager, result);
            if (f != null) {
                this.copyFile(f, new File(String.valueOf(this.getOutDir()) + this.myAddress + "_" + BACKHAUL_PARAMS + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xml"));
                Tools.deleteFile((File)f);
                result.setOK(true);
                result.setFeedback("Successful");
                Console.info("Successfully got backhaul parameters from " + this.myAddress);
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getACNonOpBackhaulParams(ScenarioManager s, final FeedbackResult result) {
        ACNonOpBackhaulParamsScenarioListener listener;
        final File[] file = new File[1];
        ACNonOpBackhaulParamsScenarioListener aCNonOpBackhaulParamsScenarioListener = listener = new ACNonOpBackhaulParamsScenarioListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void acNonOpBackhaulParamsGetSuccessful(ACNonOpBackhaulParamsBean bean) {
                GetNonOpBackhaulSingle.this.myTimeouted = false;
                1 var2_2 = this;
                synchronized (var2_2) {
                    try {
                        File f = File.createTempFile("cli", ".tmp");
                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
                        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        out.println("<ACNonOpBackhaulParams>");
                        out.print(bean.toFormatXMLString());
                        out.print("</ACNonOpBackhaulParams>");
                        out.close();
                        file[0] = f;
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass()).error((Object)("Failed to get backhaul parameters file from " + GetNonOpBackhaulSingle.this.myAddress), (Throwable)e);
                        result.setOK(false);
                        result.setFeedback("Failed");
                        result.setExitCode(113);
                    }
                    this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void acNonOpBackhaulParamsGetFailed(int failReason) {
                GetNonOpBackhaulSingle.this.myTimeouted = false;
                1 var2_2 = this;
                synchronized (var2_2) {
                    String failedReason = GetNonOpBackhaulSingle.this.getFailReasonText(failReason);
                    Console.error("Failed to get backhaul params (" + failedReason + ") from " + GetNonOpBackhaulSingle.this.myAddress);
                    result.setOK(false);
                    result.setFeedback(failedReason);
                    if (68 == failReason) {
                        result.setExitCode(8);
                    } else {
                        result.setExitCode(113);
                    }
                    this.notify();
                }
            }

            public void acNonOpBackhaulParamsUpdateSuccessful(ACNonOpBackhaulParamsBean bean) {
            }

            public void acNonOpBackhaulParamsUpdateFailed(int failReason) {
            }
        };
        synchronized (aCNonOpBackhaulParamsScenarioListener) {
            try {
                s.getGetACNonOpBackhaulParamsScenario(listener, false).execute();
                listener.wait(this.myTimeout);
                if (this.myTimeouted) {
                    result.setOK(false);
                    result.setFeedback("Timeout");
                    result.setExitCode(8);
                    Console.error("Get backhaul params timeout with " + this.myAddress);
                }
            }
            catch (Exception e) {
                Console.error("Failed to get backhaul params from " + this.myAddress, e);
                result.setOK(false);
                result.setFeedback("Failed");
                result.setExitCode(113);
            }
        }
        return file[0];
    }

    @Override
    protected String getDefaultConnectionType() {
        return "read-only";
    }
}

