/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.GetRADParamsSingle;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.util.ArrayList;
import java.util.List;

public class GetRADParamsImpl
extends ToolImpl {
    private static final String STATUS_FAILED = "Failed";
    private static final String STATUS_SUCCESSFUL = "Successful";
    private static final String COLUMN_RAD_STATUS = "Get RAD Parameters";
    private List<FeedbackResult> myResults = new ArrayList<FeedbackResult>();

    public GetRADParamsImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return "Get RAD Params";
    }

    @Override
    public String getVersion() {
        return "2.1";
    }

    @Override
    public String getFilePrefix() {
        return "GetRADParams";
    }

    @Override
    public String getResults() {
        ToolSummaryTable t = new ToolSummaryTable();
        t.addColumn("Site");
        t.addColumn("Site Status");
        t.addColumn(COLUMN_RAD_STATUS);
        for (OperationResult operationResult : this.myResults) {
            t.addRow(operationResult.getAddress(), this.getStatusText(operationResult), this.getRADParameterResult(operationResult));
        }
        return t.toString();
    }

    @Override
    public String getShortResult() {
        if (this.myResults.size() > 0) {
            return this.getRADParameterResult(this.myResults.get(0));
        }
        return "No results";
    }

    private String getRADParameterResult(OperationResult result) {
        return result.isOK() ? STATUS_SUCCESSFUL : STATUS_FAILED;
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new GetRADParamsSingle();
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add((FeedbackResult)result);
        if (result.isOK()) {
            Console.info("Successfully got RAD parameters from " + result.getAddress());
        } else {
            Console.error("Failed to get RAD parameters from " + result.getAddress());
        }
    }
}

