/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.scenario.ScenarioManager;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.RadParamsAdapter;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.RadParamsListener;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GetRADParamsSingle
extends ToolBase {
    private static final String ARG_BTSSWSC = "btsswsc";
    private static final String ARG_PARAMS = "params";
    private String myBtsSwSC;
    private List<Integer> myParamIndexNumbers;
    private String myAddress;

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(btsInformation.getBTSAddress(), btsInformation.getUserName(), btsInformation.getPassword(), this.getCredentialsFrom(args));
            disconnect = true;
        }
        this.myAddress = connectionInfo.getAddress();
        FeedbackResult result = new FeedbackResult(this.myAddress);
        this.myBtsSwSC = args.getFirstValue(ARG_BTSSWSC);
        if (this.myBtsSwSC == null || "".equals(this.myBtsSwSC.trim())) {
            String feedback = "Mandatory parameter btsswsc is missing.";
            Console.error(feedback);
            result.setOK(false);
            result.setExitCode(3);
            result.setFeedback(feedback);
            return result;
        }
        String params = args.getFirstValue(ARG_PARAMS);
        Console.info("ParameterIndex numbers: " + params);
        this.myParamIndexNumbers = this.commaDelimitedStringToIntegerList(params);
        if (connectionInfo.isConnected()) {
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connectionInfo.getConnection());
            }
            result.setOperationalState(this.getOperationalStateText(site));
            result.setAddress(this.myAddress);
            File file = this.getRADParams((ScenarioManager)new ScenarioManagerImpl(connectionInfo.getConnection()), this.myBtsSwSC, this.myParamIndexNumbers, result);
            if (file != null) {
                String outdir = args.getFirstValue("outdir");
                outdir = outdir == null ? "" : String.valueOf(outdir) + FS;
                File toFile = new File(String.valueOf(outdir) + this.myAddress + "_RaDParamsFrom_" + this.myBtsSwSC + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xml");
                this.copyFile(file, toFile);
                Console.info("Successfully saved the R&D parameters to file " + toFile.getName() + " from " + result.getAddress());
                file.deleteOnExit();
                result.setOK(true);
                result.setFeedback("Successful");
            } else {
                result.setOK(false);
                result.setExitCode(65);
                result.setFeedback("Failed");
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private List<Integer> commaDelimitedStringToIntegerList(String commaDilimitedString) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (commaDilimitedString != null) {
            String[] strArr;
            String[] stringArray = strArr = commaDilimitedString.split(",");
            int n = strArr.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                result.add(Integer.parseInt(str));
                ++n2;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getRADParams(ScenarioManager s, String btsScSw, List<Integer> paramIndexNumbers, final FeedbackResult result) {
        RadParamsAdapter listener;
        final File[] file = new File[1];
        RadParamsAdapter radParamsAdapter = listener = new RadParamsAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paramsGetSuccessful(Map<Long, Long> radParams) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    try {
                        File f = File.createTempFile("cli", ".tmp");
                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
                        out.print(GetRADParamsSingle.this.createRadParamsContent(radParams));
                        out.close();
                        file[0] = f;
                    }
                    catch (Exception e) {
                        Console.error("Failed to get R&D parameters file from " + GetRADParamsSingle.this.myAddress, e);
                        result.setOK(false);
                        result.setExitCode(65);
                        result.setFeedback("Failed");
                    }
                    ((Object)((Object)this)).notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paramsGetFailed(int reason) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    String failedReason = GetRADParamsSingle.this.getFailReasonText(reason);
                    Console.error("Failed to get R&D parameters (" + failedReason + ") from " + GetRADParamsSingle.this.myAddress);
                    result.setOK(false);
                    result.setFeedback(failedReason);
                    if (68 == reason) {
                        result.setExitCode(8);
                    } else {
                        result.setExitCode(65);
                    }
                    ((Object)((Object)this)).notify();
                }
            }
        };
        synchronized (radParamsAdapter) {
            try {
                if (paramIndexNumbers.size() > 0) {
                    s.getRadParamsGetScenario((RadParamsListener)listener, btsScSw, paramIndexNumbers).execute();
                } else {
                    s.getRadParamsGetScenario((RadParamsListener)listener, btsScSw).execute();
                }
                listener.wait(this.myTimeout);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).fatal((Object)("Getting R&D parameters from " + this.myAddress + " failed"), (Throwable)e);
            }
        }
        return file[0];
    }

    private String createRadParamsContent(Map<Long, Long> radParams) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("\n<RadParamsWrapper>");
        sb.append("\n<RadParamsGetResponse>");
        for (long number : radParams.keySet()) {
            long value = radParams.get(number);
            sb.append("\n<RadParam>");
            sb.append("\n<_paramIndexNumber>");
            sb.append(number);
            sb.append("</_paramIndexNumber>");
            sb.append("\n<_paramValue>");
            sb.append(value);
            sb.append("</_paramValue>");
            sb.append("\n</RadParam>");
        }
        sb.append("\n</RadParamsGetResponse>");
        sb.append("\n</RadParamsWrapper>");
        return sb.toString();
    }

    @Override
    protected String getDefaultConnectionType() {
        return "read-only";
    }
}

