/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.scenario.ScenarioManager;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.io.File;

public class GetSCFSingle
extends ToolBase {
    private static final String CONFIGURATION_XML_PREFIX = "_Configuration.xml";

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(btsInformation.getBTSAddress(), btsInformation.getUserName(), btsInformation.getPassword(), this.getCredentialsFrom(args));
            disconnect = true;
        }
        OperationResult result = new OperationResult();
        if (connectionInfo.isConnected()) {
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connectionInfo.getConnection());
            }
            result.setOperationalState(this.getOperationalStateText(site));
            result.setAddress(connectionInfo.getAddress());
            File file = this.getBTSSCF(connectionInfo, (ScenarioManager)new ScenarioManagerImpl(connectionInfo.getConnection()));
            if (file != null) {
                File f = this.decompress(file);
                String outdir = args.getFirstValue("outdir");
                outdir = outdir == null ? "" : String.valueOf(outdir) + FS;
                this.copyFile(f, new File(String.valueOf(outdir) + connectionInfo.getAddress() + CONFIGURATION_XML_PREFIX));
                f.deleteOnExit();
            } else {
                result.setOK(false);
                result.setExitCode(53);
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    @Override
    protected String getDefaultConnectionType() {
        return "read-only";
    }
}

