/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.SwVersionGetResult;
import com.nokia.em.bts.coreasset.application.tools.SwVersionGetter;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.TextFormattingUtils;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GetSwVersions
extends ToolImpl {
    private static final String UNKNOWN = "Unknown";
    private Map<String, SwVersionGetResult> myResults;
    private String myShortDescription = "Unknown";

    public GetSwVersions(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return "Get SW Versions";
    }

    @Override
    public String getVersion() {
        return "2.1";
    }

    @Override
    public String getFilePrefix() {
        return "CheckSWVersions";
    }

    @Override
    public String getResults() {
        StringBuffer sb = new StringBuffer();
        if (this.myResults.size() > 1) {
            sb.append(this.formatMultipleResults());
        } else {
            sb.append(this.formatSingleResult(this.myResults.get(this.myResults.keySet().iterator().next())));
        }
        return sb.toString();
    }

    @Override
    public String getShortResult() {
        return this.myShortDescription;
    }

    private String formatSingleResult(SwVersionGetResult result) {
        StringBuffer sb = new StringBuffer();
        String[] columnNames = new String[]{"File name", "Path", "Version", "Active", "HW unit"};
        String[] unitColumnNames = new String[]{"Unit", "Version"};
        ArrayList<String[]> swSummary = new ArrayList<String[]>();
        ArrayList<String[]> hwUnits = new ArrayList<String[]>();
        SWVersionFileData fileContent = this.parseSWVersionData(result.getSWVersionFile());
        ToolSummaryTable summary = new ToolSummaryTable("A", "B");
        summary.setShowHeader(false);
        summary.addRow("Site", result.getAddress());
        summary.addRow("Release version", fileContent.getSWReleaseVersion());
        this.myShortDescription = fileContent.getSWReleaseVersion();
        sb.append(summary.toString());
        sb.append(LF);
        sb.append(LF);
        for (SWVersionData data : fileContent.getSWVersionData()) {
            if (data.getName() != null) {
                swSummary.add(this.formatSWVersionData(data));
                continue;
            }
            hwUnits.add(this.formatSWVersionData(data));
        }
        sb.append(this.formatSummaryTable(swSummary, columnNames));
        sb.append(LF);
        sb.append(LF);
        sb.append(this.formatSummaryTable(hwUnits, unitColumnNames));
        return sb.toString();
    }

    private String[] formatSWVersionData(SWVersionData swData) {
        String active = "";
        if (swData.get("ACTIVE") != null) {
            String string = active = swData.isActive() ? "Yes" : "No";
        }
        if (swData.getName() != null) {
            return new String[]{swData.getName(), swData.getPath(), swData.getVersion(), active, swData.getHwUnit()};
        }
        if (swData.getHwUnit() != null) {
            return new String[]{swData.getHwUnit(), (String)swData.get("resourceSWVersion")};
        }
        if (swData.get("_logicalId") != null) {
            String id = swData.get("_logicalId").toString();
            if (id.contains("/")) {
                id = id.substring(0, id.indexOf("/"));
            }
            String hwUnit = String.valueOf(id) + " " + swData.get("type") + " " + swData.get("id");
            return new String[]{hwUnit, (String)swData.get("resourceSWVersion")};
        }
        return new String[0];
    }

    private String formatMultipleResults() {
        ArrayList<String[]> results = new ArrayList<String[]>();
        for (SwVersionGetResult result : this.myResults.values()) {
            SWVersionFileData fileContent = this.parseSWVersionData(result.getSWVersionFile());
            if (result.isConnected()) {
                results.add(new String[]{result.getAddress(), result.getOperationalState(), fileContent.getSWReleaseVersion()});
            } else {
                results.add(new String[]{result.getAddress(), result.getOperationalState()});
            }
            if (!result.isOK()) continue;
            try {
                this.saveFile(String.valueOf(this.getFilePrefix()) + "_" + result.getAddress() + "_" + SUMMARY_DATE_FORMAT.format(new Date()) + ".txt", this.formatSingleResult(result));
            }
            catch (IOException e) {
                Console.error("Failed to save SW Versions from " + result.getAddress(), e);
            }
        }
        String[] columnNames = new String[]{"Site", "Status", "Release version"};
        return this.formatSummaryTable(results, columnNames);
    }

    private String formatSummaryTable(List<String[]> summary, String[] columnNames) {
        String[][] summaries = new String[summary.size()][];
        int i = 0;
        while (i < summary.size()) {
            summaries[i] = summary.get(i);
            ++i;
        }
        return TextFormattingUtils.formatTableToText(summaries, columnNames);
    }

    @Override
    protected ToolBase getNewSingleTool() {
        this.myResults = new HashMap<String, SwVersionGetResult>();
        return new SwVersionGetter();
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.put(result.getAddress(), (SwVersionGetResult)result);
    }

    public SWVersionFileData parseSWVersionData(File file) {
        SWVersionFileData fileData = new SWVersionFileData();
        if (file == null) {
            return fileData;
        }
        try {
            DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBF.newDocumentBuilder();
            Document doc = docBuilder.parse(file);
            doc.getDocumentElement().normalize();
            fileData.setSWReleaseVersion(doc.getDocumentElement().getAttribute("softwareReleaseVersion"));
            NodeList elements = doc.getElementsByTagName("buildElement");
            int row = 0;
            while (row < elements.getLength()) {
                SWVersionData data = new SWVersionData();
                data.parseUnitName(elements.item(row).getParentNode().getAttributes());
                data.parseVersionData(elements.item(row).getAttributes());
                fileData.addSWVersionData(data);
                ++row;
            }
            elements = doc.getElementsByTagName("hwUnit");
            int i = 0;
            while (i < elements.getLength()) {
                Node n = elements.item(i);
                NamedNodeMap map = n.getAttributes();
                if (map.getNamedItem("resourceSWVersion") != null && map.getNamedItem("type") != null) {
                    SWVersionData data = new SWVersionData();
                    data.put("resourceSWVersion", map.getNamedItem("resourceSWVersion").getNodeValue());
                    if (map.getNamedItem("btsInternalId") != null) {
                        data.put("btsInternalId", map.getNamedItem("btsInternalId").getNodeValue());
                    }
                    if (map.getNamedItem("_logicalId") != null) {
                        data.put("_logicalId", map.getNamedItem("_logicalId").getNodeValue());
                    } else {
                        data.parseUnitName(map);
                    }
                    if (map.getNamedItem("id") != null) {
                        data.put("id", map.getNamedItem("id").getNodeValue());
                    }
                    data.put("type", map.getNamedItem("type").getNodeValue());
                    fileData.addSWVersionData(data);
                }
                ++i;
            }
            file.deleteOnExit();
        }
        catch (SAXException e) {
            Console.error("SWFileReceiver: SW file parsing failed: " + e.getMessage(), e);
        }
        catch (IOException e) {
            Console.error("SWFileReceiver: SW file parsing failed: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            Console.error("SWFileReceiver: SW file parsing failed: " + e.getMessage(), e);
        }
        return fileData;
    }

    private class SWVersionData {
        private HashMap<String, Object> myVersionData = new HashMap();
        private static final String NAME = "NAME";
        private static final String VERSION = "VERSION";
        private static final String PATH = "PATH";
        private static final String HWUNIT = "HWUNIT";
        private static final String ACTIVE = "ACTIVE";
        private static final String ISNEW = "ISNEW";

        public void parseUnitName(NamedNodeMap node) {
            String unit = String.valueOf(node.getNamedItem("type").getNodeValue()) + " " + node.getNamedItem("id").getNodeValue();
            this.myVersionData.put(HWUNIT, unit);
        }

        public void parseVersionData(NamedNodeMap node) {
            String name = node.getNamedItem("name").getNodeValue();
            this.myVersionData.put(NAME, name);
            String version = node.getNamedItem("version").getNodeValue();
            this.myVersionData.put(VERSION, version);
            String path = node.getNamedItem("path").getNodeValue();
            this.myVersionData.put(PATH, path);
            boolean active = Boolean.valueOf(node.getNamedItem("activeFlag").getNodeValue());
            this.myVersionData.put(ACTIVE, active);
            boolean isNew = Boolean.valueOf(node.getNamedItem("newFlag").getNodeValue());
            this.myVersionData.put(ISNEW, isNew);
        }

        public Object get(String key) {
            return this.myVersionData.get(key);
        }

        public Object put(String key, Object value) {
            return this.myVersionData.put(key, value);
        }

        public String getName() {
            return (String)this.myVersionData.get(NAME);
        }

        public String getVersion() {
            return (String)this.myVersionData.get(VERSION);
        }

        public String getPath() {
            return (String)this.myVersionData.get(PATH);
        }

        public String getHwUnit() {
            return (String)this.myVersionData.get(HWUNIT);
        }

        public boolean isActive() {
            return (Boolean)this.myVersionData.get(ACTIVE);
        }
    }

    private class SWVersionFileData {
        private List<SWVersionData> mySWVersionData = new ArrayList<SWVersionData>();
        private String mySWReleaseVersion = "Unknown";

        private SWVersionFileData() {
        }

        public List<SWVersionData> getSWVersionData() {
            return this.mySWVersionData;
        }

        public void addSWVersionData(SWVersionData sWVersionData) {
            this.mySWVersionData.add(sWVersionData);
        }

        public String getSWReleaseVersion() {
            return this.mySWReleaseVersion;
        }

        public void setSWReleaseVersion(String sWReleaseVersion) {
            this.mySWReleaseVersion = sWReleaseVersion;
        }
    }
}

