/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.XMLUtils;
import com.nokia.em.bts.coreasset.configuration.Cell;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GetTiltsSingle
extends ToolBase {
    private static final String UNIT_TYPE_TILT = "TILT";
    private String myAddress;

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        FeedbackResult result = new FeedbackResult(this.myAddress);
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            BTSConnection connection = connectionInfo.getConnection();
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connection);
            }
            result.setOperationalState(this.getOperationalStateText(site));
            if (site == null) {
                Console.error("Failed to get HW data from " + this.myAddress);
                result.setOK(false);
                result.setFeedback("Failed to get HW data");
                result.setExitCode(96);
            } else {
                result.setFeedback("Successful");
                for (Unit unit : site.getCabinet().getUnits()) {
                    if (!unit.getUnitType().equalsIgnoreCase(UNIT_TYPE_TILT) || this.writeFileFor(unit, site)) continue;
                    result.setFeedback("Failed");
                    result.setExitCode(97);
                }
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private boolean writeFileFor(Unit unit, Site site) {
        File file = new File(String.valueOf(this.getOutDir()) + this.myAddress + "_" + unit.getId() + "_" + unit.getNumber() + ".xml");
        if (file.exists() && !file.canWrite()) {
            Console.error("Failed to create " + file.getName() + " for tilt " + unit.getId() + " in " + this.myAddress);
            return false;
        }
        BufferedWriter out = null;
        try {
            try {
                out = new BufferedWriter(new FileWriter(file, false));
                out.write(this.getXMLFor(unit, site, ""));
                Console.info("Successfully created " + file.getName() + " for tilt " + unit.getId() + " in " + this.myAddress);
            }
            catch (Exception e) {
                Console.error("Failed to create " + file.getName() + " for tilt " + unit.getId() + " in " + this.myAddress, e);
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private String getXMLFor(Unit unit, Site site, String error) throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement("Tilt");
        doc.appendChild(root);
        this.addProductInfo(unit, root);
        this.addTiltAngles(unit, root);
        this.addCells(unit, site, root);
        this.addErrors(unit, root, error);
        this.addStatusData(unit, root);
        this.addFRData(unit, root);
        this.addOperatingBands(unit, root);
        this.addInstallationData(unit, root);
        this.addAntennas(unit, root);
        return XMLUtils.docToString(doc);
    }

    private void addFRData(Unit unit, Element root) {
        if (unit.getCustomAttributeValue("FRId") != null) {
            root.appendChild(this.createNode((Node)root, "FRId", this.getString(unit.getCustomAttributeValue("FRId"))));
        }
        if (unit.getCustomAttributeValue("FRAntList") != null) {
            root.appendChild(this.createNode((Node)root, "FRAntList", this.getString(unit.getCustomAttributeValue("FRAntList"))));
        }
    }

    private void addErrors(Unit unit, Element root, String error) {
        root.appendChild(this.createNode((Node)root, "errorCode", this.getString(unit.getCustomAttributeValue("AntennaTiltErrorCode"))));
        if (error.length() > 0) {
            root.appendChild(this.createNode((Node)root, "toolExecutionError", error));
        }
    }

    private void addStatusData(Unit unit, Element root) {
        root.appendChild(this.createNode((Node)root, "state", this.getString(unit.getCustomAttributeValue("AntennaTiltingState"))));
        root.appendChild(this.createNode((Node)root, "number", unit.getNumber()));
        root.appendChild(this.createNode((Node)root, "logicalId", this.getString(unit.getCustomAttributeValue("_logicalId"))));
        root.appendChild(this.createNode((Node)root, "serialNumber", unit.getSerialNro()));
        root.appendChild(this.createNode((Node)root, "workingState", unit.getNumber()));
        root.appendChild(this.createNode((Node)root, "operationalState", unit.getState()));
        root.appendChild(this.createNode((Node)root, "blockingState", unit.getBlockingState()));
        root.appendChild(this.createNode((Node)root, "commissioned", unit.getCommissionedStatus()));
        root.appendChild(this.createNode((Node)root, "ledColor", unit.getLedColour()));
    }

    private void addProductInfo(Unit unit, Element root) {
        root.appendChild(this.createNode((Node)root, "id", unit.getId()));
        root.appendChild(this.createNode((Node)root, "productCode", unit.getProductCode()));
        root.appendChild(this.createNode((Node)root, "manufacturer", unit.getManufacturer()));
        root.appendChild(this.createNode((Node)root, "SWVersion", this.getString(unit.getCustomAttributeValue("SWVersion"))));
        root.appendChild(this.createNode((Node)root, "HWVersion", unit.getHWVersion()));
        root.appendChild(this.createNode((Node)root, "ip", this.myAddress));
        root.appendChild(this.createNode((Node)root, "ReleaseId3Gpp", this.getString(unit.getCustomAttributeValue("ReleaseId3Gpp"))));
        root.appendChild(this.createNode((Node)root, "retDeviceType", this.getString(unit.getCustomAttributeValue("retDeviceType"))));
        root.appendChild(this.createNode((Node)root, "retAntUnitNumber", this.getString(unit.getCustomAttributeValue("retAntUnitNumber"))));
    }

    private void addTiltAngles(Unit unit, Element root) {
        root.appendChild(this.createNode((Node)root, "tilt", this.getString(unit.getCustomAttributeValue("TiltAngle"))));
        root.appendChild(this.createNode((Node)root, "maxTilt", this.getString(unit.getCustomAttributeValue("MaximumTiltAngle"))));
        root.appendChild(this.createNode((Node)root, "minTilt", this.getString(unit.getCustomAttributeValue("MinimumTiltAngle"))));
        root.appendChild(this.createNode((Node)root, "mechanicalTilt", this.getString(unit.getCustomAttributeValue("MechanicalTiltAngle"))));
    }

    private void addCells(Unit unit, Site site, Element root) {
        String frId = this.getString(unit.getCustomAttributeValue("FRId"));
        String frAntList = this.getString(unit.getCustomAttributeValue("FRAntList"));
        Element cells = root.getOwnerDocument().createElement("Cells");
        root.appendChild(cells);
        for (Cell c : site.getCells()) {
            if ((frId.equalsIgnoreCase("") || !frId.equalsIgnoreCase(this.getString(c.getCustomAttributeValue("FRId")))) && (frAntList.equalsIgnoreCase("") || c.getCustomAttributeValue("FRAntList") == null || !c.getCustomAttributeValue("FRAntList").contains(frAntList))) continue;
            Iterator e = unit.getCustomAttributeKeys();
            boolean allOK = true;
            if (frAntList.equalsIgnoreCase("") || c.getCustomAttributeValue("FRAntList") == null) {
                while (e.hasNext()) {
                    String s = (String)e.next();
                    if (!s.startsWith("AntInterface") || c.getCustomAttributeValue(s) != null) continue;
                    allOK = false;
                }
            }
            if (!allOK) continue;
            Element cell = root.getOwnerDocument().createElement("Cell");
            cell.appendChild(this.createNode((Node)root, "globalCellId", c.getGlobalCellId()));
            cell.appendChild(this.createNode((Node)root, "lcrId", c.getCellId()));
            cells.appendChild(cell);
        }
    }

    private void addOperatingBands(Unit unit, Element root) {
        Element bands = root.getOwnerDocument().createElement("AntennaOperatingBands");
        root.appendChild(bands);
        StringTokenizer st = new StringTokenizer(this.getString(unit.getCustomAttributeValue("AntennaOperatingBands")), ";");
        while (st.hasMoreTokens()) {
            StringTokenizer values = new StringTokenizer(st.nextToken(), ",");
            if (values.countTokens() != 3) continue;
            Element band = root.getOwnerDocument().createElement("AntennaOperatingBand");
            band.appendChild(this.createNode((Node)root, "OperatingFrequencyBand", values.nextToken()));
            band.appendChild(this.createNode((Node)root, "BeamWidth", values.nextToken()));
            band.appendChild(this.createNode((Node)root, "Gain", values.nextToken()));
            bands.appendChild(band);
        }
    }

    private void addInstallationData(Unit unit, Element root) {
        root.appendChild(this.createNode((Node)root, "InstallationDate", this.getString(unit.getCustomAttributeValue("InstallationDate"))));
        root.appendChild(this.createNode((Node)root, "InstallerID", this.getString(unit.getCustomAttributeValue("InstallerID"))));
        root.appendChild(this.createNode((Node)root, "BaseStationID", this.getString(unit.getCustomAttributeValue("BaseStationID"))));
        root.appendChild(this.createNode((Node)root, "SectorID", this.getString(unit.getCustomAttributeValue("SectorID"))));
    }

    private void addAntennas(Unit unit, Element root) {
        root.appendChild(this.createNode((Node)root, "ScannedAntennaInterface", this.getString(unit.getCustomAttributeValue("ScannedAntennaInterface"))));
        root.appendChild(this.createNode((Node)root, "AntennaModel", this.getString(unit.getCustomAttributeValue("AntennaModel"))));
        root.appendChild(this.createNode((Node)root, "AntennaSerialNumber", this.getString(unit.getCustomAttributeValue("AntennaSerialNumber"))));
        root.appendChild(this.createNode((Node)root, "AntennaType", this.getString(unit.getCustomAttributeValue("AntennaType"))));
        root.appendChild(this.createNode((Node)root, "AntennaTechnology", this.getString(unit.getCustomAttributeValue("AntennaTechnology"))));
        root.appendChild(this.createNode((Node)root, "AntennaLocation", this.getString(unit.getCustomAttributeValue("AntennaLocation"))));
        root.appendChild(this.createNode((Node)root, "AntennaHeight", this.getString(unit.getCustomAttributeValue("AntennaHeight"))));
        root.appendChild(this.createNode((Node)root, "AntennaBearing", this.getString(unit.getCustomAttributeValue("AntennaBearing"))));
    }

    private String getString(String value) {
        return value == null ? "" : value;
    }

    private Node createNode(Node parent, String tag, Boolean value) {
        return this.createNode(parent, tag, value.toString());
    }

    private Node createNode(Node parent, String tag, String value) {
        Element node = parent.getOwnerDocument().createElement(tag);
        node.appendChild(parent.getOwnerDocument().createTextNode(value));
        return node;
    }

    private Node createNode(Node parent, String tag, int value) {
        return this.createNode(parent, tag, String.valueOf(value));
    }

    @Override
    protected String getDefaultConnectionType() {
        return "read-only";
    }
}

