/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.XMLUtils;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.RAMLRequest;
import com.nokia.em.bts.rp.master.message.RAMLResponse;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.Map;
import org.w3c.dom.Node;

public class IPTestSingle
extends ToolBase {
    private static final String STATUS = "\"status\">";
    private static final String PING_RESULT = "\"pingResult\">";
    private static final String DETAILS = "\"details\">";
    private static final String ARG_TABLE_ID = "tableid";
    private static final String ARG_SOURCE_IP = "sourceip";
    private static final String ARG_REMOTE_IP = "remoteip";
    private String myAddress;

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        FeedbackResult result = new FeedbackResult(this.myAddress);
        String tableId = args.getFirstValue(ARG_TABLE_ID);
        if (tableId == null) {
            tableId = "1";
        } else {
            try {
                Integer.valueOf(tableId);
            }
            catch (Exception e) {
                Console.error("Invalid router table id");
                result.setOK(false);
                result.setFeedback("Invalid router table id");
                result.setExitCode(3);
                return result;
            }
        }
        String sourceip = args.getFirstValue(ARG_SOURCE_IP);
        String targetip = args.getFirstValue(ARG_REMOTE_IP);
        if (targetip == null) {
            Console.error("Missing remote IP address");
            result.setOK(false);
            result.setFeedback("Missing remote IP address");
            result.setExitCode(3);
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            BTSConnection connection = connectionInfo.getConnection();
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connection);
            }
            result.setOperationalState(this.getOperationalStateText(site));
            Console.info("IP connectivity test started in " + this.myAddress);
            int seqnum = connection.createScenario();
            connection.sendToBTS((BTSMessage)new RAMLRequest(seqnum, XMLUtils.createRamlMessage(this.createPingRequest(connectionInfo, sourceip, targetip, tableId), "IP Connectivity Test Tool")));
            BTSMessage response = connection.receiveFromBTS(seqnum, (long)this.myTimeout);
            if (response instanceof RAMLResponse) {
                RAMLResponse ramlresponse = (RAMLResponse)response;
                if (this.isTestOK(ramlresponse)) {
                    if (this.isResultOK(ramlresponse)) {
                        Console.info("IP connection OK in " + this.myAddress);
                        result.setFeedback("Connected");
                    } else {
                        Console.error("IP connection Not OK in " + this.myAddress);
                        result.setOK(false);
                        result.setFeedback("Not connected");
                        result.setExitCode(90);
                    }
                } else {
                    Console.error("IP connectivity test failed in " + this.myAddress);
                    result.setOK(false);
                    result.setFeedback(this.getDetails(ramlresponse));
                    result.setExitCode(89);
                }
            } else if (response instanceof Timeout) {
                Console.error("IP connectivity test timeout in " + this.myAddress);
                result.setOK(false);
                result.setFeedback("Timeout");
                result.setExitCode(8);
            } else if (response == null) {
                Console.error("IP connectivity test failed in " + this.myAddress);
                result.setOK(false);
                result.setFeedback("Test failed");
                result.setExitCode(89);
            } else {
                Console.error("IP connectivity test failed due to invalid response from " + this.myAddress);
                result.setOK(false);
                result.setFeedback("Invalid response");
                result.setExitCode(89);
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private boolean isTestOK(RAMLResponse response) {
        String content = Tools.xmlToString((Node)response.getRAMLResponse());
        int index = content.indexOf(STATUS);
        if (index > 0) {
            return content.substring(index + STATUS.length(), index + STATUS.length() + 1).equalsIgnoreCase("O");
        }
        return false;
    }

    private boolean isResultOK(RAMLResponse response) {
        String content = Tools.xmlToString((Node)response.getRAMLResponse());
        int index = content.indexOf(PING_RESULT);
        if (index > 0) {
            return content.substring(index + PING_RESULT.length(), index + PING_RESULT.length() + 1).equalsIgnoreCase("T");
        }
        return false;
    }

    private String getDetails(RAMLResponse response) {
        String content = Tools.xmlToString((Node)response.getRAMLResponse());
        int index = content.indexOf(DETAILS);
        if (index > 0) {
            String s = content.substring(index + DETAILS.length());
            return s.substring(0, s.indexOf("<"));
        }
        return "";
    }

    private RAMLManagedObject createPingRequest(ConnectionInformation connectionInformation, String source, String remote, String tableid) {
        try {
            RAMLManagedObject ping = null;
            if (connectionInformation.getProduct().getAdptVersionMap().size() == 0) {
                ping = new RAMLManagedObject("FTM-1/IPNO-1", "IPNO", "action", null);
                ping.setVersion(connectionInformation.getProduct().getReleaseVersion().replace(".", ""));
            } else {
                ping = new RAMLManagedObject("FTM-1/IPNO-1", "IPNO", "action", null);
                ping.setAttribute("class", "NOKLTE:IPNO");
                ping.setVersion(connectionInformation.getProduct().getAdptVersionMap().get("NOKLTE"));
            }
            ping.setAttribute("actionName", "ping");
            if (source != null) {
                ping.setParameter(new RAMLParameter("sourceIpAddress", source));
            }
            ping.setParameter(new RAMLParameter("remoteIpAddress", remote));
            ping.setParameter(new RAMLParameter("routingTablePtr", "FTM-1/IPNO-1/IPRT-" + tableid));
            return ping;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected String getDefaultConnectionType() {
        return "read-only";
    }
}

