/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.GetSiteResult;
import com.nokia.em.bts.coreasset.application.tools.GetSiteSingle;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.TextFormattingUtils;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import com.nokia.em.bts.coreasset.configuration.Cell;
import com.nokia.em.bts.coreasset.configuration.Site;
import java.math.BigDecimal;
import java.util.List;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class RFMaximumOutputPowerImpl
extends ToolImpl {
    private static final String UNKNOWN = "Unknown";
    private static final String DIST_NAME = "_distName";
    private static final String COLUMN_RF_MAX_POWER = "Support Power";
    private static final String MAX_CARRIER_POWER = "MaxCarrierPower";
    private static final String P_MAX = "pMax";
    private static final String COLUMN_CELL = "Cell Id";
    private static final String DBM = "dBm";
    private String myShortResult;
    private ToolSummaryTable mySummaryTable = new ToolSummaryTable("Site", "Site Status", "Cell Id", "Support Power");

    public RFMaximumOutputPowerImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return COLUMN_RF_MAX_POWER;
    }

    @Override
    public String getVersion() {
        return "2.1";
    }

    @Override
    public String getFilePrefix() {
        return "GetSupportPower";
    }

    @Override
    public String getResults() {
        return this.mySummaryTable.toString();
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new GetSiteSingle();
    }

    @Override
    protected void updateResults(OperationResult result) {
        GetSiteResult siteResult = (GetSiteResult)result;
        if (siteResult.getSite() == null) {
            this.addResultForFailedSiteFetch(result);
            result.setExitCode(46);
            return;
        }
        this.addResultsToSummaryTable(siteResult);
        if (this.myShortResult == null) {
            this.myShortResult = this.createShortResult(siteResult);
        }
        if (this.myShortResult.equalsIgnoreCase(UNKNOWN)) {
            result.setExitCode(47);
        }
        Console.info("Successfully got support powers (" + this.myShortResult + ") from " + result.getAddress());
    }

    @Override
    public String getShortResult() {
        return this.myShortResult;
    }

    private void addResultForFailedSiteFetch(OperationResult result) {
        Console.error("Failed to get support powers from " + result.getAddress());
        this.mySummaryTable.addRow(result.getAddress(), UNKNOWN, UNKNOWN, UNKNOWN);
        this.myShortResult = UNKNOWN;
    }

    private void addResultsToSummaryTable(GetSiteResult siteResult) {
        String address = siteResult.getAddress();
        Site site = siteResult.getSite();
        if (site == null) {
            this.mySummaryTable.addRow(address, this.getStatusText(siteResult), UNKNOWN, UNKNOWN);
            return;
        }
        boolean firstRow = true;
        for (Cell cell : site.getCells()) {
            String cellId = this.getCellId(cell);
            String powerText = this.getPowerText(cell);
            if (firstRow) {
                this.mySummaryTable.addRow(address, this.getStatusText(siteResult), cellId, powerText);
            } else {
                this.mySummaryTable.addRow("", "", cellId, powerText);
            }
            firstRow = false;
        }
    }

    private String createShortResult(GetSiteResult siteResult) {
        List cells = siteResult.getSite().getCells();
        TreeSet<BigDecimal> powers = new TreeSet<BigDecimal>();
        for (Cell cell : cells) {
            try {
                powers.add(this.getPowerInDbms(cell));
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).error((Object)"Failed to parse max power", (Throwable)e);
            }
        }
        if (powers.isEmpty()) {
            return UNKNOWN;
        }
        BigDecimal minPower = (BigDecimal)powers.first();
        BigDecimal maxPower = (BigDecimal)powers.last();
        String result = "" + minPower;
        if (!minPower.equals(maxPower)) {
            result = String.valueOf(result) + "..." + maxPower;
        }
        int numberOfCells = cells.size();
        result = String.valueOf(result) + " dBm (" + numberOfCells + TextFormattingUtils.getPlural(" cell", numberOfCells) + ")";
        return result;
    }

    private String getPowerText(Cell cell) {
        BigDecimal powerInDbms = this.getPowerInDbms(cell);
        if (powerInDbms == null) {
            return UNKNOWN;
        }
        try {
            return powerInDbms + " " + DBM;
        }
        catch (NumberFormatException e) {
            Logger.getLogger(this.getClass()).warn((Object)("Failed to read max power for cell " + cell), (Throwable)e);
            return UNKNOWN;
        }
    }

    private BigDecimal getPowerInDbms(Cell cell) {
        String maxPower = cell.getCustomAttributeValue(P_MAX);
        if (maxPower == null) {
            maxPower = cell.getCustomAttributeValue(MAX_CARRIER_POWER);
        }
        if (maxPower != null) {
            if (this.needsToBeDividedBy10(maxPower)) {
                return new BigDecimal(maxPower).divide(new BigDecimal(10), 1, 4);
            }
            return new BigDecimal(maxPower);
        }
        return null;
    }

    private boolean needsToBeDividedBy10(String maxPower) {
        return !maxPower.contains(".");
    }

    private String getCellId(Cell cell) {
        String cellId = cell.getCustomAttributeValue(DIST_NAME);
        if (cellId != null) {
            return cellId;
        }
        return "" + cell.getGlobalCellId();
    }
}

