/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.mathworks.toolbox.javabuilder.MWException;
import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.scenario.ScenarioManager;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.btstests.rftest.RFCell;
import com.nokia.em.bts.coreasset.scenario.btstests.rftest.RFTest;
import com.nokia.em.bts.coreasset.scenario.btstests.rftest.RFTestListener;
import com.nokia.em.bts.rfview.RFScan;
import com.nokia.em.bts.rfview.conversion.ProtoBufToHDF;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.poseidon.util.PCmdLineParams;
import com.nokia.widgets.text.TimestampFormatter;
import com.nokia.widgets.util.SystemUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

public class RFMonitoringSingle
extends ToolBase {
    private static final String ARG_TPYE = "type";
    private static final String[] TPYE_VALUE = new String[]{"RFScanning"};
    private static final String ARG_CELL = "cell";
    private static final String ARG_ANTENNA = "antenna";
    private static final int CAPLENGTH_DEFAULT_VALUE = 10;
    private static final String ARG_CAPTYPE = "captype";
    private static final String[] CAPTPYE_VALUE = new String[]{"RX_COMBINED", "RX_COMBINED_RAW", "RX_CARRIER"};
    private static boolean isMatLabInstalled;
    private String myAddress;
    private String mySiteName;

    static {
        try {
            new RFScan();
            isMatLabInstalled = true;
        }
        catch (Throwable e) {
            isMatLabInstalled = false;
            Logger.getLogger(RFMonitoringSingle.class).error((Object)"Error in initializing MATLAB", e);
            RFMonitoringSingle.logPathVariables();
        }
    }

    private static void logPathVariables() {
        Logger logger = Logger.getLogger(RFMonitoringSingle.class);
        logger.error((Object)("PATH=" + System.getenv("PATH")));
        if (!SystemUtils.isWindows()) {
            logger.error((Object)("LD_LIBRARY_PATH=" + System.getenv("LD_LIBRARY_PATH")));
        }
    }

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        FeedbackResult result = new FeedbackResult(this.myAddress);
        if (!isMatLabInstalled) {
            Console.error("Matlab runtime is not installed, please download the matlab from http://cn.mathworks.com/products/compiler/mcr/.");
            result.setOK(false);
            result.setFeedback("Matlab runtime not installed");
            result.setExitCode(120);
            return result;
        }
        if (!this.isParametersValid(args, result)) {
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(btsInformation.getBTSAddress(), btsInformation.getUserName(), btsInformation.getPassword(), this.getCredentialsFrom(args));
            disconnect = true;
        }
        BTSConnection connection = connectionInfo.getConnection();
        if (connectionInfo.isConnected()) {
            Site site = this.getSite(connectionInfo);
            this.setSiteName(site.getName());
            result.setOperationalState(this.getOperationalStateText(site));
            List units = site.getCabinet().getUnits();
            String argAntenna = args.getFirstValue(ARG_ANTENNA);
            Unit antUnit = null;
            for (Unit unit : units) {
                if (!"AntennaLine".equals(unit.getUnitType()) || !argAntenna.equals(unit.getDistName())) continue;
                antUnit = unit;
                break;
            }
            if (antUnit == null) {
                result.setOK(false);
                result.setFeedback("Antenna not found");
                result.setExitCode(121);
                Console.error("RF Monitoring failed (" + argAntenna + " not found) in" + this.myAddress);
            } else {
                ScenarioManagerImpl scenarioManager = new ScenarioManagerImpl(connection);
                if (connection.isBTSConnected()) {
                    RFTest rfTest = this.createRFTest(args);
                    File file = this.getRFScanFile(connectionInfo, (ScenarioManager)scenarioManager, rfTest, result, antUnit);
                    if (file != null) {
                        Console.info("Successfully got " + file.getName() + " from " + this.myAddress);
                    } else {
                        Console.error("Failed to get file from " + this.myAddress);
                    }
                }
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private boolean isParametersValid(PCmdLineParams args, FeedbackResult result) {
        boolean typeDefined = args.isDefined(ARG_TPYE);
        if (typeDefined) {
            if (!this.isValueValid(TPYE_VALUE, args.getFirstValue(ARG_TPYE))) {
                Console.error("Invalid type value, type value must be RFScanning");
                result.setOK(false);
                result.setFeedback("Invalid type value");
                result.setExitCode(3);
                return false;
            }
        } else {
            Console.error("Parameter -type is mandatory");
            result.setOK(false);
            result.setFeedback("Missing Parameters");
            result.setExitCode(3);
            return false;
        }
        boolean captypeDefined = args.isDefined(ARG_CAPTYPE);
        if (captypeDefined) {
            if (!this.isValueValid(CAPTPYE_VALUE, args.getFirstValue(ARG_CAPTYPE))) {
                Console.error("Invalid captype value, captype value must be RX_COMBINED|RX_COMBINED_RAW|RX_CARRIER");
                result.setOK(false);
                result.setFeedback("Invalid captype value");
                result.setExitCode(3);
                return false;
            }
            boolean cellDefined = args.isDefined(ARG_CELL);
            if (args.getFirstValue(ARG_CAPTYPE).equals(CAPTPYE_VALUE[2]) && !cellDefined) {
                Console.error("Parameter -cell is mandatory when captype is RX_CARRIER");
                result.setOK(false);
                result.setFeedback("Missing Parameters");
                result.setExitCode(3);
                return false;
            }
        } else {
            Console.error("Parameter -captype is mandatory");
            result.setOK(false);
            result.setFeedback("Missing Parameters");
            result.setExitCode(3);
            return false;
        }
        boolean antennaDefined = args.isDefined(ARG_ANTENNA);
        if (!antennaDefined) {
            Console.error("Parameter -antenna is mandatory");
            result.setOK(false);
            result.setFeedback("Missing Parameters");
            result.setExitCode(3);
            return false;
        }
        return true;
    }

    private boolean isValueValid(String[] tpyeValue, String value) {
        String[] stringArray = tpyeValue;
        int n = tpyeValue.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.equalsIgnoreCase(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Site getSite(ConnectionInformation connectionInfo) {
        Site site = connectionInfo.getSite();
        if (site == null) {
            site = this.buildHWModel(connectionInfo.getConnection());
        }
        return site;
    }

    private RFTest createRFTest(PCmdLineParams args) {
        RFTest rfTest = null;
        if (args.getFirstValue(ARG_CAPTYPE).equals(CAPTPYE_VALUE[2])) {
            RFCell rfCell = new RFCell(Integer.parseInt(args.getFirstValue(ARG_CELL)));
            rfTest = new RFTest(args.getFirstValue(ARG_ANTENNA), rfCell, 10);
        } else {
            rfTest = new RFTest(args.getFirstValue(ARG_ANTENNA), 10, RFTest.CaptureType.valueOf((String)args.getFirstValue(ARG_CAPTYPE)));
        }
        return rfTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getRFScanFile(ConnectionInformation connectionInfo, ScenarioManager scenarioManager, RFTest rfTest, final FeedbackResult result, Unit antUnit) {
        RFTestListener cell;
        final File[] files = new File[1];
        RFTestListener rftestListener = new RFTestListener(){

            public void started() {
                Console.info("RF Monitoring started in " + RFMonitoringSingle.this.myAddress);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startFailed(RFTestListener.StartFailure failReason) {
                result.setExitCode(80);
                Console.info("RF Monitoring start failed(" + failReason + ") in " + RFMonitoringSingle.this.myAddress);
                1 var2_2 = this;
                synchronized (var2_2) {
                    this.notify();
                }
            }

            public void fileTransferStarted() {
                Console.info("Downloading RF Monitoring files from " + RFMonitoringSingle.this.myAddress);
            }

            public void fileReceived(String filename, String path) {
                files[0] = new File(path);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void aborted() {
                result.setExitCode(81);
                Console.info(" RF Monitoring aborted in " + RFMonitoringSingle.this.myAddress);
                1 var1_1 = this;
                synchronized (var1_1) {
                    this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void timeout() {
                result.setExitCode(8);
                Console.info("RF Monitoring timeout in " + RFMonitoringSingle.this.myAddress);
                1 var1_1 = this;
                synchronized (var1_1) {
                    this.notify();
                }
            }

            public void abortFailed(RFTestListener.AbortFailure failReason) {
                Console.info("RF Monitoring abort failed(" + failReason + ") in " + RFMonitoringSingle.this.myAddress);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(RFTestListener.TestSuccess success) {
                if (success == RFTestListener.TestSuccess.OK) {
                    Console.info("RF Monitoring successfully completed in " + RFMonitoringSingle.this.myAddress);
                } else {
                    Console.error("RF Monitoring completed(" + success + ") in " + RFMonitoringSingle.this.myAddress);
                }
                if (result.isOK()) {
                    result.setExitCode(this.getExitCode(success));
                    result.setOK(success == RFTestListener.TestSuccess.OK);
                }
                1 var2_2 = this;
                synchronized (var2_2) {
                    this.notify();
                }
            }

            public void fileTransferFailed(String filename) {
                result.setExitCode(86);
                Console.error("Failed to receive " + RFMonitoringSingle.this.removePathFromFilename(filename) + " from " + RFMonitoringSingle.this.myAddress);
            }

            private int getExitCode(RFTestListener.TestSuccess success) {
                switch (success) {
                    case OK: {
                        return 0;
                    }
                    case UNABLE_TO_STORE_FILE: {
                        return 82;
                    }
                    case UNABLE_TO_GENERATE_FILE: {
                        return 83;
                    }
                    case UNABLE_TO_EXECUTE: {
                        return 84;
                    }
                    case TELECOM_NOT_RESPONDING: {
                        return 87;
                    }
                    case TELECOM_NOT_RELEASED: {
                        return 88;
                    }
                }
                return 85;
            }
        };
        String dateOfCapture = TimestampFormatter.applyShortFormat((Calendar)Calendar.getInstance());
        String antennaId = "";
        String antennaName = "";
        String cellName = "-";
        String radioUnitName = "";
        String radioSerialNumber = "";
        String radioUnitNumber = "";
        if (antUnit != null) {
            antennaId = "ANT" + antUnit.getNumber();
            antennaName = "ANT " + antUnit.getNumber();
            radioUnitName = antUnit.getParentUnit().getUnitName();
            radioSerialNumber = antUnit.getParentUnit().getSerialNro();
            radioUnitNumber = antUnit.getParentUnit().getCustomAttributeValue("connectionList");
            radioUnitNumber = radioUnitNumber.replace(".0.", ".");
        }
        if (rfTest.getCells() != null) {
            cell = (RFCell)rfTest.getCells().get(0);
            cellName = cell.getLcrId() != -1 ? String.valueOf(cell.getLcrId()) : "-";
        }
        cell = rftestListener;
        synchronized (cell) {
            scenarioManager.getRFTestScenario(rftestListener, RFTestListener.TestInfo.RFSCANNING, rfTest).execute();
            try {
                rftestListener.wait();
            }
            catch (InterruptedException e) {
                Logger.getLogger(this.getClass()).error((Object)("RFTest listener interrupted in " + this.myAddress), (Throwable)e);
            }
        }
        File hdfFile = this.createHDFFile();
        try {
            this.convertProtoBufToHDF(files[0], hdfFile, this.getSiteName(), this.getSiteName(), cellName, "", antennaName, antennaId, dateOfCapture, "", radioUnitName, radioSerialNumber, radioUnitNumber);
            return hdfFile;
        }
        catch (Exception e) {
            Console.error("Convert to hdf file failed in " + this.myAddress, e);
            return null;
        }
    }

    private File createHDFFile() {
        String fileName = String.valueOf(this.getOutDir()) + "RFMonitoring_" + this.mySiteName + "_RFScan_" + this.getDate(Calendar.getInstance()) + "-" + this.getTimeStamp("HHmm");
        String suffix = ".hdf";
        File file = new File(String.valueOf(fileName) + suffix);
        int index = 0;
        while (file.exists()) {
            file = new File(String.valueOf(fileName) + "(" + ++index + ")" + suffix);
        }
        return file;
    }

    private void convertProtoBufToHDF(File protoBuf, File hdfFile, Object btsName, Object btsSCName, Object cellName, Object cellTxRxUsage, Object antennaName, Object antennaId, Object dateOfCapture, Object timeOFCapture, Object radioUnitName, Object radioSerialNumber, Object radioUnitNumber) throws MWException {
        ProtoBufToHDF protoBufToHDF = new ProtoBufToHDF();
        Object[] input = new Object[]{hdfFile.toString(), protoBuf.toString(), btsName, btsSCName, cellName, cellTxRxUsage, antennaName, antennaId, dateOfCapture, this.getTimeStamp("HH:mm:ss"), radioUnitName, radioSerialNumber, radioUnitNumber};
        protoBufToHDF.create_hdf_file(0, input);
        if (this.myVerbose) {
            if (this.copyFile(protoBuf, new File(hdfFile.getPath().replaceAll("hdf", "rfcap")))) {
                Console.debug("Save original capture file successfully in " + this.myAddress);
            } else {
                Console.warn("Failed to save original capture file in " + this.myAddress);
            }
        }
        protoBufToHDF.dispose();
    }

    public String getDate(Calendar time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        dateFormat.setTimeZone(time.getTimeZone());
        return dateFormat.format(time.getTime());
    }

    protected String getTimeStamp(String timeFormat) {
        Calendar time = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat(timeFormat);
        dateFormat.setTimeZone(time.getTimeZone());
        return dateFormat.format(time.getTime());
    }

    public String getSiteName() {
        return this.mySiteName;
    }

    public void setSiteName(String siteName) {
        this.mySiteName = siteName;
    }

    @Override
    protected String getDefaultConnectionType() {
        return "read-only";
    }
}

