/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.btstests.rftest.RFCell;
import com.nokia.em.bts.coreasset.scenario.btstests.rftest.RFTest;
import com.nokia.em.bts.coreasset.scenario.btstests.rftest.RFTestListener;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;

public class RFTestSingle
extends ToolBase {
    private static final String ARG_INTERMODULATION = "intermodulation";
    private static final String ARG_CAPTYPE = "captype";
    private static final String ARG_CAPLENGTH = "caplength";
    private static final String ARG_ANTENNA = "antenna";
    private static final String ARG_CELL = "cell";
    private static final String ARG_TYPE = "type";
    private String myAddress;
    private RFTestListener.TestInfo myTestInfo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        FeedbackResult result = new FeedbackResult(this.myAddress);
        this.myTestInfo = this.getTestInfo(args.getFirstValue(ARG_TYPE));
        if (this.myTestInfo == null) {
            Console.error("Invalid or missing test type");
            result.setOK(false);
            result.setFeedback("Invalid or missing test type");
            result.setExitCode(3);
            return result;
        }
        RFCell cell = null;
        try {
            cell = this.getCell(args.getFirstValue(ARG_CELL));
        }
        catch (Exception e) {
            Console.error("Invalid or missing cell");
            result.setOK(false);
            result.setFeedback("Invalid or missing cell");
            result.setExitCode(3);
            return result;
        }
        String antenna = args.getFirstValue(ARG_ANTENNA);
        if (antenna == null) {
            Console.error("Invalid or missing antenna");
            result.setOK(false);
            result.setFeedback("Invalid or missing antenna");
            result.setExitCode(3);
            return result;
        }
        String intermodulation = args.getFirstValue(ARG_INTERMODULATION);
        if (this.myTestInfo == RFTestListener.TestInfo.PIMSWEEP && intermodulation == null) {
            Console.error("Invalid or missing intermodulation");
            result.setOK(false);
            result.setFeedback("Invalid or missing intermodulation");
            result.setExitCode(3);
            return result;
        }
        int captureLength = 10;
        try {
            if (args.isDefined(ARG_CAPLENGTH)) {
                captureLength = Integer.valueOf(args.getFirstValue(ARG_CAPLENGTH));
            }
        }
        catch (Exception e) {
            Console.error("Invalid capture length");
            result.setOK(false);
            result.setFeedback("Invalid capture length");
            result.setExitCode(3);
            return result;
        }
        RFTest.CaptureType captureType = this.getCaptureType(args.getFirstValue(ARG_CAPTYPE));
        if (this.myTestInfo == RFTestListener.TestInfo.RFSCANNING && captureType == null) {
            Console.error("Invalid or missing capture type");
            result.setOK(false);
            result.setFeedback("Invalid or missing capture type");
            result.setExitCode(3);
            return result;
        }
        if (cell == null && (this.myTestInfo != RFTestListener.TestInfo.RFSCANNING || captureType == RFTest.CaptureType.RX_CARRIER)) {
            Console.error("Missing cell");
            result.setOK(false);
            result.setFeedback("Missing cell");
            result.setExitCode(3);
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            TestListener listener;
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connectionInfo.getConnection());
            }
            result.setOperationalState(this.getOperationalStateText(site));
            RFTest rfTest = null;
            block5 : switch (this.myTestInfo) {
                case RFSCANNING: {
                    switch (captureType) {
                        case RX_CARRIER: {
                            rfTest = new RFTest(antenna, cell, captureLength);
                            break block5;
                        }
                    }
                    rfTest = new RFTest(antenna, captureLength, captureType);
                    break;
                }
                case PIMSWEEP: {
                    rfTest = new RFTest(antenna, cell, intermodulation);
                    break;
                }
                case PIMDTP: 
                case PIMDESENSITIZATION: {
                    rfTest = new RFTest(antenna, cell);
                }
            }
            TestListener testListener = listener = new TestListener(result);
            synchronized (testListener) {
                new ScenarioManagerImpl(connectionInfo.getConnection()).getRFTestScenario((RFTestListener)listener, this.myTestInfo, rfTest).execute();
                try {
                    listener.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private RFCell getCell(String s) throws Exception {
        StringTokenizer st = new StringTokenizer(s, ":");
        switch (st.countTokens()) {
            case 1: {
                return new RFCell(Integer.valueOf(st.nextToken()).intValue());
            }
            case 2: {
                return new RFCell(Integer.valueOf(st.nextToken()).intValue(), Float.valueOf(st.nextToken()).floatValue());
            }
            case 4: {
                return new RFCell(Integer.valueOf(st.nextToken()).intValue(), Float.valueOf(st.nextToken()).floatValue(), Integer.valueOf(st.nextToken()).intValue(), Integer.valueOf(st.nextToken()).intValue());
            }
        }
        return null;
    }

    private RFTestListener.TestInfo getTestInfo(String testName) {
        try {
            return RFTestListener.TestInfo.valueOf((String)testName.toUpperCase());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private RFTest.CaptureType getCaptureType(String capType) {
        try {
            return RFTest.CaptureType.valueOf((String)capType.toUpperCase());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected String getDefaultConnectionType() {
        return "read-only";
    }

    private final class TestListener
    implements RFTestListener {
        private FeedbackResult myResult;

        public TestListener(FeedbackResult result) {
            this.myResult = result;
        }

        public void started() {
            Console.info(RFTestSingle.this.myTestInfo + " test started in " + RFTestSingle.this.myAddress);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startFailed(RFTestListener.StartFailure failReason) {
            Console.error("Failed to start " + RFTestSingle.this.myTestInfo + " test in " + RFTestSingle.this.myAddress + ": " + failReason);
            this.myResult.setExitCode(80);
            this.myResult.setFeedback(failReason.toString());
            this.myResult.setOK(false);
            TestListener testListener = this;
            synchronized (testListener) {
                this.notify();
            }
        }

        public void fileTransferStarted() {
            Console.info("Downloading RF Monitoring files from " + RFTestSingle.this.myAddress);
        }

        public void fileReceived(String filename, String path) {
            String s = String.valueOf(RFTestSingle.this.getOutDir()) + RFTestSingle.this.myAddress + "_" + RFTestSingle.this.removePathFromFilename(filename);
            File file = new File(path);
            RFTestSingle.this.copyFile(file, new File(s));
            if (!RFTestSingle.this.myDebug) {
                Tools.deleteFile((File)file);
            }
            Console.info("Successfully received " + s + " for " + RFTestSingle.this.myTestInfo + " test from " + RFTestSingle.this.myAddress);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void aborted() {
            Console.info(RFTestSingle.this.myTestInfo + " test aborted in " + RFTestSingle.this.myAddress);
            this.myResult.setExitCode(81);
            this.myResult.setFeedback("Aborted");
            this.myResult.setOK(false);
            TestListener testListener = this;
            synchronized (testListener) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeout() {
            Console.info(RFTestSingle.this.myTestInfo + " test timeout in " + RFTestSingle.this.myAddress);
            this.myResult.setExitCode(8);
            this.myResult.setFeedback("Timeout");
            this.myResult.setOK(false);
            TestListener testListener = this;
            synchronized (testListener) {
                this.notify();
            }
        }

        public void abortFailed(RFTestListener.AbortFailure failReason) {
            Console.info("Failed to abort " + RFTestSingle.this.myTestInfo + " test in " + RFTestSingle.this.myAddress + ": " + failReason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(RFTestListener.TestSuccess success) {
            if (success == RFTestListener.TestSuccess.OK) {
                Console.info(RFTestSingle.this.myTestInfo + " test successfully completed in " + RFTestSingle.this.myAddress);
            } else {
                Console.error(RFTestSingle.this.myTestInfo + " test completed in " + RFTestSingle.this.myAddress + ": " + success);
            }
            if (this.myResult.isOK()) {
                this.myResult.setExitCode(this.getExitCode(success));
                this.myResult.setFeedback(success.toString());
                this.myResult.setOK(success == RFTestListener.TestSuccess.OK);
            }
            TestListener testListener = this;
            synchronized (testListener) {
                this.notify();
            }
        }

        public void fileTransferFailed(String filename) {
            Console.error("Failed to receive " + RFTestSingle.this.removePathFromFilename(filename) + " for " + RFTestSingle.this.myTestInfo + " test from " + RFTestSingle.this.myAddress);
            this.myResult.setExitCode(86);
            this.myResult.setFeedback("File transfer failed");
            this.myResult.setOK(false);
        }

        private int getExitCode(RFTestListener.TestSuccess success) {
            switch (success) {
                case OK: {
                    return 0;
                }
                case UNABLE_TO_STORE_FILE: {
                    return 82;
                }
                case UNABLE_TO_GENERATE_FILE: {
                    return 83;
                }
                case UNABLE_TO_EXECUTE: {
                    return 84;
                }
                case TELECOM_NOT_RESPONDING: {
                    return 87;
                }
                case TELECOM_NOT_RELEASED: {
                    return 88;
                }
            }
            return 85;
        }
    }
}

