/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import java.util.Date;

public class RXTestResult {
    private static final String STATUS_OK = "ok";
    private boolean myResultStatus;
    private int myLcrId;
    private float myThroughputPercentage;
    private int myPercentageCount = 1;
    private long myReceivedBits;
    private long myDefectedBits;
    private long myReceivedBlocks;
    private long myUnreceivedBlocks;
    private Date myDate;

    public RXTestResult(Date date, String resultStatus, int lcrId, float throughputPercentage, long receivedBits, long defectedBits, long receivedBlocks, long unreceivedBlocks) {
        this.myDate = date;
        this.myResultStatus = resultStatus.equalsIgnoreCase(STATUS_OK);
        this.myLcrId = lcrId;
        this.myThroughputPercentage = throughputPercentage;
        this.myReceivedBits = receivedBits;
        this.myDefectedBits = defectedBits;
        this.myReceivedBlocks = receivedBlocks;
        this.myUnreceivedBlocks = unreceivedBlocks;
    }

    public boolean isOK() {
        return this.myResultStatus;
    }

    public int getLcrId() {
        return this.myLcrId;
    }

    public float getThroughputPercentage() {
        return this.myThroughputPercentage / (float)this.myPercentageCount;
    }

    public long getReceivedBits() {
        return this.myReceivedBits;
    }

    public long getDefectedBits() {
        return this.myDefectedBits;
    }

    public long getReceivedBlocks() {
        return this.myReceivedBlocks;
    }

    public long getUnreceivedBlocks() {
        return this.myUnreceivedBlocks;
    }

    public Date getDate() {
        return this.myDate;
    }

    public void add(RXTestResult rx) {
        this.myDefectedBits += rx.getDefectedBits();
        this.myReceivedBits += rx.getReceivedBits();
        this.myUnreceivedBlocks += rx.getUnreceivedBlocks();
        this.myReceivedBlocks += rx.getReceivedBlocks();
        this.myThroughputPercentage += rx.getThroughputPercentage();
        ++this.myPercentageCount;
    }
}

