/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.RemoteResults;
import com.nokia.em.bts.coreasset.application.tools.RemoteSingle;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RemoteImpl
extends ToolImpl {
    private static final String COLUMN_CLIENT = "Client";
    private static final String COLUMN_SESSION = "Session duration";
    private List<RemoteResults> myResults = new ArrayList<RemoteResults>();

    public RemoteImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        this.myMaxConcurrentSites = 1;
        return "Remote";
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    @Override
    public String getFilePrefix() {
        return "Remote";
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add((RemoteResults)result);
    }

    @Override
    public String getResults() {
        ToolSummaryTable table = new ToolSummaryTable();
        this.generateColumnsTo(table);
        this.generateRowsTo(table);
        return table.toString();
    }

    @Override
    public String getShortResult() {
        return "";
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new RemoteSingle();
    }

    private void generateColumnsTo(ToolSummaryTable table) {
        table.addColumn(COLUMN_CLIENT);
        table.addColumn(COLUMN_SESSION);
    }

    private void generateRowsTo(ToolSummaryTable table) {
        for (RemoteResults br : this.myResults) {
            this.generateRow(table, br);
        }
    }

    private void generateRow(ToolSummaryTable table, RemoteResults results) {
        for (Map.Entry<String, String> entry : results.getClients().entrySet()) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(entry.getKey());
            values.add(entry.getValue());
            table.addRow(values);
        }
    }
}

