/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.CoreAssetToolApplication;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.RemoteResults;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.AnyMessage;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.JSONRPCError;
import com.nokia.em.bts.coreasset.application.util.JSONRPCObject;
import com.nokia.em.bts.coreasset.application.util.TextFormattingUtils;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.poseidon.util.PCmdLineParams;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.json.JSONException;

public class RemoteSingle
extends ToolBase {
    public static final String PARAM_MESSAGE = "message";
    private static final String RESULT_OK = "OK";
    private static final String MESSAGE_SENT = "Message sent";
    public static final String METHOD_QUIT = "quit";
    private static final String METHOD_STATUS = "status";
    private static final String METHOD_DISCONNECT = "disconnect";
    private static final String METHOD_CONNECT = "connect";
    public static final String METHOD_EXIT = "exit";
    public static final String METHOD_SENDTOBTS = "sendtobts";
    public static final String METHOD_SENDTOTRS = "sendtotrs";
    public static final String METHOD_SUPPORTS = "supports";
    public static final String METHOD_TIMEOUT = "timeout";
    private static final Object PARAM_VALUE = "value";
    private boolean myServerRunning = true;
    private boolean myClientRunning = true;
    private Timer myIdleTimer = new Timer();
    private int myIdleTimeout = 60;
    private static final int theIdleTimeoutFactor = 60000;
    private static final String ARG_RPCPORT = "rpcport";
    private static final String ARG_IDLE_TIMEOUT = "idletimeout";
    private ConnectionInformation myConnectionInfo = new ConnectionInformation();
    private long myClientConnectionTime;

    @Override
    protected void reset() {
        this.myServerRunning = true;
        this.myClientRunning = true;
        this.myIdleTimer = new Timer();
        this.myIdleTimeout = 60;
    }

    /*
     * Loose catch block
     */
    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        this.parseCommonParamsFrom(args);
        RemoteResults result = new RemoteResults();
        if (args.getFirstValue(ARG_IDLE_TIMEOUT) != null) {
            int timeout = Integer.valueOf(args.getFirstValue(ARG_IDLE_TIMEOUT));
            if (timeout > 0) {
                this.myIdleTimeout = timeout * 60000;
            } else {
                Console.error("Invalid idle timeout");
                result.setExitCode(3);
                result.setOK(false);
                return result;
            }
        }
        int port = 0;
        ServerSocket serverSocket = null;
        try {
            port = Integer.valueOf(args.getFirstValue(ARG_RPCPORT));
        }
        catch (Exception e) {
            Console.error("RPC server port not given");
            result.setOK(false);
            result.setExitCode(3);
            return result;
        }
        try {
            serverSocket = new ServerSocket(port);
        }
        catch (Exception e) {
            Console.error("Failed to open RPC server to port " + port, e);
            result.setOK(false);
            result.setExitCode(72);
            return result;
        }
        Console.info("RPC server started to port " + port);
        do {
            Socket socket = null;
            String address = null;
            try {
                socket = serverSocket.accept();
                address = socket.getInetAddress().getHostAddress();
                Console.info("Client connected from " + address);
                this.myClientConnectionTime = System.currentTimeMillis();
                DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                this.myClientRunning = true;
                int intLength = 0;
                boolean isHttpConnction = false;
                do {
                    String strInputLine;
                    if ((strInputLine = in.readLine()) != null) {
                        if (strInputLine.length() > 0) {
                            String strComp = strInputLine.toLowerCase();
                            if (!(isHttpConnction || strComp.startsWith("get") || strComp.startsWith("post"))) {
                                out.writeBytes(String.valueOf(this.processJSON(strInputLine)) + "\n");
                                continue;
                            }
                            isHttpConnction = true;
                            if (!strComp.startsWith("content-length")) continue;
                            StringTokenizer st = new StringTokenizer(strInputLine, ":");
                            st.nextToken();
                            String strLength = st.nextToken().trim();
                            intLength = Integer.parseInt(strLength);
                            continue;
                        }
                        if (intLength > 0) {
                            char[] chrBuf = new char[intLength];
                            int charsReadTotal = 0;
                            int charsRead = 0;
                            while (charsReadTotal < intLength && charsRead >= 0) {
                                charsRead = in.read(chrBuf, charsReadTotal, intLength - charsReadTotal);
                                if (charsRead <= 0) continue;
                                charsReadTotal += charsRead;
                            }
                            strInputLine = String.valueOf(chrBuf);
                            if (strInputLine != null && strInputLine.length() > 0) {
                                String jsonString = this.processJSON(strInputLine);
                                out.writeBytes("HTTP/1.1 200 OK\r\n");
                                out.writeBytes("Server: CLI-REMOTE/1.2\r\n");
                                out.writeBytes("Content-Type: application/json\r\n");
                                out.writeBytes("Content-Length: " + jsonString.length() + "\r\n");
                                out.writeBytes("\r\n");
                                out.writeBytes(String.valueOf(jsonString) + "\n");
                                out.close();
                            }
                            this.disconnect(result, address);
                            continue;
                        }
                        this.disconnect(result, address);
                        continue;
                    }
                    this.disconnect(result, address);
                } while (this.myClientRunning);
            }
            catch (SocketException se) {
                Console.info("Client disconnected from " + address, se);
                result.add(address, TextFormattingUtils.formatExecutionTime(System.currentTimeMillis() - this.myClientConnectionTime));
                address = null;
                try {
                    socket.close();
                }
                catch (Exception ioe) {
                    Logger.getLogger(this.getClass()).error((Object)"Error while closing server socket", (Throwable)ioe);
                }
                continue;
            }
            catch (JSONException je) {
                Console.error("Invalid JSON request received, disconnected client from " + address, (Exception)((Object)je));
                result.add(address, TextFormattingUtils.formatExecutionTime(System.currentTimeMillis() - this.myClientConnectionTime));
                address = null;
                continue;
            }
            catch (Exception e) {
                block36: {
                    Console.error("Server socket error, shutting down", e);
                    result.setOK(false);
                    result.setExitCode(7);
                    this.myServerRunning = false;
                    if (address == null) break block36;
                    result.add(address, TextFormattingUtils.formatExecutionTime(System.currentTimeMillis() - this.myClientConnectionTime));
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                try {
                    socket.close();
                }
                catch (Exception ioe) {
                    Logger.getLogger(this.getClass()).error((Object)"Error while closing server socket", (Throwable)ioe);
                }
                continue;
            }
            {
                finally {
                    try {
                        socket.close();
                    }
                    catch (Exception ioe) {
                        Logger.getLogger(this.getClass()).error((Object)"Error while closing server socket", (Throwable)ioe);
                    }
                }
            }
            try {
                socket.close();
            }
            catch (Exception ioe) {
                Logger.getLogger(this.getClass()).error((Object)"Error while closing server socket", (Throwable)ioe);
            }
        } while (this.myServerRunning);
        try {
            serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected void disconnect(RemoteResults result, String address) {
        this.myClientRunning = false;
        Console.info("Client disconnected from " + address);
        result.add(address, TextFormattingUtils.formatExecutionTime(System.currentTimeMillis() - this.myClientConnectionTime));
    }

    public String processJSON(String received) throws JSONException {
        JSONRPCObject response = new JSONRPCObject();
        Logger.getLogger(this.getClass()).debug((Object)("JSON received: " + received));
        JSONRPCObject request = new JSONRPCObject(received);
        response.setId(request.getId());
        String method = request.getMethod();
        if (METHOD_CONNECT.equalsIgnoreCase(method)) {
            this.handleConnect(request, response);
        } else if (METHOD_DISCONNECT.equalsIgnoreCase(method)) {
            this.handleDisconnect(response);
        } else if (METHOD_STATUS.equalsIgnoreCase(method)) {
            this.handleStatus(response);
        } else if (METHOD_QUIT.equalsIgnoreCase(method) || METHOD_EXIT.equalsIgnoreCase(method)) {
            this.handleQuit(response);
        } else if (METHOD_SUPPORTS.equalsIgnoreCase(method)) {
            this.handleSupports(response);
        } else if (METHOD_SENDTOBTS.equalsIgnoreCase(method)) {
            this.handleSendToBTS(request, response);
        } else if (METHOD_SENDTOTRS.equalsIgnoreCase(method)) {
            this.handleSendToTRS(request, response);
        } else if (METHOD_TIMEOUT.equalsIgnoreCase(method)) {
            this.handleTimeout(request, response);
        } else {
            this.handleTool(request, response, method);
        }
        Logger.getLogger(this.getClass()).debug((Object)("JSON sent: " + (Object)((Object)response)));
        return response.toString();
    }

    private void handleTimeout(JSONRPCObject request, JSONRPCObject response) {
        block6: {
            Object message = request.getNamedParameters().get(PARAM_MESSAGE);
            if (message == null) {
                message = request.getNamedParameters().get(PARAM_VALUE);
            }
            if (message != null) {
                String text = "Invalid timeout";
                try {
                    int newTimeout = Integer.valueOf(message.toString());
                    if (newTimeout > 0) {
                        this.myIdleTimeout = newTimeout;
                        Console.info(RESULT_OK);
                        response.setResult(RESULT_OK);
                        break block6;
                    }
                    Console.error(text);
                    response.setError(new JSONRPCError(3, text));
                }
                catch (Exception e) {
                    Console.error(text);
                    response.setError(new JSONRPCError(3, text));
                }
            } else {
                String text = String.valueOf(this.myIdleTimeout) + " minutes";
                Console.info(text);
                response.setResult(text);
            }
        }
        this.restartIdleTimer();
    }

    private void handleTool(JSONRPCObject request, JSONRPCObject response, String method) {
        ToolImpl tool = CoreAssetToolApplication.getToolImpl(method);
        if (tool == null) {
            String text = "Failed to launch " + method;
            Console.error(text);
            response.setError(new JSONRPCError(2, text));
        } else if (this.myConnectionInfo.getConnection() == null || !this.myConnectionInfo.getConnection().isBTSConnected()) {
            String text = String.valueOf(tool.getName()) + " Tool called but not connected";
            Console.error(text);
            response.setError(new JSONRPCError(73, text));
        } else {
            this.cancelIdleTimer();
            OperationResult toolResult = tool.execute(this.myConnectionInfo, this.getCmdLineParams(request.getNamedParameters()));
            String shortResult = tool.getShortResult();
            if (toolResult.getExitCode() == 0) {
                response.setResult(shortResult);
            } else {
                response.setError(new JSONRPCError(toolResult.getExitCode(), shortResult));
            }
        }
        this.restartIdleTimer();
    }

    private void handleConnect(JSONRPCObject request, JSONRPCObject response) {
        if (this.myConnectionInfo.getConnection() != null && this.myConnectionInfo.getConnection().isBTSConnected()) {
            String text = "Already connected to " + this.myConnectionInfo.getAddress();
            Console.error(text);
            response.setError(new JSONRPCError(74, text));
        } else {
            Object ne = request.getNamedParameters().get("ne");
            Object pw = request.getNamedParameters().get("pw");
            if (ne == null || ne.toString().trim().length() == 0) {
                String text = "Address missing";
                Console.error(text);
                response.setError(new JSONRPCError(3, text));
            } else if (pw == null) {
                String text = "Username and password missing";
                Console.error(text);
                response.setError(new JSONRPCError(3, text));
            } else if (pw.toString().split(":").length != 2) {
                String text = "Invalid format for username and password";
                Console.error(text);
                response.setError(new JSONRPCError(3, text));
            } else {
                String[] credentials = pw.toString().split(":");
                String address = ne.toString();
                String username = credentials[0];
                String password = credentials[1];
                this.connect(response, address, username, password);
            }
        }
        this.restartIdleTimer();
    }

    private void cancelIdleTimer() {
        this.myIdleTimer.cancel();
    }

    private void restartIdleTimer() {
        this.myIdleTimer.cancel();
        this.myIdleTimer = new Timer();
        this.myIdleTimer.schedule((TimerTask)new TimeoutTask(), this.myIdleTimeout * 60000);
    }

    private void connect(JSONRPCObject response, String address, String username, String password) {
        this.myConnectionInfo = this.connect(address, username, password);
        if (this.myConnectionInfo.isConnected()) {
            response.setResult("Connected to " + address);
        } else {
            response.setError(this.getConnectionJSONError());
        }
    }

    private void handleQuit(JSONRPCObject response) {
        this.myServerRunning = false;
        this.myClientRunning = false;
        if (this.myConnectionInfo.getConnection() != null) {
            this.myConnectionInfo.getConnection().disconnect();
        }
        response.setResult(RESULT_OK);
        this.cancelIdleTimer();
    }

    private void handleStatus(JSONRPCObject response) {
        String status = "Not connected";
        if (this.myConnectionInfo.getConnection() != null && this.myConnectionInfo.getConnection().isBTSConnected()) {
            status = "Connected to " + this.myConnectionInfo.getAddress();
        }
        Console.info(status);
        response.setResult(status);
        this.restartIdleTimer();
    }

    private void handleDisconnect(JSONRPCObject response) {
        if (this.myConnectionInfo.getConnection() != null && this.myConnectionInfo.getConnection().isBTSConnected()) {
            this.myConnectionInfo.getConnection().disconnect();
            String text = "Disconnected from " + this.myConnectionInfo.getAddress();
            Console.info(text);
            response.setResult(text);
            this.cancelIdleTimer();
        } else {
            String text = "Not connected";
            Console.error(text);
            response.setError(new JSONRPCError(73, text));
        }
    }

    private void handleSendToBTS(JSONRPCObject request, JSONRPCObject response) {
        this.handleSendToSite(request, response, BTSMessage.Type.BTS);
    }

    private void handleSendToTRS(JSONRPCObject request, JSONRPCObject response) {
        this.handleSendToSite(request, response, BTSMessage.Type.TRS);
    }

    private void handleSendToSite(JSONRPCObject request, JSONRPCObject response, BTSMessage.Type type) {
        if (this.myConnectionInfo.getConnection() == null || !this.myConnectionInfo.getConnection().isBTSConnected()) {
            String text = "Not connected";
            Console.error(text);
            response.setError(new JSONRPCError(73, text));
        } else {
            Object objMsg = request.getNamedParameters().get(PARAM_MESSAGE);
            if (objMsg == null) {
                response.setError(new JSONRPCError(3, "No message given"));
            } else {
                String message = objMsg.toString();
                try {
                    message = this.extractMessage(message);
                }
                catch (IOException e) {
                    String text = "Failed to read message file " + message;
                    Console.error(text, e);
                    response.setError(new JSONRPCError(3, text));
                    return;
                }
                try {
                    this.myConnectionInfo.getConnection().sendToBTS((BTSMessage)new AnyMessage(this.myConnectionInfo.getConnection().createScenario(), message, type));
                    Console.info(MESSAGE_SENT);
                    response.setResult(MESSAGE_SENT);
                }
                catch (Exception e) {
                    String text = "Failed to send message " + message;
                    Console.error(text, e);
                    response.setError(new JSONRPCError(3, text));
                }
            }
        }
        this.restartIdleTimer();
    }

    private String extractMessage(String str) throws IOException {
        File file = new File(str);
        if (file.exists() && file.canRead()) {
            return PFileUtils.readTextFile((String)str);
        }
        return str;
    }

    private void handleSupports(JSONRPCObject response) {
        ArrayList<String> tools = new ArrayList<String>();
        tools.addAll(this.getSupportedMethods());
        tools.addAll(CoreAssetToolApplication.getSupportedTools());
        String result = ((Object)tools).toString();
        response.setResult(result.substring(1, result.length() - 1));
        this.restartIdleTimer();
    }

    private List<String> getSupportedMethods() {
        ArrayList<String> methods = new ArrayList<String>();
        methods.add(METHOD_CONNECT);
        methods.add(METHOD_DISCONNECT);
        methods.add(METHOD_EXIT);
        methods.add(METHOD_QUIT);
        methods.add(METHOD_SENDTOBTS);
        methods.add(METHOD_SENDTOTRS);
        methods.add(METHOD_STATUS);
        methods.add(METHOD_SUPPORTS);
        methods.add(METHOD_TIMEOUT);
        return methods;
    }

    private JSONRPCError getConnectionJSONError() {
        int errorCode = 6;
        String errorText = "Login failed to " + this.myConnectionInfo.getAddress();
        if (this.myConnectionInfo.isReserved()) {
            errorText = "Connection to " + this.myConnectionInfo.getAddress() + " refused. Connection already exists.";
            errorCode = 5;
        } else if (this.myConnectionInfo.isLoggedIn()) {
            errorText = "Cannot connect to " + this.myConnectionInfo.getAddress();
            errorCode = 4;
        }
        Console.error(errorText);
        return new JSONRPCError(errorCode, errorText);
    }

    private PCmdLineParams getCmdLineParams(Map<String, Object> namedParams) {
        PCmdLineParams params = new PCmdLineParams();
        for (Map.Entry<String, Object> entry : namedParams.entrySet()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(entry.getValue().toString());
            params.storeParamValues(entry.getKey(), list);
        }
        return params;
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }

    private class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        @Override
        public void run() {
            if (RemoteSingle.this.myConnectionInfo.getConnection() != null) {
                RemoteSingle.this.myConnectionInfo.getConnection().disconnect();
            }
        }
    }
}

