/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ResetCellSingle;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.util.ArrayList;
import java.util.List;

public class ResetCellImpl
extends ToolImpl {
    private static final String COLUMN_RESULT = "Reset Cell Result";
    private List<OperationResult> myResults = new ArrayList<OperationResult>();

    public ResetCellImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return "Reset Cell";
    }

    @Override
    public String getVersion() {
        return "4.3";
    }

    @Override
    public String getFilePrefix() {
        return "ResetCell";
    }

    @Override
    public String getShortResult() {
        if (this.myResults.size() > 0) {
            return this.myResults.get(0).isOK() ? "OK" : "Not OK";
        }
        return "No results";
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new ResetCellSingle(ResetCellSingle.Operation.RESET);
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add(result);
    }

    @Override
    public String getResults() {
        ToolSummaryTable table = new ToolSummaryTable();
        this.generateColumnsTo(table);
        this.generateRowsTo(table);
        return table.toString();
    }

    private void generateColumnsTo(ToolSummaryTable table) {
        table.addColumn("Site");
        table.addColumn("Site Status");
        table.addColumn(COLUMN_RESULT);
    }

    private void generateRowsTo(ToolSummaryTable table) {
        for (OperationResult results : this.myResults) {
            this.generateRow(table, results);
        }
    }

    private void generateRow(ToolSummaryTable table, OperationResult results) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(results.getAddress());
        if (results.isConnected()) {
            this.insertToolResults(values, results);
        } else if (!results.isLoggedIn()) {
            values.add("Login failed");
        } else if (results.isReserved()) {
            values.add("Reserved");
        } else {
            values.add("Unreachable");
        }
        table.addRow(values);
    }

    private void insertToolResults(List<String> values, OperationResult results) {
        values.add(results.getOperationalState());
        values.add(results.isOK() ? "OK" : "Not OK");
    }
}

