/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Cell;
import com.nokia.em.bts.coreasset.configuration.ChangeStateAdapter;
import com.nokia.em.bts.coreasset.configuration.ChangeStateListener;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ResetCellSingle
extends ToolBase {
    private static final String ARG_ALL = "all";
    private static final String ARG_CELLID = "cellid";
    private static final String ARG_LOCAL_CELLID = "localid";
    private static final String ARG_GLOBAL_CELLID = "globalid";
    private int myPriority = 50;
    private int myCellCount = 0;
    private static final String ARG_PRIORITY = "priority";
    private static final String PRIORITY_LOW = "low";
    private static final String PRIORITY_HIGH = "high";
    private Object myLockAll = new Object();
    private boolean myNotified = false;
    private Operation myOperation;
    private Set<Integer> myCellIds;
    private Set<Integer> myLocalCellIds;
    private Set<Integer> myGlobalCellIds;
    private String myAddress;

    public ResetCellSingle(Operation operation) {
        this.myOperation = operation;
    }

    @Override
    protected void reset() {
        this.myPriority = 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        final OperationResult result = new OperationResult();
        String prio = args.getFirstValue(ARG_PRIORITY);
        if (PRIORITY_HIGH.equalsIgnoreCase(prio)) {
            this.myPriority = 63;
        } else if (PRIORITY_LOW.equalsIgnoreCase(prio)) {
            this.myPriority = 49;
        }
        this.myCellIds = this.getCellIds(args.getFirstValue(ARG_CELLID));
        this.myLocalCellIds = this.getCellIds(args.getFirstValue(ARG_LOCAL_CELLID));
        this.myGlobalCellIds = this.getCellIds(args.getFirstValue(ARG_GLOBAL_CELLID));
        boolean allCells = args.isDefined(ARG_ALL);
        if (!allCells && this.myCellIds == null && this.myLocalCellIds == null && this.myGlobalCellIds == null) {
            Console.error("No valid cells given");
            result.setOK(false);
            result.setExitCode(3);
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            BTSConnection connection = connectionInfo.getConnection();
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connection);
            }
            result.setOperationalState(this.getOperationalStateText(site));
            result.setAddress(connectionInfo.getAddress());
            if (site == null) {
                Console.error("Failed to get HW data from " + this.myAddress);
                result.setOK(false);
                result.setExitCode(70);
                this.disconnect(connectionInfo, disconnect);
                return result;
            }
            ArrayList<Cell> cells = new ArrayList<Cell>();
            for (final Cell cell : site.getCells()) {
                if (allCells) {
                    cells.add(cell);
                    continue;
                }
                if (this.myCellIds != null && this.myCellIds.contains(cell.getGlobalCellId())) {
                    cells.add(cell);
                    continue;
                }
                if (this.myLocalCellIds != null && this.myLocalCellIds.contains(cell.getCellId())) {
                    cells.add(cell);
                    continue;
                }
                if (this.myGlobalCellIds == null || !this.myGlobalCellIds.contains(cell.getGlobalCellId())) continue;
                cells.add(cell);
            }
            this.myCellCount = cells.size();
            if (this.myCellCount == 0) {
                Console.info("No cells found");
                result.setOK(false);
                result.setExitCode(68);
            }
            for (final Cell cell : cells) {
                final Object lock = new Object();
                final int id = this.getId(cell);
                final ChangeStateAdapterImpl blockListener = new ChangeStateAdapterImpl(cell, result, lock, Operation.BLOCK);
                final ChangeStateAdapterImpl unBlockListener = new ChangeStateAdapterImpl(cell, result, lock, Operation.UNBLOCK);
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object;
                        if (ResetCellSingle.this.myOperation != Operation.UNBLOCK) {
                            if (cell.getBlockingState() == 57) {
                                ResetCellSingle.this.myNotified = false;
                                Console.info("Blocking cell " + id + "...");
                                cell.block((ChangeStateListener)blockListener, ResetCellSingle.this.myPriority);
                                object = lock;
                                synchronized (object) {
                                    try {
                                        if (!ResetCellSingle.this.myNotified) {
                                            lock.wait(ResetCellSingle.this.myTimeout);
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (!ResetCellSingle.this.myNotified) {
                                    Console.info("Cell " + id + " block request timeout");
                                    result.setOK(false);
                                    result.setExitCode(8);
                                }
                            } else {
                                Console.info("Cell " + id + " already blocked");
                            }
                        }
                        if (ResetCellSingle.this.myOperation != Operation.BLOCK) {
                            if (cell.getBlockingState() == 55) {
                                ResetCellSingle.this.myNotified = false;
                                Console.info("Unblocking cell " + id + "...");
                                cell.unblock((ChangeStateListener)unBlockListener, ResetCellSingle.this.myPriority);
                                object = lock;
                                synchronized (object) {
                                    try {
                                        if (!ResetCellSingle.this.myNotified) {
                                            lock.wait(ResetCellSingle.this.myTimeout);
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (!ResetCellSingle.this.myNotified) {
                                    Console.info("Cell " + id + " unblock request timeout");
                                    result.setOK(false);
                                    result.setExitCode(69);
                                }
                            } else {
                                Console.info("Cell " + id + " already unblocked");
                            }
                        }
                        ResetCellSingle resetCellSingle = ResetCellSingle.this;
                        resetCellSingle.myCellCount = resetCellSingle.myCellCount - 1;
                        object = ResetCellSingle.this.myLockAll;
                        synchronized (object) {
                            ResetCellSingle.this.myLockAll.notify();
                        }
                    }
                }.start();
            }
            if (cells.size() > 0) {
                do {
                    Object object = this.myLockAll;
                    synchronized (object) {
                        try {
                            this.myLockAll.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                } while (this.myCellCount > 0);
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private int getId(Cell cell) {
        if (this.myGlobalCellIds != null && this.myGlobalCellIds.contains(cell.getGlobalCellId())) {
            return cell.getGlobalCellId();
        }
        return cell.getCellId();
    }

    private Set<Integer> getCellIds(String cellids) {
        if (cellids != null) {
            HashSet<Integer> ids = new HashSet<Integer>();
            try {
                ids.addAll(this.extractIdsFrom(cellids));
            }
            catch (Exception e) {
                Console.error("Invalid cell id format");
            }
            return ids;
        }
        return null;
    }

    private Set<Integer> extractIdsFrom(String s) {
        HashSet<Integer> ids = new HashSet<Integer>();
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                ids.add(Integer.parseInt(st.nextToken()));
            }
        }
        return ids;
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }

    class ChangeStateAdapterImpl
    extends ChangeStateAdapter {
        private OperationResult result;
        private Object lock;
        private Operation oper;
        private Cell oriCell;

        public ChangeStateAdapterImpl(Cell cell, OperationResult r, Object l, Operation o) {
            this.result = r;
            this.lock = l;
            this.oper = o;
            this.oriCell = cell;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChangeCompleted() {
            this.waitForDcnComplete();
            Console.info(String.valueOf(this.oper == Operation.BLOCK ? "Blocking" : "Unblocking") + " cell " + ResetCellSingle.this.getId(this.oriCell) + " succeeded");
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
                ResetCellSingle.this.myNotified = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChangeFailed(int intNackReason) {
            if (this.oper == Operation.BLOCK) {
                Console.error("Blocking cell " + ResetCellSingle.this.getId(this.oriCell) + " failed");
            } else if (this.oper == Operation.UNBLOCK) {
                Console.error("UnBlocking cell " + ResetCellSingle.this.getId(this.oriCell) + " failed");
            }
            this.result.setOK(false);
            this.result.setExitCode(69);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
                ResetCellSingle.this.myNotified = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChangeRequestDenied(int reason) {
            if (this.oper == Operation.BLOCK) {
                Console.error("Blocking cell " + ResetCellSingle.this.getId(this.oriCell) + " denied");
            } else if (this.oper == Operation.UNBLOCK) {
                Console.error("UnBlocking cell " + ResetCellSingle.this.getId(this.oriCell) + " denied");
            }
            this.result.setOK(false);
            this.result.setExitCode(69);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
                ResetCellSingle.this.myNotified = true;
            }
        }

        private void waitForDcnComplete() {
            block3: {
                block2: {
                    if (this.oper != Operation.BLOCK) break block2;
                    while (this.oriCell.getBlockingState() != 55) {
                        this.sleep();
                    }
                    break block3;
                }
                if (this.oper != Operation.UNBLOCK) break block3;
                while (this.oriCell.getBlockingState() != 57) {
                    this.sleep();
                }
            }
        }

        private void sleep() {
            Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)("wait for blocking state change, current state: " + this.oriCell.getBlockingState()));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    static enum Operation {
        RESET,
        BLOCK,
        UNBLOCK;

    }
}

