/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.message.BlockOperationsCompleted;
import com.nokia.em.bts.coreasset.message.ChangeObjectBlockingStateRequest;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.btstests.ResetListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoAdapter;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoListener;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.Map;

public class ResetSingle
extends ToolBase {
    private static final String ARG_RESETCOVERAGE = "resetcoverage";
    private static final String ARG_HANDOVER = "handover";
    private static final String ARG_FULLRESET = "fullreset";
    private static final String ARG_TEST_STATE = "teststate";
    private static final String ARG_BLOCK = "block";
    private static final String ARG_WAITFORRESET = "waitforreset";
    private static final String RESETCOVERAGE_SITE = "site";
    private static final int RECONNECT_RETRY_COUNT = 4;
    private boolean myTimeouted = true;
    private boolean myWaitForReset = false;
    private String myAddress;

    @Override
    protected void reset() {
        this.myTimeouted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        boolean handover = args.isDefined(ARG_HANDOVER);
        boolean teststate = args.isDefined(ARG_TEST_STATE);
        boolean block = args.isDefined(ARG_BLOCK);
        this.myWaitForReset = args.isDefined(ARG_WAITFORRESET);
        boolean fullReset = args.isDefined(ARG_FULLRESET) || RESETCOVERAGE_SITE.equalsIgnoreCase(args.getFirstValue(ARG_RESETCOVERAGE));
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        final OperationResult result = new OperationResult();
        if (connectionInfo.isConnected()) {
            block39: {
                BTSConnection connection = connectionInfo.getConnection();
                Site site = connectionInfo.getSite();
                if (site == null) {
                    site = this.buildHWModel(connection);
                }
                result.setOperationalState(this.getOperationalStateText(site));
                result.setAddress(connectionInfo.getAddress());
                if (site == null) {
                    Console.error("Failed to get HW data from " + this.myAddress);
                    result.setOK(false);
                    result.setExitCode(70);
                    this.disconnect(connectionInfo, disconnect);
                    return result;
                }
                if (handover && !teststate) {
                    try {
                        int id = site.getId();
                        if (this.blockUnblockSite(true, connection, id)) {
                            Console.info("Successfully blocked " + this.myAddress);
                            if (this.blockUnblockSite(false, connection, id)) {
                                Console.info("Successfully started reset to " + this.myAddress);
                            } else {
                                Console.error("Failed to unblock " + this.myAddress);
                                result.setOK(false);
                                result.setExitCode(69);
                            }
                            break block39;
                        }
                        Console.error("Failed to block " + this.myAddress);
                        result.setOK(false);
                        result.setExitCode(69);
                    }
                    catch (Exception e) {
                        Console.error("Failed to reset " + this.myAddress);
                        result.setOK(false);
                        result.setExitCode(69);
                    }
                } else {
                    ResetListener resetListener;
                    ResetListener resetListener2 = resetListener = new ResetListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void resetStarted() {
                            Console.info("Successfully started reset to " + ResetSingle.this.myAddress);
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                ResetSingle.this.myTimeouted = false;
                                this.notify();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void resetFailed(int intReason) {
                            Console.error("Failed to reset " + ResetSingle.this.myAddress);
                            result.setOK(false);
                            result.setExitCode(69);
                            ResetSingle.this.myWaitForReset = false;
                            1 var2_2 = this;
                            synchronized (var2_2) {
                                ResetSingle.this.myTimeouted = false;
                                this.notify();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void initializingCompleted(int state) {
                            if (state == 53) {
                                Console.info("No reset needed to " + ResetSingle.this.myAddress);
                                ResetSingle.this.myWaitForReset = false;
                                1 var2_2 = this;
                                synchronized (var2_2) {
                                    ResetSingle.this.myTimeouted = false;
                                    this.notify();
                                }
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void initializingFailed(int intNackReason) {
                            Console.error("Failed to reset " + ResetSingle.this.myAddress);
                            result.setOK(false);
                            result.setExitCode(69);
                            ResetSingle.this.myWaitForReset = false;
                            1 var2_2 = this;
                            synchronized (var2_2) {
                                ResetSingle.this.myTimeouted = false;
                                this.notify();
                            }
                        }
                    };
                    synchronized (resetListener2) {
                        try {
                            if (teststate) {
                                if (block) {
                                    try {
                                        if (this.blockUnblockSite(true, connection, site.getId())) {
                                            Console.info("Successfully blocked " + this.myAddress);
                                        } else {
                                            Console.error("Failed to block " + this.myAddress);
                                            result.setOK(false);
                                            result.setExitCode(69);
                                        }
                                    }
                                    catch (Exception e2) {
                                        Console.error("Failed to reset " + this.myAddress);
                                        result.setOK(false);
                                        result.setExitCode(69);
                                        return result;
                                    }
                                }
                                new ScenarioManagerImpl(connection).getResetToTestDedicatedStateScenario(resetListener, Boolean.valueOf(fullReset)).execute();
                            } else {
                                new ScenarioManagerImpl(connection).getResetScenario(resetListener, Boolean.valueOf(fullReset)).execute();
                            }
                            resetListener.wait(this.myTimeout);
                            if (this.myTimeouted) {
                                Console.error("Reset request timeout with " + this.myAddress);
                                result.setOK(false);
                                result.setExitCode(8);
                            }
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    if (!this.myTimeouted && this.myWaitForReset) {
                        ConnectionInfoAdapter connListener = new ConnectionInfoAdapter(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void btsDisconnected() {
                                2 var1_1 = this;
                                synchronized (var1_1) {
                                    ResetSingle.this.myTimeouted = false;
                                    ((Object)((Object)this)).notify();
                                }
                            }
                        };
                        connectionInfo.getConnection().addConnectionInfoListener((ConnectionInfoListener)connListener);
                        this.myTimeouted = true;
                        Console.info("Waiting 5 minutes for reset in " + this.myAddress);
                        ConnectionInfoAdapter e2 = connListener;
                        synchronized (e2) {
                            try {
                                connListener.wait(300000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        connectionInfo.getConnection().removeConnectionInfoListener((ConnectionInfoListener)connListener);
                        if (!this.myTimeouted) {
                            Console.info("Reset started in " + this.myAddress);
                            Console.info("Reconnecting in 3 minutes to " + this.myAddress + "...");
                            try {
                                Thread.sleep(180000L);
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                            int count = 0;
                            while (!(connectionInfo = this.connect(this.myAddress, username, password, credentials)).isConnected() && count++ < 4) {
                            }
                            if (connectionInfo.isConnected()) {
                                Console.info("Reset finished in " + this.myAddress);
                            } else {
                                Console.info("Reconnection timeout in " + this.myAddress);
                            }
                            if (c != null) {
                                c.setConnection(connectionInfo.getConnection());
                            }
                        } else {
                            Console.error("Reset timeout in " + this.myAddress);
                            result.setOK(false);
                            result.setExitCode(8);
                        }
                    }
                }
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private boolean blockUnblockSite(boolean block, BTSConnection c, int siteId) {
        int seqNumber = c.createScenario();
        ChangeObjectBlockingStateRequest request = new ChangeObjectBlockingStateRequest(seqNumber, siteId, 7, block ? 12 : 13);
        c.sendToBTS((BTSMessage)request);
        BTSMessage response = c.receiveFromBTS(seqNumber, (long)this.myTimeout);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            if (!ackResponse.getAck()) {
                c.deleteScenario(seqNumber);
                return false;
            }
            response = c.receiveFromBTS(seqNumber, (long)this.myTimeout);
            c.deleteScenario(seqNumber);
            if (response instanceof BlockOperationsCompleted) {
                return ((BlockOperationsCompleted)response).getSuccessCode() == 36;
            }
            if (response == null) {
                return true;
            }
        }
        c.deleteScenario(seqNumber);
        return false;
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }
}

