/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.HwModelUtil;
import com.nokia.em.bts.coreasset.application.util.LTERFModel;
import com.nokia.em.bts.coreasset.application.util.ProductInfo;
import com.nokia.em.bts.coreasset.application.util.RFModel;
import com.nokia.em.bts.coreasset.application.util.RP3LinkModel;
import com.nokia.em.bts.coreasset.configuration.Cell;
import com.nokia.em.bts.coreasset.configuration.ChangeStateAdapter;
import com.nokia.em.bts.coreasset.configuration.ChangeStateListener;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.message.DataChangeNotif;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.gpsmanagement.ResetModuleListener;
import com.nokia.em.bts.rp.master.connection.BTSNotificationListener;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResetUnitSingle
extends ToolBase {
    private static final String ARG_RESETCELL = "resetcell";
    private static final String ARG_TYPE = "type";
    private static final String ARG_NUMBER = "number";
    private static final String PRIORITY_LOW = "low";
    private static final String PRIORITY_HIGH = "high";
    private static final String ARG_PRIORITY = "priority";
    private static final String GPS_TYPE = "FYG";
    public static final String SITECONF_PROPERTIES_LOGICAL_ID = "_logicalId";
    private static final String NODE_ID = "_id";
    private static final String NODE_STATE = "_state";
    private static final String NODE_EXIST = "_exist";
    private static final String RESETTING = "resetting";
    private boolean isNewerThanLN70 = false;
    private int myPriority = 50;
    private boolean myNotified = false;
    private boolean myStateChanged = false;
    private boolean myResetSite = false;
    private int myCellCount = 0;
    private Operation myOperation;
    private String myOperationText = "";
    private String myAddress;

    public ResetUnitSingle(Operation operation) {
        this.myOperation = operation;
    }

    @Override
    protected void reset() {
        this.myPriority = 50;
        this.myNotified = false;
        this.myResetSite = false;
        this.myStateChanged = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        block79: {
            block73: {
                block78: {
                    block76: {
                        block77: {
                            block75: {
                                block74: {
                                    block72: {
                                        this.myTimeout = 300000;
                                        connectionInfo = c;
                                        this.parseCommonParamsFrom(args);
                                        this.myAddress = btsInformation.getBTSAddress();
                                        username = btsInformation.getUserName();
                                        password = btsInformation.getPassword();
                                        credentials = this.getCredentialsFrom(args);
                                        result = new OperationResult();
                                        unitType = args.getFirstValue("type");
                                        if (unitType == null) {
                                            Console.error("Missing unit type");
                                            result.setOK(false);
                                            result.setExitCode(3);
                                            return result;
                                        }
                                        number = args.getFirstValue("number");
                                        if (number == null) {
                                            Console.error("Missing number");
                                            result.setOK(false);
                                            result.setExitCode(3);
                                            return result;
                                        }
                                        resetCell = args.isDefined("resetcell");
                                        unitNumber = 0;
                                        rp3LinkModel = null;
                                        conectionList = "";
                                        try {
                                            unitNumber = Integer.valueOf(number);
                                        }
                                        catch (Exception e) {
                                            conectionList = number;
                                            rp3LinkModel = this.generateRP3LinkModel(conectionList);
                                            if (rp3LinkModel != null) break block72;
                                            Console.error("The type or number is invalid");
                                            result.setOK(false);
                                            result.setExitCode(3);
                                            return result;
                                        }
                                    }
                                    prio = args.getFirstValue("priority");
                                    if ("high".equalsIgnoreCase(prio)) {
                                        this.myPriority = 63;
                                    } else if ("low".equalsIgnoreCase(prio)) {
                                        this.myPriority = 49;
                                    }
                                    disconnect = false;
                                    if (connectionInfo == null) {
                                        connectionInfo = this.connect(this.myAddress, username, password, credentials);
                                        disconnect = true;
                                    }
                                    if (!connectionInfo.isConnected()) break block73;
                                    this.isNewerThanLN70 = this.isAfterRL70(connectionInfo);
                                    connection = connectionInfo.getConnection();
                                    site = connectionInfo.getSite();
                                    if (site == null) {
                                        site = this.buildHWModel(connection);
                                    }
                                    result.setOperationalState(this.getOperationalStateText(site));
                                    result.setAddress(connectionInfo.getAddress());
                                    if (site == null) {
                                        Console.error("Failed to get HW data from " + this.myAddress);
                                        result.setOK(false);
                                        result.setExitCode(70);
                                        this.disconnect(connectionInfo, disconnect);
                                        return result;
                                    }
                                    lock = new Object();
                                    unit = null;
                                    try {
                                        unit = rp3LinkModel == null ? this.findUnitByNumber(unitType, unitNumber, site) : (this.isNewerThanLN70 != false ? HwModelUtil.findUnitByRP3LinkModelNewThanLN70(site, unitType, rp3LinkModel) : HwModelUtil.findUnitByRP3LinkModelOlderThanLN70(site, unitType, rp3LinkModel));
                                    }
                                    catch (Exception e) {
                                        Console.error("Exception occurred when finding the " + unitType + (rp3LinkModel == null ? Integer.valueOf(unitNumber) : conectionList));
                                    }
                                    if (unit == null) {
                                        Console.error("Unable to find " + unitType + (rp3LinkModel == null ? Integer.valueOf(unitNumber) : conectionList));
                                        result.setOK(false);
                                        result.setExitCode(68);
                                        this.disconnect(connectionInfo, disconnect);
                                        return result;
                                    }
                                    unitName = String.valueOf(this.getUnitName(unit)) + this.getNumberOrConnectionlistForDisplay(rp3LinkModel, conectionList, unit);
                                    if (this.myOperation == Operation.RESET) {
                                        if ("FYG".equals(unit.getUnitType()) || ProductInfo.isSinceLTE16A(connectionInfo.getProduct()) && HwModelUtil.isRadioModuleUnit(unit)) {
                                            if (!this.isBlockable(unit)) {
                                                Console.error("Unable to reset because only radio master technology can reset radio module");
                                                result.setOK(false);
                                                result.setExitCode(124);
                                                this.disconnect(connectionInfo, disconnect);
                                                return result;
                                            }
                                            this.myNotified = false;
                                            Console.info("Resetting " + unitName + " ...");
                                            stateListener = new UnitStateListener(unit);
                                            connection.subscribeNotification((BTSNotificationListener)stateListener);
                                            manager = new ScenarioManagerImpl(connectionInfo.getConnection());
                                            manager.getResetModuleScenario((ResetModuleListener)new ResetUnitListener(unit, result, lock), unit.getUnitId()).execute();
                                            var24_29 = lock;
                                            synchronized (var24_29) {
                                                try {
                                                    if (!this.myNotified) {
                                                        lock.wait(this.myTimeout);
                                                    }
                                                }
                                                catch (Exception var25_31) {
                                                    // empty catch block
                                                }
                                            }
                                            if (!this.myNotified) {
                                                Console.error("Reset " + unitName + " timeout");
                                                result.setExitCode(8);
                                            } else {
                                                Console.info(String.valueOf(unitName) + " successfully reset");
                                            }
                                            return result;
                                        }
                                        if (site.getOMMaster() == unit.getId()) {
                                            this.myResetSite = true;
                                            resetCell = true;
                                            Console.info(String.valueOf(unitName) + " is O&M master. Site reset needed.");
                                        } else {
                                            manager = unit.getContainedUnitIds().iterator();
                                            while (manager.hasNext()) {
                                                id = (Integer)manager.next();
                                                if (site.getOMMaster() != id) continue;
                                                this.myResetSite = true;
                                                resetCell = true;
                                                Console.info(String.valueOf(unitName) + " is O&M master. Site reset needed.");
                                            }
                                        }
                                    } else {
                                        resetCell = false;
                                    }
                                    blockListener = new ChangeStateAdapterImpl(unit, lock, result, Operation.BLOCK, unitName);
                                    unBlockListener = new ChangeStateAdapterImpl(unit, lock, result, Operation.UNBLOCK, unitName);
                                    if (resetCell) {
                                        v1 = cells = this.myResetSite != false ? site.getCells() : unit.getCells();
                                        if (cells.size() == 0) {
                                            Console.info("No cells found");
                                        } else {
                                            this.blockCells(cells, true);
                                        }
                                    }
                                    if (!this.myResetSite) break block74;
                                    if (site.getBlockingState() == 57) {
                                        Console.info("Blocking site...");
                                        this.myNotified = false;
                                        this.myOperationText = "Blocking ";
                                        site.block((ChangeStateListener)new SiteChangeStateAdapterImpl(site, lock, result, Operation.BLOCK, unitName));
                                        var24_30 = lock;
                                        synchronized (var24_30) {
                                            try {
                                                if (!this.myNotified) {
                                                    lock.wait(this.myTimeout);
                                                }
                                            }
                                            catch (Exception var25_32) {
                                                // empty catch block
                                            }
                                        }
                                        if (!result.isOK()) {
                                            this.disconnect(connectionInfo, disconnect);
                                            return result;
                                        }
                                        if (this.myNotified) {
                                            Console.info("Site blocked");
                                        } else {
                                            result.setExitCode(8);
                                            Console.error("Site block request timeout");
                                        }
                                    } else {
                                        Console.info("Site already blocked");
                                    }
                                    break block75;
                                }
                                if (this.myOperation == Operation.UNBLOCK) break block75;
                                if (unit.getBlockingState() != 57) ** GOTO lbl193
                                Console.info("Blocking " + unitName + "...");
                                this.myNotified = false;
                                this.myOperationText = "Blocking ";
                                if (!this.isBlockable(unit)) {
                                    Console.error("Unable to block " + unitName + " because only radio master can block radio module");
                                    result.setOK(false);
                                    result.setExitCode(124);
                                    this.disconnect(connectionInfo, disconnect);
                                    return result;
                                }
                                unit.block((ChangeStateListener)blockListener);
                                var24_30 = lock;
                                synchronized (var24_30) {
                                    try {
                                        if (!this.myNotified) {
                                            lock.wait(this.myTimeout);
                                        }
                                    }
                                    catch (Exception var25_33) {
                                        // empty catch block
                                    }
                                }
                                if (!result.isOK()) {
                                    this.disconnect(connectionInfo, disconnect);
                                    return result;
                                }
                                if (this.myNotified) {
                                    Console.info(String.valueOf(unitName) + " blocked");
                                } else {
                                    result.setExitCode(8);
                                    Console.error(String.valueOf(unitName) + " block request timeout");
                                    return result;
lbl193:
                                    // 1 sources

                                    Console.info(String.valueOf(unitName) + " already blocked");
                                }
                            }
                            if (!this.myResetSite) break block76;
                            Console.info("Unblocking site...");
                            this.myNotified = false;
                            site.unblock((ChangeStateListener)new SiteChangeStateAdapterImpl(site, lock, result, Operation.UNBLOCK, unitName));
                            this.myOperationText = "Unblocking ";
                            var24_30 = lock;
                            synchronized (var24_30) {
                                try {
                                    if (!this.myNotified) {
                                        lock.wait(this.myTimeout);
                                    }
                                }
                                catch (Exception var25_34) {
                                    // empty catch block
                                }
                            }
                            if (!result.isOK()) {
                                this.disconnect(connectionInfo, disconnect);
                                return result;
                            }
                            if (!this.myNotified) break block77;
                            Console.info("Site unblocked");
                            break block78;
                        }
                        result.setExitCode(8);
                        Console.error("Site unblock request timeout");
                        return result;
                    }
                    if (this.myOperation == Operation.BLOCK) break block78;
                    if (unit.getBlockingState() != 55) ** GOTO lbl250
                    Console.info("Unblocking " + unitName + "...");
                    this.myNotified = false;
                    this.myOperationText = "Unblocking ";
                    unit.unblock((ChangeStateListener)unBlockListener);
                    var24_30 = lock;
                    synchronized (var24_30) {
                        try {
                            if (!this.myNotified) {
                                lock.wait(this.myTimeout);
                            }
                        }
                        catch (Exception var25_35) {
                            // empty catch block
                        }
                    }
                    if (!result.isOK()) {
                        this.disconnect(connectionInfo, disconnect);
                        return result;
                    }
                    if (this.myNotified) {
                        Console.info(String.valueOf(unitName) + " unblocked");
                    } else {
                        result.setExitCode(8);
                        Console.error(String.valueOf(unitName) + " unblock request timeout");
                        return result;
lbl250:
                        // 1 sources

                        Console.info(String.valueOf(unitName) + " already unblocked");
                    }
                    if (resetCell) {
                        this.blockCells(unit.getCells(), false);
                    }
                }
                if (this.myResetSite) {
                    Console.info("Site reset started");
                } else if (this.myOperation == Operation.RESET) {
                    Console.info(String.valueOf(unitName) + " successfully reset");
                }
                this.disconnect(connectionInfo, disconnect);
                break block79;
            }
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private String getUnitName(Unit unit) {
        return unit.getUnitName() != null && unit.getUnitName().trim().length() > 0 ? unit.getUnitName() : String.valueOf(unit.getUnitType()) + unit.getVariant();
    }

    private String getNumberOrConnectionlistForDisplay(RP3LinkModel rp3LinkModel, String conectionList, Unit unit) {
        return rp3LinkModel == null ? String.valueOf(unit.getNumber()) : conectionList;
    }

    private Unit findUnitByNumber(String unitType, int unitNumber, Site site) {
        Unit unit = null;
        for (Unit u : site.getCabinet().getUnits()) {
            if (!unitType.equalsIgnoreCase(u.getUnitType()) && !unitType.equalsIgnoreCase(u.getUnitName()) && !unitType.equalsIgnoreCase(String.valueOf(u.getUnitType()) + u.getVariant()) || unitNumber != u.getNumber()) continue;
            unit = u;
        }
        return unit;
    }

    private RP3LinkModel generateRP3LinkModel(String conectionList) {
        RP3LinkModel rp3LinkModel = null;
        try {
            String[] rp3ModelInfos = conectionList.split("\\.");
            rp3LinkModel = rp3ModelInfos.length == 3 ? new RP3LinkModel(Integer.valueOf(rp3ModelInfos[0]), 0, Integer.valueOf(rp3ModelInfos[1]), Integer.valueOf(rp3ModelInfos[2])) : new RP3LinkModel(Integer.valueOf(rp3ModelInfos[0]), Integer.valueOf(rp3ModelInfos[1]), Integer.valueOf(rp3ModelInfos[2]), Integer.valueOf(rp3ModelInfos[3]));
        }
        catch (Exception e) {
            Console.error("Exception occurred when parsing the connectionlist " + conectionList);
        }
        return rp3LinkModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockCells(List<Cell> cellList, final boolean blocking) {
        final Object lockAll = new Object();
        this.myCellCount = cellList.size();
        Iterator<Cell> iterator = cellList.iterator();
        while (iterator.hasNext()) {
            Cell cell;
            final Cell c = cell = iterator.next();
            final Object lock = new Object();
            final boolean[] timeout = new boolean[]{true};
            final ChangeStateAdapter listener = new ChangeStateAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChangeCompleted() {
                    Console.info("Cell " + c.getGlobalCellId() + " " + (blocking ? "blocked" : "unblocked"));
                    Object object = lock;
                    synchronized (object) {
                        lock.notify();
                        timeout[0] = false;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChangeFailed(int intNackReason) {
                    Console.error(String.valueOf(blocking ? "Blocking" : "Unblocking") + " cell " + c.getGlobalCellId() + " failed");
                    Object object = lock;
                    synchronized (object) {
                        lock.notify();
                        timeout[0] = false;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChangeRequestDenied(int reason) {
                    Console.error(String.valueOf(blocking ? "Blocking" : "Unblocking") + " cell " + c.getGlobalCellId() + " denied");
                    Object object = lock;
                    synchronized (object) {
                        lock.notify();
                        timeout[0] = false;
                    }
                }
            };
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object;
                    if (blocking && c.getBlockingState() == 57 || !blocking && c.getBlockingState() == 55) {
                        timeout[0] = true;
                        Console.info(String.valueOf(blocking ? "Blocking" : "Unblocking") + " cell " + c.getGlobalCellId() + "...");
                        if (blocking) {
                            c.block((ChangeStateListener)listener, ResetUnitSingle.this.myPriority);
                        } else {
                            c.unblock((ChangeStateListener)listener, ResetUnitSingle.this.myPriority);
                        }
                        object = lock;
                        synchronized (object) {
                            try {
                                if (timeout[0]) {
                                    lock.wait(ResetUnitSingle.this.myTimeout);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (timeout[0]) {
                            Console.error("Cell " + c.getGlobalCellId() + (blocking ? " block " : " unblock ") + "request timeout");
                        }
                    } else {
                        Console.info("Cell " + c.getGlobalCellId() + " already " + (blocking ? "blocked" : "unblocked"));
                    }
                    ResetUnitSingle resetUnitSingle = ResetUnitSingle.this;
                    resetUnitSingle.myCellCount = resetUnitSingle.myCellCount - 1;
                    object = lockAll;
                    synchronized (object) {
                        lockAll.notify();
                    }
                }
            }.start();
        }
        if (cellList.size() > 0) {
            do {
                Object object = lockAll;
                synchronized (object) {
                    try {
                        lockAll.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            } while (this.myCellCount > 0);
        }
    }

    private boolean isBlockable(Unit unit) {
        if (!HwModelUtil.isRadioModuleUnit(unit)) {
            return true;
        }
        return this.isRadioMaster(unit);
    }

    private boolean isRadioMaster(Unit unit) {
        RFModel rfModel = null;
        rfModel = this.isNewerThanLN70 ? new LTERFModel(unit) : new RFModel(unit);
        if (!rfModel.isShard()) {
            return true;
        }
        Unit sm = rfModel.getRadioMaster();
        if (sm == null) {
            return false;
        }
        if (HwModelUtil.isFSPModule(sm)) {
            Unit bbModel = HwModelUtil.getMasterBBModel(sm.getCabinet());
            for (Unit u : bbModel.getContainedUnits()) {
                if (u != sm) continue;
                return true;
            }
            return false;
        }
        return "Master".equalsIgnoreCase(sm.getCustomAttributeValue("FSM.Mode"));
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }

    class ChangeStateAdapterImpl
    extends ChangeStateAdapter {
        private Object lock;
        private Unit oriUnit;
        private OperationResult result;
        private Operation oper;
        private String unitName;

        public ChangeStateAdapterImpl(Unit unit, Object l, OperationResult res, Operation o, String name) {
            this.oriUnit = unit;
            this.lock = l;
            this.result = res;
            this.oper = o;
            this.unitName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChangeCompleted() {
            this.waitForDcnComplete();
            Object object = this.lock;
            synchronized (object) {
                ResetUnitSingle.this.myNotified = true;
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChangeFailed(int reason) {
            Console.error(String.valueOf(ResetUnitSingle.this.myOperationText) + this.getUnitName() + " failed");
            this.result.setOK(false);
            this.result.setExitCode(69);
            Object object = this.lock;
            synchronized (object) {
                ResetUnitSingle.this.myNotified = true;
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChangeRequestDenied(int reason) {
            Console.error(String.valueOf(ResetUnitSingle.this.myOperationText) + this.getUnitName() + " failed");
            this.result.setOK(false);
            this.result.setExitCode(69);
            Object object = this.lock;
            synchronized (object) {
                ResetUnitSingle.this.myNotified = true;
                this.lock.notify();
            }
        }

        private String getUnitName() {
            if (this.unitName != null && !this.unitName.isEmpty()) {
                return this.unitName;
            }
            return this.oriUnit.getUnitName() != null && this.oriUnit.getUnitName().trim().length() > 0 ? String.valueOf(this.oriUnit.getUnitName()) + this.oriUnit.getNumber() : String.valueOf(this.oriUnit.getUnitType()) + this.oriUnit.getVariant() + this.oriUnit.getNumber();
        }

        private void waitForDcnComplete() {
            block3: {
                block2: {
                    if (this.oper != Operation.BLOCK) break block2;
                    while (this.oriUnit.getBlockingState() != 55) {
                        this.sleep();
                    }
                    break block3;
                }
                if (this.oper != Operation.UNBLOCK) break block3;
                while (this.oriUnit.getBlockingState() != 57) {
                    this.sleep();
                }
            }
        }

        private void sleep() {
            Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)("wait for blocking state change, current state: " + this.oriUnit.getBlockingState()));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static enum Operation {
        RESET,
        BLOCK,
        UNBLOCK;

    }

    private class ResetUnitListener
    implements ResetModuleListener {
        private OperationResult result;
        private Object lock;
        private Unit unit;

        private ResetUnitListener(Unit gps, OperationResult res, Object lock) {
            this.result = res;
            this.lock = lock;
            this.unit = gps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void moduleReseted() {
            while (!ResetUnitSingle.this.myStateChanged) {
                Logger.getLogger(this.getClass()).debug((Object)"wait for unit state change");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Object object = this.lock;
            synchronized (object) {
                this.result.setOK(true);
                ResetUnitSingle.this.myNotified = true;
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetFailed(int reason) {
            Console.error("Failed to reset unit");
            Object object = this.lock;
            synchronized (object) {
                this.result.setOK(false);
                ResetUnitSingle.this.myNotified = true;
                this.lock.notify();
            }
        }
    }

    class SiteChangeStateAdapterImpl
    extends ChangeStateAdapter {
        private Object lock;
        private Site oriSite;
        private OperationResult result;
        private Operation oper;
        private String unitName;

        public SiteChangeStateAdapterImpl(Site s, Object l, OperationResult res, Operation o, String name) {
            this.oriSite = s;
            this.lock = l;
            this.result = res;
            this.oper = o;
            this.unitName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChangeCompleted() {
            this.waitForDcnComplete();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
                ResetUnitSingle.this.myNotified = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChangeFailed(int reason) {
            Console.error(String.valueOf(ResetUnitSingle.this.myOperationText) + this.unitName + " failed");
            this.result.setOK(false);
            this.result.setExitCode(69);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
                ResetUnitSingle.this.myNotified = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChangeRequestDenied(int reason) {
            Console.error(String.valueOf(ResetUnitSingle.this.myOperationText) + this.unitName + " failed");
            this.result.setOK(false);
            this.result.setExitCode(69);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
                ResetUnitSingle.this.myNotified = true;
            }
        }

        private void waitForDcnComplete() {
            block3: {
                block2: {
                    if (this.oper != Operation.BLOCK) break block2;
                    while (this.oriSite.getBlockingState() != 55) {
                        this.sleep();
                    }
                    break block3;
                }
                if (this.oper != Operation.UNBLOCK) break block3;
                while (this.oriSite.getBlockingState() != 57) {
                    this.sleep();
                }
            }
        }

        private void sleep() {
            Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)("wait for blocking state change, current state: " + this.oriSite.getBlockingState()));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class UnitStateListener
    implements BTSNotificationListener {
        private Unit myUnit;

        public UnitStateListener(Unit unit) {
            this.myUnit = unit;
        }

        public void btsNotificationReceived(BTSMessage btsMessage) {
            DataChangeNotif notif;
            if (btsMessage instanceof DataChangeNotif && (notif = (DataChangeNotif)btsMessage).getConfigObjectType() == 10 && notif.getOperationType() == 23) {
                this.checkUnitStateFrom(notif);
            }
        }

        private String getNodeValueByName(NodeList list, String name) {
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.hasChildNodes() && name.equalsIgnoreCase(node.getNodeName())) {
                    return node.getFirstChild().getNodeValue();
                }
                ++i;
            }
            return null;
        }

        private void checkUnitStateFrom(DataChangeNotif dcn) {
            try {
                NodeList list = dcn.getConfigObjectData();
                if (list != null) {
                    String nodeId = this.getNodeValueByName(list, ResetUnitSingle.NODE_ID);
                    String node_state = this.getNodeValueByName(list, ResetUnitSingle.NODE_STATE);
                    String exist = this.getNodeValueByName(list, ResetUnitSingle.NODE_EXIST);
                    if (nodeId.equalsIgnoreCase(String.valueOf(this.myUnit.getId())) && !ResetUnitSingle.RESETTING.equalsIgnoreCase(node_state) && Integer.parseInt(exist) != 0) {
                        Logger.getLogger(this.getClass()).debug((Object)"Unit state changed");
                        ResetUnitSingle.this.myStateChanged = true;
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).debug((Object)("Error happened when checking unit state: " + e));
            }
        }
    }
}

