/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.RollbackToPassiveSWSingle;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.util.ArrayList;
import java.util.List;

public class RollbackToPassiveSWImpl
extends ToolImpl {
    private List<FeedbackResult> myResults = new ArrayList<FeedbackResult>();
    protected static final String COLUMN_RESULT = "Rollback Result";

    public RollbackToPassiveSWImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return "Rollback To Passive SW";
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public String getFilePrefix() {
        return "RollbackToPassiveSW";
    }

    @Override
    public String getResults() {
        ToolSummaryTable table = new ToolSummaryTable();
        this.generateColumnsTo(table);
        this.generateRowsTo(table);
        return table.toString();
    }

    private void generateColumnsTo(ToolSummaryTable table) {
        table.addColumn("Site");
        table.addColumn("Site Status");
        table.addColumn(COLUMN_RESULT);
    }

    private void generateRowsTo(ToolSummaryTable table) {
        for (FeedbackResult result : this.myResults) {
            this.generateRow(table, result);
        }
    }

    private void generateRow(ToolSummaryTable table, FeedbackResult result) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(result.getAddress());
        if (result.isConnected()) {
            this.insertToolResults(values, result);
        } else if (!result.isLoggedIn()) {
            values.add("Login failed");
        } else if (result.isReserved()) {
            values.add("Reserved");
        } else {
            values.add("Unreachable");
        }
        table.addRow(values);
    }

    private void insertToolResults(List<String> values, FeedbackResult result) {
        values.add(result.getOperationalState());
        values.add(result.getFeedback());
    }

    @Override
    public String getShortResult() {
        if (this.myResults.size() > 0) {
            return this.myResults.get(0).getFeedback();
        }
        return "No results";
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new RollbackToPassiveSWSingle();
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add((FeedbackResult)result);
    }
}

