/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.SwVersion;
import com.nokia.em.bts.coreasset.application.util.SwVersionFileParser;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.softwaremanagement.SWRollbackAdapter;
import com.nokia.em.bts.coreasset.scenario.softwaremanagement.SWRollbackListener;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.io.File;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class RollbackToPassiveSWSingle
extends ToolBase {
    private String myAddress;
    private String myPassiveVersion;
    private boolean myIsTimeOut = false;
    private TimeOutTask myTimeOutTask;
    private Timer myTimer = new Timer();
    private boolean myGetSWFileFinished = false;
    private boolean myRollbackFinished = false;

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        this.myTimeout = 600000;
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        FeedbackResult result = new FeedbackResult(this.myAddress);
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connectionInfo.getConnection());
            }
            result.setOperationalState(this.getOperationalStateText(site));
            ScenarioManagerImpl scenarioManager = new ScenarioManagerImpl(connectionInfo.getConnection());
            SWVersionFileTransferListenerImpl swFileListener = new SWVersionFileTransferListenerImpl();
            scenarioManager.getSWVersionScenario((FileTransferListener)swFileListener).execute();
            Object lockObject = new Object();
            this.scheduleTimeoutTask(lockObject, result, this.myTimeout);
            if (!this.myGetSWFileFinished) {
                this.waitForExecute(lockObject);
            }
            if (!this.myIsTimeOut && this.myPassiveVersion != null) {
                scenarioManager.getSWRollbackScenario((SWRollbackListener)new SWRollbackListenerImpl(result)).execute();
                this.scheduleTimeoutTask(lockObject, result, this.myTimeout);
                if (!this.myRollbackFinished) {
                    this.waitForExecute(lockObject);
                }
            } else if (!this.myIsTimeOut) {
                result.setFeedback("Failed");
                result.setOK(false);
                result.setExitCode(130);
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    @Override
    protected void reset() {
        this.myIsTimeOut = false;
        this.myGetSWFileFinished = false;
        this.myRollbackFinished = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForExecute(Object lockObject) {
        try {
            Object object = lockObject;
            synchronized (object) {
                long start = System.currentTimeMillis();
                lockObject.wait();
                Logger.getLogger(this.getClass()).info((Object)("Wait for the response for " + (System.currentTimeMillis() - start) / 1000L + " seconds."));
            }
        }
        catch (InterruptedException e) {
            Logger.getLogger(this.getClass()).error((Object)e.getMessage());
        }
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }

    private synchronized void scheduleTimeoutTask(Object lock, FeedbackResult result, long milSec) {
        if (this.myTimeOutTask != null) {
            this.myTimeOutTask.cancel();
        }
        this.myTimeOutTask = new TimeOutTask(lock, result);
        this.myTimer.schedule((TimerTask)this.myTimeOutTask, milSec);
    }

    private synchronized void cancelTimeoutTask() {
        if (this.myTimeOutTask != null) {
            this.myTimeOutTask.cancel();
            this.myTimeOutTask.notifyLock();
        }
    }

    private class SWRollbackListenerImpl
    extends SWRollbackAdapter {
        private FeedbackResult result;

        public SWRollbackListenerImpl(FeedbackResult result) {
            this.result = result;
        }

        public void rollbackSuccessful() {
            this.result.setFeedback("Successful");
            this.result.setOK(true);
            RollbackToPassiveSWSingle.this.myRollbackFinished = true;
            RollbackToPassiveSWSingle.this.cancelTimeoutTask();
            Console.info("SW rollback to " + RollbackToPassiveSWSingle.this.myPassiveVersion + " successfully");
        }

        public void rollbackFailed(int reason) {
            this.result.setFeedback("Failed");
            this.result.setOK(false);
            this.result.setExitCode(130);
            RollbackToPassiveSWSingle.this.cancelTimeoutTask();
            RollbackToPassiveSWSingle.this.myRollbackFinished = true;
            Console.error("SW rollback to " + RollbackToPassiveSWSingle.this.myPassiveVersion + " failed with reason: " + RollbackToPassiveSWSingle.this.getFailReasonText(reason));
        }

        public void rollbackFailed(int reason, String error) {
            this.result.setFeedback("Failed");
            this.result.setOK(false);
            this.result.setExitCode(130);
            RollbackToPassiveSWSingle.this.cancelTimeoutTask();
            RollbackToPassiveSWSingle.this.myRollbackFinished = true;
            Console.error("SW rollback to " + RollbackToPassiveSWSingle.this.myPassiveVersion + " failed with reason: " + RollbackToPassiveSWSingle.this.getFailReasonText(reason) + ": " + error);
        }

        public void rollbackRejected(int nackReason) {
            this.result.setFeedback("Rejected by BTS");
            this.result.setOK(false);
            this.result.setExitCode(130);
            RollbackToPassiveSWSingle.this.cancelTimeoutTask();
            RollbackToPassiveSWSingle.this.myRollbackFinished = true;
            Console.error("SW rollback to " + RollbackToPassiveSWSingle.this.myPassiveVersion + " rejected by BTS with reason:" + RollbackToPassiveSWSingle.this.getFailReasonText(nackReason));
        }
    }

    private class SWVersionFileTransferListenerImpl
    extends FileTransferAdapter {
        private SWVersionFileTransferListenerImpl() {
        }

        public void fileTransferSucceeded(String strFileId) {
            File swFile = new File(strFileId);
            SwVersion swVersion = null;
            try {
                swVersion = SwVersionFileParser.parseSwVersionFile(swFile);
                if (swVersion.getPassiveSwVersion() != null && !swVersion.getPassiveSwVersion().isEmpty()) {
                    RollbackToPassiveSWSingle.this.myPassiveVersion = swVersion.getPassiveSwVersion();
                    Console.info("The Passive Version is: " + RollbackToPassiveSWSingle.this.myPassiveVersion);
                } else {
                    Console.error("Failed to get Passive version.");
                }
            }
            catch (Exception e) {
                Console.error("Failed to get Passive version.");
            }
            RollbackToPassiveSWSingle.this.cancelTimeoutTask();
            RollbackToPassiveSWSingle.this.myGetSWFileFinished = true;
        }

        public void fileTransferFailed(String strFileId) {
            Console.error("Failed to get Passive version.");
            RollbackToPassiveSWSingle.this.cancelTimeoutTask();
            RollbackToPassiveSWSingle.this.myGetSWFileFinished = true;
        }
    }

    private final class TimeOutTask
    extends TimerTask {
        private Object lock;
        private FeedbackResult result;

        public TimeOutTask(Object lock, FeedbackResult result) {
            this.lock = lock;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyLock() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                Console.error("Time out");
                RollbackToPassiveSWSingle.this.myIsTimeOut = true;
                this.lock.notifyAll();
                this.result.setOK(false);
                this.result.setExitCode(8);
            }
        }
    }
}

