/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.SWUpdateAdapter;
import com.nokia.em.bts.coreasset.application.tools.SWUpdateSingle;
import com.nokia.em.bts.coreasset.application.util.Console;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class SWUpdateAbortThread
extends SWUpdateAdapter
implements Runnable {
    public static final int DEFAULT_PORT = 13092;
    public static final String ABORT_COMMAND = "abort";
    int myPort = 13092;
    SWUpdateSingle myupdateSingle = null;
    Socket mySocket = null;
    private ServerSocket serverSocket = null;
    private PrintWriter writer = null;
    private boolean myIsFinished = false;
    private boolean myIsCancelFailed = false;

    public SWUpdateAbortThread(SWUpdateSingle swUpdateSingle) {
        this.myupdateSingle = swUpdateSingle;
    }

    public SWUpdateAbortThread() {
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    @Override
    public void run() {
        try {
            try {
                this.serverSocket = new ServerSocket(this.myPort);
                Console.info("SW Abort server opened at port: " + this.myPort);
                while ((this.mySocket = this.serverSocket.accept()) != null) {
                    Console.info("Start to stop SW updating");
                    this.myIsFinished = false;
                    this.writer = new PrintWriter(this.mySocket.getOutputStream());
                    BufferedReader is = new BufferedReader(new InputStreamReader(this.mySocket.getInputStream()));
                    if (ABORT_COMMAND.equals(is.readLine())) {
                        this.startStop();
                    }
                    this.myupdateSingle.abort();
                    while (!this.myIsFinished && !this.myIsCancelFailed) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (!this.myIsFinished) continue;
                    break;
                }
            }
            catch (IOException e) {
                Console.error("Stop SW update Client maybe disconnected...");
                this.closeServerSocket();
            }
        }
        finally {
            this.closeServerSocket();
        }
    }

    public void startStop() {
        this.writeMsg("Start to stop SW updating");
    }

    private void writeMsg(String msg) {
        if (this.writer != null) {
            this.writer.println(msg);
            this.writer.flush();
        }
    }

    public void closeServerSocket() {
        if (!this.serverSocket.isClosed()) {
            try {
                Console.info("Close SW Abort Server");
                this.serverSocket.close();
            }
            catch (IOException e) {
                Console.warn("Failed to close server socket");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCancelled(String btsAddress) {
        this.writeMsg("Result:Successfully stop sw update for address: " + btsAddress);
        SWUpdateAbortThread sWUpdateAbortThread = this;
        synchronized (sWUpdateAbortThread) {
            this.myIsFinished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCancelFailed(String btsAddress, String failReason) {
        this.writeMsg("Result:Failed to stop SW Update because of " + failReason + "  for address:" + btsAddress);
        SWUpdateAbortThread sWUpdateAbortThread = this;
        synchronized (sWUpdateAbortThread) {
            this.myIsCancelFailed = true;
        }
    }
}

