/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.SWUpdateListener;
import com.nokia.em.bts.coreasset.application.tools.SWUpdateResults;
import com.nokia.em.bts.coreasset.application.tools.SWUpdateSingle;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.util.ArrayList;
import java.util.List;

public class SWUpdateImpl
extends ToolImpl {
    private static final String COLUMN_UPDATED = "Update";
    private static final String COLUMN_RESET = "Reset";
    private static final String YES = "Yes";
    private List<SWUpdateResults> myResults = new ArrayList<SWUpdateResults>();
    private SWUpdateListener mySwUpdateListener;

    public SWUpdateImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        this.myMaxConcurrentSites = 1;
        return "SW Update";
    }

    @Override
    public String getVersion() {
        return "4.6";
    }

    @Override
    public String getFilePrefix() {
        return "SWUpdate";
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add((SWUpdateResults)result);
    }

    @Override
    public String getResults() {
        ToolSummaryTable table = new ToolSummaryTable();
        this.generateColumnsTo(table);
        this.generateRowsTo(table);
        return table.toString();
    }

    private void generateColumnsTo(ToolSummaryTable table) {
        table.addColumn("Site");
        table.addColumn("Site Status");
        table.addColumn(COLUMN_UPDATED);
        table.addColumn(COLUMN_RESET);
    }

    private void generateRowsTo(ToolSummaryTable table) {
        for (SWUpdateResults result : this.myResults) {
            this.generateRow(table, result);
        }
    }

    private void generateRow(ToolSummaryTable table, SWUpdateResults result) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(result.getAddress());
        if (result.isConnected()) {
            this.insertToolResults(values, result);
        } else if (!result.isLoggedIn()) {
            values.add("Login failed");
        } else if (result.isReserved()) {
            values.add("Reserved");
        } else {
            values.add("Unreachable");
        }
        table.addRow(values);
    }

    private void insertToolResults(List<String> values, SWUpdateResults result) {
        values.add(result.getOperationalState());
        values.add(result.isUpdateOK() ? "OK" : result.getUpdateFeedback());
        values.add(result.isReset() ? YES : result.getResetFeedback());
    }

    @Override
    public String getShortResult() {
        if (this.myResults.size() > 0) {
            SWUpdateResults result = this.myResults.get(0);
            return result.isUpdateOK() ? "OK" : this.getShortFeedback(result);
        }
        return "No results";
    }

    private String getShortFeedback(SWUpdateResults result) {
        String feedback = result.getUpdateFeedback();
        if (feedback.length() > 23) {
            feedback = String.valueOf(feedback.substring(0, 20)) + "...";
        }
        return feedback;
    }

    @Override
    protected ToolBase getNewSingleTool() {
        SWUpdateSingle single = new SWUpdateSingle();
        if (this.mySwUpdateListener != null) {
            single.setListner(this.mySwUpdateListener);
        }
        return single;
    }

    public SWUpdateListener getSwUpdateListener() {
        return this.mySwUpdateListener;
    }

    public void setSwUpdateListener(SWUpdateListener mySwUpdateListener) {
        this.mySwUpdateListener = mySwUpdateListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        this.myCount = 0;
        List list = this.mySingletools;
        synchronized (list) {
            for (ToolBase s : this.mySingletools) {
                ((SWUpdateSingle)s).abort();
            }
        }
    }
}

