/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.SWUpdateAbortThread;
import com.nokia.em.bts.coreasset.application.tools.SWUpdateAdapter;
import com.nokia.em.bts.coreasset.application.tools.SWUpdateListener;
import com.nokia.em.bts.coreasset.application.tools.SWUpdateResults;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.softwaremanagement.ResetCoverageAdapter;
import com.nokia.em.bts.coreasset.scenario.softwaremanagement.ResetCoverageListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoAdapter;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoListener;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.poseidon.util.PCmdLineParams;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class SWUpdateSingle
extends ToolBase {
    private static final int RECONNECT_RETRY_COUNT = 4;
    private static final String FEEDBACK_UNZIP_FAILED = "Unzip failed";
    private static final String TARGET_FILENAME = "TARGET";
    private static final String FEEDBACK_CANCELLED = "Cancelled";
    private static final String ARG_TARGETBD = "targetbd";
    private static final String ARG_ACTIVATE = "activate";
    private static final String ARG_WAITFORRESET = "waitforreset";
    private static final String ARG_ABORT_SERVER = "abortserver";
    private static final String ARG_ABORT_PORT = "abortport";
    private static final String TARGETBD = "targetbd";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String TOOL_TEMP_DIR = "tooltemp";
    private boolean myTimeouted = true;
    private boolean myResetReceived = false;
    private Timer myTimeoutTimer = new Timer();
    private TimeoutTask myTimeoutTask = new TimeoutTask();
    private FileTransferListener myFTPListener;
    private Scenario myScenario = null;
    private SWUpdateListener myListener = new SWUpdateAdapter();
    private boolean myResetNeeded = false;
    private List<String> myFailedFiles = new ArrayList<String>();
    private String myAddress;
    private SWUpdateAbortThread myAbortServerThread = null;

    public void setListner(SWUpdateListener listener) {
        this.myListener = listener;
    }

    @Override
    protected void reset() {
        this.myTimeouted = true;
        this.myResetReceived = false;
        this.myResetNeeded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, final PCmdLineParams args) {
        this.myTimeout = 1200000;
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        final SWUpdateResults result = new SWUpdateResults(this.myAddress);
        boolean activate = args.isDefined(ARG_ACTIVATE);
        String swfile = args.getFirstValue("targetbd");
        if (swfile == null) {
            Console.error("No valid targetBD file given");
            result.setUpdateFeedback("Invalid targetBD");
            result.setOK(false);
            result.setExitCode(3);
            return result;
        }
        boolean waitForReset = args.isDefined(ARG_WAITFORRESET);
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        ScenarioManagerImpl scenarioManager = null;
        if (connectionInfo.isConnected()) {
            BTSConnection connection = connectionInfo.getConnection();
            this.myListener.connected(this.myAddress);
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connection);
            }
            result.setOperationalState(this.getOperationalStateText(site));
            File targetbd = this.unzipSWPackage(new File(swfile));
            if (targetbd == null) {
                result.setOK(false);
                result.setExitCode(16);
                result.setUpdateFeedback(FEEDBACK_UNZIP_FAILED);
                this.disconnect(connectionInfo, disconnect);
                this.myListener.unzipFailed();
                return result;
            }
            scenarioManager = new ScenarioManagerImpl(connection);
            this.myFTPListener = new FileTransferAdapter(){

                public void fileTransferStarted(String strFileId, long fileSize) {
                    if (SWUpdateSingle.this.myAbortServerThread == null && args.isDefined(SWUpdateSingle.ARG_ABORT_SERVER) && "on".equalsIgnoreCase(args.getFirstValue(SWUpdateSingle.ARG_ABORT_SERVER))) {
                        SWUpdateSingle.this.myAbortServerThread = new SWUpdateAbortThread(SWUpdateSingle.this.getCurrentInstance());
                        if (args.isDefined(SWUpdateSingle.ARG_ABORT_PORT)) {
                            try {
                                SWUpdateSingle.this.myAbortServerThread.setPort(Integer.parseInt(args.getFirstValue(SWUpdateSingle.ARG_ABORT_PORT)));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        SWUpdateSingle.this.setListner(SWUpdateSingle.this.myAbortServerThread);
                        new Thread(SWUpdateSingle.this.myAbortServerThread).start();
                    }
                }

                public void fileTransferUpdated(String strFileId, float fPercentage) {
                    SWUpdateSingle.this.restartTimeoutTimer();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileSetTransferCancelled() {
                    Console.info("SW update cancelled to " + SWUpdateSingle.this.myAddress);
                    SWUpdateSingle.this.myListener.updateCancelled(SWUpdateSingle.this.myAddress);
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        result.setUpdateOK(false);
                        result.setExitCode(18);
                        result.setUpdateFeedback(SWUpdateSingle.FEEDBACK_CANCELLED);
                        SWUpdateSingle.this.myTimeouted = false;
                        ((Object)((Object)this)).notify();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileSetTransferRejected(int intFailReason) {
                    String s = SWUpdateSingle.this.getFailReasonText(intFailReason);
                    Console.error("SW update rejected (" + s + ") to " + SWUpdateSingle.this.myAddress);
                    SWUpdateSingle.this.myListener.updateFailed(SWUpdateSingle.this.myAddress, s);
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        result.setUpdateOK(false);
                        result.setExitCode(17);
                        result.setUpdateFeedback(s);
                        SWUpdateSingle.this.myTimeouted = false;
                        ((Object)((Object)this)).notify();
                    }
                }

                public void fileSetTransferCancellingFailed(int intFailReason) {
                    String s = SWUpdateSingle.this.getFailReasonText(intFailReason);
                    Console.error("SW update cancel failed (" + s + ") to " + SWUpdateSingle.this.myAddress);
                    SWUpdateSingle.this.myListener.updateCancelFailed(SWUpdateSingle.this.myAddress, s);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileSetTransferFailed(int intFailReason, String errorText) {
                    String s = SWUpdateSingle.this.getFailReasonText(intFailReason);
                    Console.error("SW update failed (" + s + ") to " + SWUpdateSingle.this.myAddress);
                    if (errorText != null) {
                        s = errorText;
                    }
                    SWUpdateSingle.this.myListener.updateFailed(SWUpdateSingle.this.myAddress, s);
                    1 var4_4 = this;
                    synchronized (var4_4) {
                        result.setUpdateOK(false);
                        result.setExitCode(17);
                        result.setUpdateFeedback(s);
                        SWUpdateSingle.this.myTimeouted = false;
                        ((Object)((Object)this)).notify();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileSetTransferFailed(int intFailReason) {
                    if (!SWUpdateSingle.this.myTimeouted) {
                        String s = SWUpdateSingle.this.getFailReasonText(intFailReason);
                        Console.error("SW update failed (" + s + ") to " + SWUpdateSingle.this.myAddress);
                        SWUpdateSingle.this.myListener.updateFailed(SWUpdateSingle.this.myAddress, s);
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            result.setUpdateOK(false);
                            result.setExitCode(17);
                            result.setUpdateFeedback(s);
                            SWUpdateSingle.this.myTimeouted = false;
                            ((Object)((Object)this)).notify();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileSetTransferCompleted(String strFileId) {
                    Console.info("SW update completed to " + SWUpdateSingle.this.myAddress);
                    SWUpdateSingle.this.myListener.updateFinished(SWUpdateSingle.this.myAddress);
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        SWUpdateSingle.this.myTimeouted = false;
                        ((Object)((Object)this)).notify();
                    }
                }

                public void fileTransferSucceeded(String strFileId) {
                    if (SWUpdateSingle.this.myFailedFiles.contains(strFileId)) {
                        SWUpdateSingle.this.myFailedFiles.remove(strFileId);
                    } else {
                        String s = SWUpdateSingle.this.removePath(strFileId);
                        Console.info("Successfully updated " + s);
                        result.setUptodate(s.toUpperCase().indexOf(SWUpdateSingle.TARGET_FILENAME) >= 0);
                        SWUpdateSingle.this.restartTimeoutTimer();
                    }
                }

                public void fileTransferFailed(String strFileId) {
                    Console.error("Failed to update " + SWUpdateSingle.this.removePath(strFileId));
                    SWUpdateSingle.this.restartTimeoutTimer();
                    SWUpdateSingle.this.myFailedFiles.add(strFileId);
                }
            };
            ResetCoverageAdapter resetListener = new ResetCoverageAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resetting(int resetCoverage) {
                    if (resetCoverage == 1 || resetCoverage == 2) {
                        Console.info("Reset needed for " + SWUpdateSingle.this.myAddress);
                        SWUpdateSingle.this.myResetNeeded = true;
                        SWUpdateSingle.this.myListener.resetNeeded(SWUpdateSingle.this.myAddress, true);
                    } else {
                        Console.info("Reset not needed for " + SWUpdateSingle.this.myAddress);
                        SWUpdateSingle.this.myListener.resetNeeded(SWUpdateSingle.this.myAddress, false);
                    }
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        SWUpdateSingle.this.myResetReceived = true;
                        SWUpdateSingle.this.myTimeouted = false;
                        ((Object)((Object)this)).notify();
                    }
                }
            };
            Console.info("SW update started to " + this.myAddress);
            this.restartTimeoutTimer();
            Object object = this.myFTPListener;
            synchronized (object) {
                try {
                    this.myScenario = scenarioManager.getSWUpdateScenario(this.myFTPListener, (ResetCoverageListener)resetListener, targetbd.getAbsoluteFile(), activate);
                    this.myListener.updateStarted(this.myAddress);
                    this.myScenario.execute();
                    this.myFTPListener.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.myTimeoutTimer.cancel();
                this.myTimeoutTask.cancel();
                if (this.myTimeouted) {
                    Console.error("SW Update timeout with " + this.myAddress);
                    result.setUpdateOK(false);
                    result.setExitCode(8);
                    result.setUpdateFeedback("timeout");
                }
            }
            if (result.wasUptodate()) {
                Console.info("SW already up to date in " + this.myAddress);
            }
            if (!this.myTimeouted && result.isUpdateOK()) {
                this.myTimeouted = true;
                object = resetListener;
                synchronized (object) {
                    if (!this.myResetReceived) {
                        try {
                            resetListener.wait(this.myTimeout);
                            if (this.myTimeouted) {
                                Console.error("Reset need query timeout with " + this.myAddress);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.myResetNeeded) {
                if (waitForReset) {
                    ConnectionInfoAdapter connListener = new ConnectionInfoAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void btsDisconnected() {
                            3 var1_1 = this;
                            synchronized (var1_1) {
                                SWUpdateSingle.this.myTimeouted = false;
                                ((Object)((Object)this)).notify();
                            }
                        }
                    };
                    connection.addConnectionInfoListener((ConnectionInfoListener)connListener);
                    this.myTimeouted = true;
                    Console.info("Waiting 5 minutes for reset in " + this.myAddress);
                    ConnectionInfoAdapter connectionInfoAdapter = connListener;
                    synchronized (connectionInfoAdapter) {
                        try {
                            connListener.wait(300000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    connection.removeConnectionInfoListener((ConnectionInfoListener)connListener);
                    if (!this.myTimeouted) {
                        this.myListener.resetStarted(this.myAddress);
                        result.setReset(true);
                        Console.info("Reset started in " + this.myAddress);
                        Console.info("Reconnecting in 3 minutes to " + this.myAddress + "...");
                        try {
                            Thread.sleep(180000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        int count = 0;
                        while (!(connectionInfo = this.connect(this.myAddress, username, password, credentials)).isConnected() && count++ < 4) {
                        }
                        if (connectionInfo.isConnected()) {
                            Console.info("Reset finished in " + this.myAddress);
                        } else {
                            Console.info("Reconnection timeout in " + this.myAddress);
                        }
                        if (c != null) {
                            c.setConnection(connectionInfo.getConnection());
                        }
                        this.myListener.resetFinished(this.myAddress);
                    } else {
                        Console.error("Reset timeout in " + this.myAddress);
                        result.setExitCode(8);
                        result.setOK(false);
                        result.setResetFeedback("Timeout");
                        this.myListener.resetFailed(this.myAddress);
                    }
                }
            } else {
                result.setResetFeedback("Not needed");
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        File dir = new File(TOOL_TEMP_DIR);
        if (dir.exists()) {
            PFileUtils.delete((File)dir);
        }
        return result;
    }

    private synchronized void restartTimeoutTimer() {
        this.myTimeoutTimer.cancel();
        this.myTimeoutTask.cancel();
        this.myTimeoutTimer = new Timer();
        this.myTimeoutTask = new TimeoutTask();
        this.myTimeoutTimer.schedule((TimerTask)this.myTimeoutTask, this.myTimeout);
    }

    private String removePath(String fileId) {
        if (fileId.indexOf("/") > -1) {
            return fileId.substring(fileId.indexOf("/"));
        }
        if (fileId.indexOf("\\") > -1) {
            return fileId.substring(fileId.indexOf("\\"));
        }
        return fileId;
    }

    public void abort() {
        if (this.myScenario != null) {
            this.myScenario.abort();
        }
    }

    private File unzipSWPackage(File swfile) {
        if (swfile.getName().toLowerCase().endsWith(ZIP_EXTENSION)) {
            File dir = new File(TOOL_TEMP_DIR);
            if (dir.exists()) {
                PFileUtils.delete((File)dir);
            }
            if (dir.mkdir() || dir.exists()) {
                try {
                    PFileUtils.unZip((File)swfile, (File)dir);
                    return this.getTargetBD(dir.listFiles());
                }
                catch (Exception e) {
                    Console.error("Failed to unzip software package.");
                    Logger.getLogger(this.getClass()).error((Object)"Failed to unzip SW package", (Throwable)e);
                    return null;
                }
            }
            Console.error("Failed to create temporary directory.");
            Logger.getLogger(this.getClass()).error((Object)"Failed to create temp dir");
            return null;
        }
        return swfile;
    }

    private File getTargetBD(File[] files) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                File f2 = this.getTargetBD(file.listFiles());
                if (f2 != null) {
                    return f2;
                }
            } else if (file.getName().toLowerCase().contains("targetbd")) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    private SWUpdateSingle getCurrentInstance() {
        return this;
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }

    private class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileTransferListener fileTransferListener = SWUpdateSingle.this.myFTPListener;
            synchronized (fileTransferListener) {
                SWUpdateSingle.this.myFTPListener.notify();
            }
        }
    }
}

