/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.scenario.ScenarioManager;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams.ACNonOpBackhaulParamsBean;
import com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams.ACNonOpBackhaulParamsEnum;
import com.nokia.em.bts.coreasset.scenario.acnonopbackhaulparams.ACNonOpBackhaulParamsScenarioListener;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class SetNonOpBackhaulSingle
extends ToolBase {
    private static final String ARG_PARAMETER = "parameter";
    private static final String ARG_PARAMETER_FILE = "parameterfile";
    private String myAddress;
    private boolean myTimeouted = true;
    private ACNonOpBackhaulParamsBean myBackhaulParamsBean = null;

    @Override
    protected void reset() {
        this.myTimeouted = true;
        this.myBackhaulParamsBean = null;
    }

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String parameters = args.getFirstValue(ARG_PARAMETER);
        String parameterFile = args.getFirstValue(ARG_PARAMETER_FILE);
        ACNonOpBackhaulParamsBean bean = this.getACNonOpBackhaulParamsBean(parameters, parameterFile);
        FeedbackResult result = new FeedbackResult(this.myAddress);
        if (bean == null) {
            Console.error("No valid parameters or file given");
            result.setOK(false);
            result.setFeedback("Invalid parameters");
            result.setExitCode(3);
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, btsInformation.getUserName(), btsInformation.getPassword(), this.getCredentialsFrom(args));
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connectionInfo.getConnection());
            }
            result.setOperationalState(this.getOperationalStateText(site));
            ScenarioManagerImpl scenarioManager = new ScenarioManagerImpl(connectionInfo.getConnection());
            this.setACNonOpBackhaulParams((ScenarioManager)scenarioManager, bean, result);
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    protected ACNonOpBackhaulParamsBean getACNonOpBackhaulParamsBean(String parameters, String parameterFile) {
        ACNonOpBackhaulParamsBean bean = null;
        if (parameters != null && !parameters.isEmpty()) {
            bean = this.getACNonOpBackhaulParamsBeanFromParameters(parameters);
        } else if (parameterFile != null && !parameterFile.isEmpty()) {
            bean = this.getACNonOpBackhaulParamsBeanFromParametersFile(parameterFile, bean);
        }
        return bean;
    }

    private ACNonOpBackhaulParamsBean getACNonOpBackhaulParamsBeanFromParametersFile(String parameterFile, ACNonOpBackhaulParamsBean bean) {
        ACNonOpBackhaulParamsBean newBean = bean;
        if (parameterFile != null) {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(parameterFile);
                newBean = new ACNonOpBackhaulParamsBean(doc.getFirstChild());
            }
            catch (Exception e) {
                Console.error("Invalid parameter file", e);
            }
        }
        return newBean;
    }

    private ACNonOpBackhaulParamsBean getACNonOpBackhaulParamsBeanFromParameters(String parameters) {
        ACNonOpBackhaulParamsBean bean = null;
        HashMap<ACNonOpBackhaulParamsEnum, String> paramMap = new HashMap<ACNonOpBackhaulParamsEnum, String>();
        boolean parametersOk = true;
        if (parameters != null) {
            StringTokenizer st = new StringTokenizer(parameters, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                try {
                    String parameName = s.split(":")[0].trim();
                    String parameValue = s.split(":")[1].trim();
                    boolean paramNameMatched = false;
                    ACNonOpBackhaulParamsEnum[] aCNonOpBackhaulParamsEnumArray = ACNonOpBackhaulParamsEnum.values();
                    int n = aCNonOpBackhaulParamsEnumArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ACNonOpBackhaulParamsEnum param = aCNonOpBackhaulParamsEnumArray[n2];
                        if (parameName.equals(param.getNodeName())) {
                            paramNameMatched = true;
                            paramMap.put(param, parameValue);
                        }
                        ++n2;
                    }
                    if (paramNameMatched) continue;
                    Console.error("Unsupported parameter name: " + parameName);
                    parametersOk = false;
                }
                catch (Exception e) {
                    Console.error("Invalid parameter format: " + s, e);
                    parametersOk = false;
                }
                break;
            }
        }
        if (parametersOk && !paramMap.isEmpty()) {
            bean = new ACNonOpBackhaulParamsBean(paramMap);
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setACNonOpBackhaulParams(ScenarioManager s, ACNonOpBackhaulParamsBean bean, final FeedbackResult result) {
        ACNonOpBackhaulParamsScenarioListener listener;
        ACNonOpBackhaulParamsScenarioListener aCNonOpBackhaulParamsScenarioListener = listener = new ACNonOpBackhaulParamsScenarioListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void acNonOpBackhaulParamsGetSuccessful(ACNonOpBackhaulParamsBean backhaulParamsBean) {
                SetNonOpBackhaulSingle.this.myTimeouted = false;
                1 var2_2 = this;
                synchronized (var2_2) {
                    SetNonOpBackhaulSingle.this.myBackhaulParamsBean = backhaulParamsBean;
                    this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void acNonOpBackhaulParamsGetFailed(int failReason) {
                SetNonOpBackhaulSingle.this.myTimeouted = false;
                1 var2_2 = this;
                synchronized (var2_2) {
                    String failedReason = SetNonOpBackhaulSingle.this.getFailReasonText(failReason);
                    Console.error("Failed to get backhaul params (" + failedReason + ") from " + SetNonOpBackhaulSingle.this.myAddress);
                    result.setOK(false);
                    result.setFeedback(failedReason);
                    if (68 == failReason) {
                        result.setExitCode(8);
                    } else {
                        result.setExitCode(113);
                    }
                    this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void acNonOpBackhaulParamsUpdateSuccessful(ACNonOpBackhaulParamsBean backhaulParamsBean) {
                SetNonOpBackhaulSingle.this.myTimeouted = false;
                1 var2_2 = this;
                synchronized (var2_2) {
                    Console.info("Successfully set backhaul parameters to " + result.getAddress());
                    Logger.getLogger(this.getClass()).debug((Object)("Succeed backhaul parameters: " + backhaulParamsBean.toXMLString()));
                    result.setOK(true);
                    result.setFeedback("Successful");
                    this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void acNonOpBackhaulParamsUpdateFailed(int failReason) {
                SetNonOpBackhaulSingle.this.myTimeouted = false;
                1 var2_2 = this;
                synchronized (var2_2) {
                    String failedReason = SetNonOpBackhaulSingle.this.getFailReasonText(failReason);
                    Console.error("Failed to set backhaul parameters (" + failedReason + ") to " + result.getAddress());
                    result.setOK(false);
                    result.setFeedback(failedReason);
                    if (68 == failReason) {
                        result.setExitCode(8);
                    } else {
                        result.setExitCode(114);
                    }
                    this.notify();
                }
            }
        };
        synchronized (aCNonOpBackhaulParamsScenarioListener) {
            try {
                s.getGetACNonOpBackhaulParamsScenario(listener, false).execute();
                long startTime = System.currentTimeMillis();
                listener.wait(this.myTimeout);
                long spendTime = System.currentTimeMillis() - startTime;
                if (this.myTimeouted) {
                    result.setOK(false);
                    result.setFeedback("Timeout");
                    result.setExitCode(8);
                    Console.error("Set backhaul params timeout with " + this.myAddress);
                    return;
                }
                if (this.myBackhaulParamsBean != null) {
                    this.myTimeouted = true;
                    this.myTimeout = (int)((long)this.myTimeout - spendTime);
                    this.updateBackhaulParamsBean(bean);
                    s.getACNonOpBackhaulParamsUpdateScenario(listener, this.myBackhaulParamsBean).execute();
                    listener.wait(this.myTimeout);
                    if (this.myTimeouted) {
                        result.setOK(false);
                        result.setFeedback("Timeout");
                        result.setExitCode(8);
                        Console.error("Set backhaul params timeout with " + this.myAddress);
                    }
                }
            }
            catch (Exception e) {
                Console.error("Failed to set backhaul parameters to " + this.myAddress, e);
                result.setOK(false);
                result.setFeedback("Failed");
                result.setExitCode(114);
            }
        }
    }

    private void updateBackhaulParamsBean(ACNonOpBackhaulParamsBean bean) {
        Map myParameterMap = this.myBackhaulParamsBean.getParameterMap();
        myParameterMap.putAll(bean.getParameterMap());
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }
}

