/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.TiltRange;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.message.DataChangeNotif;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.AntennaTiltAdapter;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.AntennaTiltListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSNotificationListener;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetTiltRangeSingle
extends ToolBase {
    private static final String ARG_MIN_ANGLE = "minangle";
    private static final String ARG_MAX_ANGLE = "maxangle";
    private static final String ARG_ID = "id";
    private static final String NODE_ID = "_id";
    private static final String NODE_ANTENNA_TILTING_STATE = "AntennaTiltingState";
    private static final String NODEVALUE_STATE_IDLE = "idle";
    private static final String UNIT_TYPE_TILT = "tilt";
    private String myAddress;
    private ScenarioManagerImpl myScenarioManager;
    private boolean myTimeouted;
    private boolean myTiltOk;

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        List<TiltRange> ranges;
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        FeedbackResult result = new FeedbackResult(this.myAddress);
        try {
            ranges = this.getIdsAndAnglesFrom(args);
        }
        catch (Exception nfe) {
            Console.error("Invalid angle format");
            result.setOK(false);
            result.setFeedback("Invalid angle format");
            result.setExitCode(3);
            return result;
        }
        if (ranges == null) {
            result.setOK(false);
            result.setFeedback("Missing id or angle information");
            result.setExitCode(3);
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            BTSConnection connection = connectionInfo.getConnection();
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connection);
            }
            result.setOperationalState(this.getOperationalStateText(site));
            if (site == null) {
                Console.error("Failed to get HW data from " + this.myAddress);
                result.setOK(false);
                result.setFeedback("Failed to get HW data");
                result.setExitCode(96);
            } else {
                this.myScenarioManager = new ScenarioManagerImpl(connection);
                int total = 0;
                int success = 0;
                for (TiltRange range : ranges) {
                    ++total;
                    Unit unit = site.getUnit(range.getId());
                    if (unit == null) {
                        Console.error("Tilt " + range.getId() + " not found from " + this.myAddress);
                        continue;
                    }
                    if (!unit.getUnitType().equalsIgnoreCase(UNIT_TYPE_TILT)) {
                        Console.error("Unit " + range.getId() + " not tilt in " + this.myAddress);
                        continue;
                    }
                    if (!this.setRange(unit, range.getMinAngle(), range.getMaxAngle(), connection)) continue;
                    ++success;
                }
                if (total != success) {
                    result.setOK(false);
                    result.setFeedback(String.valueOf(success) + "/" + total + " set");
                    result.setExitCode(94);
                } else if (total == 0) {
                    result.setOK(false);
                    result.setFeedback("No tilts found");
                    result.setExitCode(95);
                } else {
                    result.setFeedback(String.valueOf(success) + "/" + total + " set");
                }
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private List<TiltRange> getIdsAndAnglesFrom(PCmdLineParams args) {
        String idParam = args.getFirstValue(ARG_ID);
        String minAngleParam = args.getFirstValue(ARG_MIN_ANGLE);
        String maxAngleParam = args.getFirstValue(ARG_MAX_ANGLE);
        if (idParam == null) {
            Console.error("Missing id information");
            return null;
        }
        if (minAngleParam == null) {
            Console.error("Missing minimum angle information");
            return null;
        }
        if (maxAngleParam == null) {
            Console.error("Missing maximum angle information");
            return null;
        }
        StringTokenizer ids = new StringTokenizer(idParam, ",");
        StringTokenizer minAngles = new StringTokenizer(minAngleParam, ",");
        StringTokenizer maxAngles = new StringTokenizer(maxAngleParam, ",");
        if (ids.countTokens() != minAngles.countTokens() || minAngles.countTokens() != maxAngles.countTokens()) {
            Console.error("Mismatch between ids and angles");
            return null;
        }
        ArrayList<TiltRange> ranges = new ArrayList<TiltRange>();
        while (ids.hasMoreTokens()) {
            ranges.add(new TiltRange(Integer.valueOf(ids.nextToken()), Float.valueOf(minAngles.nextToken()).floatValue(), Float.valueOf(maxAngles.nextToken()).floatValue()));
        }
        return ranges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setRange(Unit unit, float minAngle, float maxAngle, BTSConnection connection) {
        this.myTimeouted = true;
        this.myTiltOk = true;
        TiltStateListener tiltStateListener = new TiltStateListener(unit);
        connection.subscribeNotification((BTSNotificationListener)tiltStateListener);
        TiltListener tiltListener = new TiltListener(unit);
        Thread t = new Thread((AntennaTiltListener)tiltListener, unit, minAngle, maxAngle){
            private final /* synthetic */ AntennaTiltListener val$tiltListener;
            private final /* synthetic */ Unit val$unit;
            private final /* synthetic */ float val$minAngle;
            private final /* synthetic */ float val$maxAngle;
            {
                this.val$tiltListener = antennaTiltListener;
                this.val$unit = unit;
                this.val$minAngle = f;
                this.val$maxAngle = f2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = this.val$tiltListener;
                synchronized (object) {
                    try {
                        SetTiltRangeSingle.this.myScenarioManager.getAntennaTiltConfigureScenario(this.val$tiltListener, this.val$unit.getId(), this.val$minAngle, this.val$maxAngle).execute();
                        this.val$tiltListener.wait();
                    }
                    catch (Exception e) {
                        Console.error("Tilt " + this.val$unit.getId() + " range set not started in " + SetTiltRangeSingle.this.myAddress, e);
                        SetTiltRangeSingle.this.myTiltOk = false;
                    }
                }
                if (SetTiltRangeSingle.this.myTiltOk) {
                    SetTiltRangeSingle.this.myTimeouted = true;
                    object = this.val$unit;
                    synchronized (object) {
                        try {
                            this.val$unit.wait(60000 + SetTiltRangeSingle.this.myTimeout);
                            if (SetTiltRangeSingle.this.myTimeouted) {
                                Console.error("Tilt " + this.val$unit.getId() + " range set timeout in " + SetTiltRangeSingle.this.myAddress);
                                SetTiltRangeSingle.this.myTiltOk = false;
                            } else {
                                Console.info("Tilt " + this.val$unit.getId() + " range set finished in " + SetTiltRangeSingle.this.myAddress);
                            }
                        }
                        catch (InterruptedException e) {
                            Console.error("Tilt " + this.val$unit.getId() + " range set failed in " + SetTiltRangeSingle.this.myAddress, e);
                            SetTiltRangeSingle.this.myTiltOk = false;
                        }
                    }
                }
                object = this;
                synchronized (object) {
                    this.notify();
                }
            }
        };
        t.start();
        Thread thread = t;
        synchronized (thread) {
            try {
                t.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.myTiltOk;
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }

    private final class TiltListener
    extends AntennaTiltAdapter {
        private final Unit myUnit;

        private TiltListener(Unit unit) {
            this.myUnit = unit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void configuringAccepted() {
            Console.info("Tilt " + this.myUnit.getId() + " range set started in " + SetTiltRangeSingle.this.myAddress);
            TiltListener tiltListener = this;
            synchronized (tiltListener) {
                SetTiltRangeSingle.this.myTimeouted = false;
                ((Object)((Object)this)).notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void configuringFailed(int reason) {
            Console.error("Tilt " + this.myUnit.getId() + " range set not started in " + SetTiltRangeSingle.this.myAddress);
            TiltListener tiltListener = this;
            synchronized (tiltListener) {
                SetTiltRangeSingle.this.myTiltOk = false;
                SetTiltRangeSingle.this.myTimeouted = false;
                ((Object)((Object)this)).notify();
            }
        }
    }

    private final class TiltStateListener
    implements BTSNotificationListener {
        private final Unit myUnit;

        private TiltStateListener(Unit unit) {
            this.myUnit = unit;
        }

        public void btsNotificationReceived(BTSMessage message) {
            DataChangeNotif notif;
            if (message instanceof DataChangeNotif && (notif = (DataChangeNotif)message).getConfigObjectType() == 10) {
                this.checkTiltStateFrom(notif);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkTiltStateFrom(DataChangeNotif notif) {
            NodeList list = notif.getConfigObjectData();
            boolean idOK = false;
            boolean stateOK = false;
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.hasChildNodes()) {
                    String name = node.getNodeName();
                    String value = node.getFirstChild().getNodeValue();
                    if (SetTiltRangeSingle.NODE_ID.equalsIgnoreCase(name) && value.equalsIgnoreCase(String.valueOf(this.myUnit.getId()))) {
                        idOK = true;
                    } else if (SetTiltRangeSingle.NODE_ANTENNA_TILTING_STATE.equalsIgnoreCase(name) && SetTiltRangeSingle.NODEVALUE_STATE_IDLE.equalsIgnoreCase(value)) {
                        stateOK = true;
                    }
                }
                ++i;
            }
            if (idOK && stateOK) {
                Unit unit = this.myUnit;
                synchronized (unit) {
                    SetTiltRangeSingle.this.myTimeouted = false;
                    this.myUnit.notify();
                }
            }
        }
    }
}

