/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.TiltRange;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.message.DataChangeNotif;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.AntennaTiltAdapter;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.AntennaTiltListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSNotificationListener;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetTiltSingle
extends ToolBase {
    private static final String ARG_ID = "id";
    private static final String ARG_ANGLE = "tiltangle";
    private static final String NODE_ID = "_id";
    private static final String NODE_ANTENNA_TILTING_STATE = "AntennaTiltingState";
    private static final String NODEVALUE_STATE_IDLE = "idle";
    private static final String UNIT_TYPE_TILT = "tilt";
    private String myAddress;
    private ScenarioManagerImpl myScenarioManager;
    private boolean myTimeouted;
    private boolean myTiltOk;

    @Override
    protected void reset() {
        this.myTimeouted = false;
        this.myTiltOk = false;
    }

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        List<TiltRange> ranges;
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        FeedbackResult result = new FeedbackResult(this.myAddress);
        try {
            ranges = this.getIdsAndAnglesFrom(args);
        }
        catch (Exception e) {
            Console.error("Invalid id or angle format", e);
            result.setOK(false);
            result.setFeedback("Invalid id or angle format");
            result.setExitCode(3);
            return result;
        }
        if (ranges == null) {
            result.setOK(false);
            result.setFeedback("Invalid id or angle format");
            result.setExitCode(3);
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            BTSConnection connection = connectionInfo.getConnection();
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connection);
            }
            result.setOperationalState(this.getOperationalStateText(site));
            if (site == null) {
                Console.error("Failed to get HW data from " + this.myAddress);
                result.setOK(false);
                result.setFeedback("Failed to get HW data");
                result.setExitCode(96);
            } else {
                this.myScenarioManager = new ScenarioManagerImpl(connection);
                int total = 0;
                int success = 0;
                for (TiltRange range : ranges) {
                    ++total;
                    Unit unit = site.getUnit(range.getId());
                    if (unit == null) {
                        Console.error("Tilt " + range.getId() + " not found from " + this.myAddress);
                        continue;
                    }
                    if (!unit.getUnitType().equalsIgnoreCase(UNIT_TYPE_TILT)) {
                        Console.error("Unit " + range.getId() + " not tilt in " + this.myAddress);
                        continue;
                    }
                    if (!this.set(unit, range.getAngle(), connection)) continue;
                    ++success;
                }
                if (total != success) {
                    result.setOK(false);
                    result.setFeedback(String.valueOf(success) + "/" + total + " set");
                    result.setExitCode(94);
                } else if (total == 0) {
                    Console.error("No tilts found");
                    result.setOK(false);
                    result.setFeedback("No tilts found");
                    result.setExitCode(95);
                } else {
                    result.setFeedback(String.valueOf(success) + "/" + total + " set");
                }
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private List<TiltRange> getIdsAndAnglesFrom(PCmdLineParams args) {
        String idParam = args.getFirstValue(ARG_ID);
        String angleParam = args.getFirstValue(ARG_ANGLE);
        if (idParam == null) {
            Console.error("Missing id information");
            return null;
        }
        if (angleParam == null) {
            Console.error("Missing angle information");
            return null;
        }
        StringTokenizer ids = new StringTokenizer(idParam, ",");
        StringTokenizer angles = new StringTokenizer(angleParam, ",");
        if (ids.countTokens() != angles.countTokens()) {
            Console.error("Mismatch between ids and angles");
            return null;
        }
        ArrayList<TiltRange> ranges = new ArrayList<TiltRange>();
        while (ids.hasMoreTokens()) {
            ranges.add(new TiltRange(Integer.valueOf(ids.nextToken()), Float.valueOf(angles.nextToken()).floatValue()));
        }
        return ranges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean set(Unit unit, float angle, BTSConnection connection) {
        this.myTimeouted = true;
        this.myTiltOk = true;
        TiltStateListener tiltStateListener = new TiltStateListener(unit);
        connection.subscribeNotification((BTSNotificationListener)tiltStateListener);
        TiltListener tiltListener = new TiltListener(unit);
        Thread t = new Thread((AntennaTiltListener)tiltListener, unit, angle){
            private final /* synthetic */ AntennaTiltListener val$tiltListener;
            private final /* synthetic */ Unit val$unit;
            private final /* synthetic */ float val$angle;
            {
                this.val$tiltListener = antennaTiltListener;
                this.val$unit = unit;
                this.val$angle = f;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = this.val$tiltListener;
                synchronized (object) {
                    try {
                        SetTiltSingle.this.myScenarioManager.getAntennaTiltSetScenario(this.val$tiltListener, this.val$unit.getId(), 0, this.val$angle).execute();
                        this.val$tiltListener.wait();
                    }
                    catch (Exception e) {
                        Console.error("Tilt " + this.val$unit.getId() + " set not started in " + SetTiltSingle.this.myAddress, e);
                        SetTiltSingle.this.myTiltOk = false;
                    }
                }
                if (SetTiltSingle.this.myTiltOk) {
                    SetTiltSingle.this.myTimeouted = true;
                    object = this.val$unit;
                    synchronized (object) {
                        try {
                            this.val$unit.wait(60000 + SetTiltSingle.this.myTimeout);
                            if (SetTiltSingle.this.myTimeouted) {
                                Console.error("Tilt " + this.val$unit.getId() + " set timeout in " + SetTiltSingle.this.myAddress);
                                SetTiltSingle.this.myTiltOk = false;
                            } else {
                                Console.info("Tilt " + this.val$unit.getId() + " set finished in " + SetTiltSingle.this.myAddress);
                            }
                        }
                        catch (InterruptedException e) {
                            Console.error("Tilt " + this.val$unit.getId() + " set failed in " + SetTiltSingle.this.myAddress, e);
                            SetTiltSingle.this.myTiltOk = false;
                        }
                    }
                }
                object = this;
                synchronized (object) {
                    this.notify();
                }
            }
        };
        t.start();
        Thread thread = t;
        synchronized (thread) {
            try {
                t.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.myTiltOk;
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }

    private final class TiltListener
    extends AntennaTiltAdapter {
        private final Unit myUnit;

        private TiltListener(Unit unit) {
            this.myUnit = unit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTiltAccepted() {
            Console.info("Tilt " + this.myUnit.getId() + " set started in " + SetTiltSingle.this.myAddress);
            TiltListener tiltListener = this;
            synchronized (tiltListener) {
                SetTiltSingle.this.myTimeouted = false;
                ((Object)((Object)this)).notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTiltFailed(int reason) {
            Console.error("Tilt " + this.myUnit.getId() + " set not started in " + SetTiltSingle.this.myAddress);
            TiltListener tiltListener = this;
            synchronized (tiltListener) {
                SetTiltSingle.this.myTiltOk = false;
                SetTiltSingle.this.myTimeouted = false;
                ((Object)((Object)this)).notify();
            }
        }
    }

    private final class TiltStateListener
    implements BTSNotificationListener {
        private final Unit myUnit;

        private TiltStateListener(Unit unit) {
            this.myUnit = unit;
        }

        public void btsNotificationReceived(BTSMessage message) {
            DataChangeNotif notif;
            if (message instanceof DataChangeNotif && (notif = (DataChangeNotif)message).getConfigObjectType() == 10) {
                this.checkTiltStateFrom(notif);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkTiltStateFrom(DataChangeNotif notif) {
            NodeList list = notif.getConfigObjectData();
            boolean idOK = false;
            boolean stateOK = false;
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.hasChildNodes()) {
                    String name = node.getNodeName();
                    String value = node.getFirstChild().getNodeValue();
                    if (SetTiltSingle.NODE_ID.equalsIgnoreCase(name) && value.equalsIgnoreCase(String.valueOf(this.myUnit.getId()))) {
                        idOK = true;
                    } else if (SetTiltSingle.NODE_ANTENNA_TILTING_STATE.equalsIgnoreCase(name) && SetTiltSingle.NODEVALUE_STATE_IDLE.equalsIgnoreCase(value)) {
                        stateOK = true;
                    }
                }
                ++i;
            }
            if (idOK && stateOK) {
                Unit unit = this.myUnit;
                synchronized (unit) {
                    SetTiltSingle.this.myTimeouted = false;
                    this.myUnit.notify();
                }
            }
        }
    }
}

