/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.VSWRThresholdAdapter;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.VSWRThresholdListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SetVSWRThresholdSingle
extends ToolBase {
    private static final String UNIT_TYPE_ANTENNA_LINE = "AntennaLine";
    private static final String ARG_CELL_ID = "cellid";
    private static final String ARG_RADIO = "radio";
    private static final String ARG_ANTENNA = "antenna";
    private static final String ARG_MINOR = "minor";
    private static final String ARG_MAJOR = "major";
    private String myAddress;
    private boolean myOK;
    private String myFailReason = "Timeout";

    @Override
    protected void reset() {
        this.myFailReason = "Timeout";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        FeedbackResult result = new FeedbackResult(this.myAddress);
        int cell = 0;
        int radio = 0;
        int antenna = 0;
        float minor = 0.0f;
        float major = 0.0f;
        try {
            cell = Integer.valueOf(args.getFirstValue(ARG_CELL_ID));
        }
        catch (Exception e) {
            Console.error("Invalid or missing cell id");
            result.setOK(false);
            result.setFeedback("Invalid cell id");
            result.setExitCode(3);
            return result;
        }
        try {
            radio = Integer.valueOf(args.getFirstValue(ARG_RADIO));
        }
        catch (Exception e) {
            Console.error("Invalid or missing radio");
            result.setOK(false);
            result.setFeedback("Invalid radio");
            result.setExitCode(3);
            return result;
        }
        try {
            antenna = Integer.valueOf(args.getFirstValue(ARG_ANTENNA));
        }
        catch (Exception e) {
            Console.error("Invalid or missing antenna");
            result.setOK(false);
            result.setFeedback("Invalid antenna");
            result.setExitCode(3);
            return result;
        }
        try {
            minor = Float.valueOf(args.getFirstValue(ARG_MINOR)).floatValue();
        }
        catch (Exception e) {
            Console.error("Invalid or missing minor threshold");
            result.setOK(false);
            result.setFeedback("Invalid minor threshold");
            result.setExitCode(3);
            return result;
        }
        try {
            major = Float.valueOf(args.getFirstValue(ARG_MAJOR)).floatValue();
        }
        catch (Exception e) {
            Console.error("Invalid or missing major threshold");
            result.setOK(false);
            result.setFeedback("Invalid minor threshold");
            result.setExitCode(3);
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            BTSConnection connection = connectionInfo.getConnection();
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connection);
            }
            result.setOperationalState(this.getOperationalStateText(site));
            if (site == null) {
                Console.error("Failed to get HW data from " + this.myAddress);
                result.setOK(false);
                result.setFeedback("Failed to get HW data");
                result.setExitCode(101);
            } else {
                int antennaId = this.getAntennaId(site, cell, radio, antenna);
                if (antennaId == -1) {
                    Console.error("Unable to find antenna " + antenna + " from radio " + radio + " in cell " + cell + " in " + this.myAddress);
                    result.setOK(false);
                    result.setFeedback("Antenna not found");
                    result.setExitCode(102);
                } else {
                    VSWRListener listener;
                    VSWRListener vSWRListener = listener = new VSWRListener();
                    synchronized (vSWRListener) {
                        this.myOK = false;
                        new ScenarioManagerImpl(connectionInfo.getConnection()).getVSWRThresholdSetScenario((VSWRThresholdListener)listener, antennaId, major, minor).execute();
                        try {
                            ((Object)((Object)listener)).wait(this.myTimeout);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.myOK) {
                        Console.info("VSWR threshold successfully set for antenna " + antenna + " in radio " + radio + " in cell " + cell + " in " + this.myAddress);
                        result.setFeedback("OK");
                    } else {
                        Console.error("Failed to set VSWR threshold for antenna " + antenna + " in radio " + radio + " in cell " + cell + " in " + this.myAddress);
                        result.setOK(false);
                        result.setFeedback(this.myFailReason);
                        result.setExitCode(100);
                    }
                }
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private int getAntennaId(Site site, int cell, int radio, int antenna) {
        try {
            List units = site.getCell(cell).getCurrentUnits();
            for (Unit unit : units) {
                if (!UNIT_TYPE_ANTENNA_LINE.equalsIgnoreCase(unit.getUnitType()) || unit.getNumber() != antenna || site.getUnit(unit.getParentUnitId()).getNumber() != radio) continue;
                return unit.getId();
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Error while finding the antenna id", (Throwable)e);
        }
        return -1;
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }

    private final class VSWRListener
    extends VSWRThresholdAdapter {
        private VSWRListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void thresholdSet(int id) {
            VSWRListener vSWRListener = this;
            synchronized (vSWRListener) {
                SetVSWRThresholdSingle.this.myOK = true;
                ((Object)((Object)this)).notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void thresholdSettingFailed(int failReason, int id) {
            SetVSWRThresholdSingle.this.myFailReason = SetVSWRThresholdSingle.this.getFailReasonText(failReason);
            VSWRListener vSWRListener = this;
            synchronized (vSWRListener) {
                ((Object)((Object)this)).notify();
            }
        }
    }
}

