/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.poseidon.util.PCmdLineParams;

public class SshServiceSingle
extends ToolBase {
    private String myAddress = null;

    @Override
    public OperationResult run(ConnectionInformation connectionInfo, BTSInformation btsInformation, PCmdLineParams args) {
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        boolean enable = args.isDefined("enable");
        boolean disable = args.isDefined("disable");
        FeedbackResult result = new FeedbackResult(this.myAddress);
        boolean isSshEnabled = this.isSSHEnabled(this.myAddress, 22);
        if (enable) {
            if (isSshEnabled) {
                Console.info("SSH service is already enabled for address:" + this.myAddress);
                result.setFeedback("SSH service is already enabled");
            } else if (this.enableRemoteAccess(this.myAddress, username, password)) {
                Console.info("Successfully enable SSH service for address: " + this.myAddress);
                result.setFeedback("Success");
            } else {
                Console.error("Failed to enable SSH service for address:" + this.myAddress);
                result.setExitCode(135);
                result.setFeedback("Failed");
            }
        } else if (disable) {
            if (!isSshEnabled) {
                Console.info("SSH service is already disabled for address: " + this.myAddress);
                result.setFeedback("SSH service is already disabled");
            } else if (this.disableRemoteAccess(this.myAddress, username, password)) {
                Console.info("Successfully disable SSH service for address: " + this.myAddress);
                result.setFeedback("Success");
            } else {
                Console.error("Failed to disable SSH service for address:" + this.myAddress);
                result.setExitCode(135);
                result.setOK(false);
                result.setFeedback("Failed");
            }
        }
        return result;
    }

    @Override
    protected String getDefaultConnectionType() {
        return null;
    }
}

