/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.SwVersionGetResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.scenario.ScenarioManager;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.io.File;
import org.apache.log4j.Logger;

public class SwVersionGetter
extends ToolBase {
    private File myFile = null;

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        SwVersionGetResult result = new SwVersionGetResult();
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(btsInformation.getBTSAddress(), btsInformation.getUserName(), btsInformation.getPassword(), this.getCredentialsFrom(args));
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            String address = connectionInfo.getAddress();
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connectionInfo.getConnection());
            }
            result.setOperationalState(this.getOperationalStateText(site));
            result.setAddress(address);
            this.myFile = this.getCurrentBD((ScenarioManager)new ScenarioManagerImpl(connectionInfo.getConnection()));
            if (this.myFile != null) {
                result.setSWVersionFile(this.myFile);
                Console.info("Successfully got SW versions from " + address);
            } else {
                result.setOK(false);
                result.setExitCode(50);
                Console.error("Failed to get SW versions from " + address);
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getCurrentBD(ScenarioManager s) {
        final File[] file = new File[1];
        FileTransferAdapter l = new FileTransferAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileTransferSucceeded(String strFileId) {
                file[0] = new File(strFileId);
                1 var2_2 = this;
                synchronized (var2_2) {
                    ((Object)((Object)this)).notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileTransferFailed(String strFileId) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    ((Object)((Object)this)).notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileSetTransferFailed(int reason) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    ((Object)((Object)this)).notify();
                }
            }
        };
        try {
            FileTransferAdapter fileTransferAdapter = l;
            synchronized (fileTransferAdapter) {
                s.getSWVersionScenario((FileTransferListener)l).execute();
                l.wait(this.myTimeout);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).fatal((Object)"Getting SW versions failed", (Throwable)e);
        }
        return file[0];
    }

    @Override
    protected String getDefaultConnectionType() {
        return "read-only";
    }
}

