/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.RXTestResult;
import com.nokia.em.bts.coreasset.application.tools.TestModelResult;
import com.nokia.em.bts.coreasset.application.tools.TestModelSingle;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TestModelImpl
extends ToolImpl {
    private static final String COLUMN_RELIABILITY = "Reliable";
    private static final String COLUMN_TIME = "Time";
    private static final String COLUMN_UNRECEIVED_BLOCKS = "Unreceived blocks";
    private static final String COLUMN_RECEIVED_BLOCKS = "Received blocks";
    private static final String COLUMN_DEFECTED_BITS = "Defected bits";
    private static final String COLUMN_RECEIVED_BITS = "Received bits";
    private static final String COLUMN_THROUGHPUT = "Throughput %";
    private static final String COLUMN_RESULT = "Test Model Result";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private List<TestModelResult> myResults = new ArrayList<TestModelResult>();

    public TestModelImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return "Test Model";
    }

    @Override
    public String getVersion() {
        return "2.1";
    }

    @Override
    public String getFilePrefix() {
        return "TestModel";
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add((TestModelResult)result);
    }

    @Override
    public String getResults() {
        if (this.myResults.size() == 1) {
            return this.getSingleResult(this.myResults.get(0));
        }
        return this.getMultipleResults();
    }

    public String getSingleResult(TestModelResult result) {
        if (result.getTXResult() != null) {
            return this.getTXTestResult(result);
        }
        if (result.getRXResults() != null) {
            return this.getRXTestResult(result);
        }
        return "";
    }

    private String getTXTestResult(TestModelResult result) {
        StringBuffer sb = new StringBuffer();
        sb.append("Local cell ").append(result.getTXResult().getLocalCellId()).append(LF);
        sb.append("Test model: ").append(result.getTXResult().getTestModel()).append(LF);
        sb.append("Carrier frequency: ").append(result.getTXResult().getFrequency()).append(LF);
        sb.append("Physical cell ID: ").append(result.getTXResult().getPhyCellId()).append(LF);
        sb.append("Test result from external measuring equipment: ").append(result.getTXResult().getTestResult()).append(LF).append(LF);
        sb.append("Duration: ").append(result.getTXResult().getDuration()).append(LF);
        return sb.toString();
    }

    private String getRXTestResult(TestModelResult result) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTestSummary(result));
        sb.append(LF);
        sb.append(LF);
        ToolSummaryTable resultTable = new ToolSummaryTable(COLUMN_TIME, COLUMN_RELIABILITY, COLUMN_THROUGHPUT, COLUMN_RECEIVED_BITS, COLUMN_DEFECTED_BITS, COLUMN_RECEIVED_BLOCKS, COLUMN_UNRECEIVED_BLOCKS);
        RXTestResult cumulativeRx = null;
        for (RXTestResult rx : result.getRXResults()) {
            if (rx.isOK()) {
                if (cumulativeRx == null) {
                    cumulativeRx = rx;
                } else {
                    cumulativeRx.add(rx);
                }
            }
            resultTable.addRow(this.getRow(rx));
        }
        if (cumulativeRx != null) {
            resultTable.addRow("");
            resultTable.addRow(this.getCumulativeRow(cumulativeRx));
        }
        sb.append(resultTable.toString());
        return sb.toString();
    }

    private String getTestSummary(TestModelResult result) {
        ToolSummaryTable table = new ToolSummaryTable("A", "B");
        table.setShowHeader(false);
        table.addRow("Resource block offset", String.valueOf(result.getOffset()));
        table.addRow("Carrier frequency", String.valueOf(String.valueOf(Double.valueOf(result.getFrequency()) / 10.0)) + " MHz");
        return table.toString();
    }

    private List<String> getRow(RXTestResult rx) {
        ArrayList<String> row = new ArrayList<String>();
        row.add(DATE_FORMAT.format(rx.getDate()));
        row.add(rx.isOK() ? "Yes" : "No");
        if (rx.isOK()) {
            row.addAll(this.getDetailsFrom(rx));
        }
        return row;
    }

    private List<String> getCumulativeRow(RXTestResult rx) {
        ArrayList<String> row = new ArrayList<String>();
        row.add("Cumulative");
        row.add("");
        row.addAll(this.getDetailsFrom(rx));
        return row;
    }

    private List<String> getDetailsFrom(RXTestResult rx) {
        ArrayList<String> row = new ArrayList<String>();
        row.add(String.valueOf(rx.getThroughputPercentage()));
        row.add(String.valueOf(rx.getReceivedBits()));
        row.add(String.valueOf(rx.getDefectedBits()));
        row.add(String.valueOf(rx.getReceivedBlocks()));
        row.add(String.valueOf(rx.getUnreceivedBlocks()));
        return row;
    }

    public String getMultipleResults() {
        ToolSummaryTable table = new ToolSummaryTable();
        this.generateColumnsTo(table);
        this.generateRowsTo(table);
        return table.toString();
    }

    private void generateColumnsTo(ToolSummaryTable table) {
        table.addColumn("Site");
        table.addColumn("Site Status");
        table.addColumn(COLUMN_RESULT);
    }

    private void generateRowsTo(ToolSummaryTable table) {
        for (TestModelResult result : this.myResults) {
            this.generateRow(table, result);
        }
    }

    private void generateRow(ToolSummaryTable table, TestModelResult result) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(result.getAddress());
        if (result.isConnected()) {
            this.insertToolResults(values, result);
        } else if (!result.isLoggedIn()) {
            values.add("Login failed");
        } else if (result.isReserved()) {
            values.add("Reserved");
        } else {
            values.add("Unreachable");
        }
        table.addRow(values);
    }

    private void insertToolResults(List<String> values, TestModelResult result) {
        values.add(result.getOperationalState());
        values.add(result.isOK() ? "OK" : result.getFeedback());
        String filename = String.valueOf(this.getFilePrefix()) + "_" + result.getAddress() + "_" + SUMMARY_DATE_FORMAT.format(new Date()) + ".txt";
        try {
            this.saveFile(filename, this.getSingleResult(result));
            Console.info("Successfully created " + filename + " for " + result.getAddress());
        }
        catch (IOException e) {
            Console.error("Failed to create " + filename + " for " + result.getAddress());
        }
    }

    @Override
    public String getShortResult() {
        if (this.myResults.size() > 0) {
            return this.myResults.get(0).isOK() ? "OK" : this.myResults.get(0).getFeedback();
        }
        return "No results";
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new TestModelSingle();
    }
}

