/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.RXTestResult;
import com.nokia.em.bts.coreasset.application.tools.TXTestResult;
import com.nokia.em.bts.coreasset.application.tools.TestModelResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Cell;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.btstests.TestAdapter;
import com.nokia.em.bts.coreasset.scenario.btstests.TestListener;
import com.nokia.em.bts.coreasset.scenario.btstests.TestReportAdapter;
import com.nokia.em.bts.coreasset.scenario.btstests.TestReportListener;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class TestModelSingle
extends ToolBase {
    private static final int TIME_OUT_FOR_START_RESPONSE = 150000;
    private static final String UL_CARRIER_FREQUENCY = "ULCarrierFrequency";
    private static final String ARG_TYPE = "type";
    private static final String ARG_CELL_ID = "cellid";
    private static final String ARG_TEST_MODEL = "testmodel";
    private static final String ARG_PHYSICAL_CELL_ID = "phycellid";
    private static final String ARG_RESOURCE_BLOCK_OFFSET = "offset";
    private static final String ARG_REPORTING_INTERVAL = "interval";
    private static final String ARG_DURATION = "duration";
    private static final String EARFCN_DL = "earfcnDL";
    private static final String EARFCN_UL = "earfcnUL";
    private static final String EARFCN = "earfcn";
    private String myAddress;
    private TestType myType = null;
    private boolean myTestStarted = false;
    private String myFailReason;
    private boolean myFinished = false;
    private TimeOutTask myTimeOutTask;
    private Timer myTimer = new Timer();
    private boolean myIsTimeOut = false;
    private List<RXTestResult> myRXResults = new ArrayList<RXTestResult>();

    @Override
    protected void reset() {
        this.myTestStarted = false;
        this.myFinished = false;
        this.myIsTimeOut = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        int cellId;
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        TestModelResult result = new TestModelResult(this.myAddress);
        this.myType = this.getTestType(args.getFirstValue(ARG_TYPE));
        if (this.myType == null) {
            Console.error("Invalid or missing test type");
            result.setOK(false);
            result.setFeedback("Invalid or missing test type");
            result.setExitCode(3);
            return result;
        }
        try {
            cellId = Integer.valueOf(args.getFirstValue(ARG_CELL_ID));
        }
        catch (Exception e) {
            Console.error("Invalid or missing cell", e);
            result.setOK(false);
            result.setFeedback("Invalid or missing cell");
            result.setExitCode(3);
            return result;
        }
        String tmId = args.getFirstValue(ARG_TEST_MODEL);
        if (tmId == null) {
            Console.error("Missing test model");
            result.setOK(false);
            result.setFeedback("Missing test model");
            result.setExitCode(3);
            return result;
        }
        int phyCellId = 0;
        if (this.myType == TestType.TX) {
            try {
                phyCellId = Integer.valueOf(args.getFirstValue(ARG_PHYSICAL_CELL_ID));
            }
            catch (Exception e) {
                Console.error("Invalid or missing physical cell id", e);
                result.setOK(false);
                result.setFeedback("Invalid or missing physical cell id");
                result.setExitCode(3);
                return result;
            }
        }
        int offset = 0;
        if (this.myType == TestType.RX) {
            try {
                offset = Integer.valueOf(args.getFirstValue(ARG_RESOURCE_BLOCK_OFFSET));
            }
            catch (Exception e) {
                Console.error("Invalid or missing resource block offset", e);
                result.setOK(false);
                result.setFeedback("Invalid or missing resource block offset");
                result.setExitCode(3);
                return result;
            }
        }
        int interval = 0;
        if (this.myType == TestType.RX) {
            try {
                interval = Integer.valueOf(args.getFirstValue(ARG_REPORTING_INTERVAL));
            }
            catch (Exception e) {
                Console.error("Invalid or missing reporting interval", e);
                result.setOK(false);
                result.setFeedback("Invalid or missing reporting interval");
                result.setExitCode(3);
                return result;
            }
        }
        int duration = 0;
        try {
            duration = Integer.valueOf(args.getFirstValue(ARG_DURATION));
            if (duration < 10) {
                duration = 10;
            }
        }
        catch (Exception e) {
            Console.error("Invalid or missing duration");
            result.setOK(false);
            result.setFeedback("Invalid or missing duration");
            result.setExitCode(3);
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connectionInfo.getConnection());
            }
            result.setOperationalState(this.getOperationalStateText(site));
            if (site == null) {
                Console.error("Failed to get HW data from " + this.myAddress);
                result.setOK(false);
                result.setFeedback("Failed to get HW data");
                result.setExitCode(103);
            } else {
                Cell cell = site.getCell(cellId);
                if (cell == null) {
                    Console.error("Cell " + cellId + " not found from " + this.myAddress);
                    result.setOK(false);
                    result.setFeedback("Cell not found");
                    result.setExitCode(104);
                } else {
                    SiteTestListener listener;
                    SiteTestListener siteTestListener = listener = new SiteTestListener();
                    synchronized (siteTestListener) {
                        Scenario scenario = null;
                        scenario = this.myType == TestType.RX ? new ScenarioManagerImpl(connectionInfo.getConnection()).getLTEUplinkTPBerTestScenario((TestListener)listener, (TestReportListener)new SiteTestReportListener(), cellId, tmId, offset, interval, this.getEarfcn(cell)) : new ScenarioManagerImpl(connectionInfo.getConnection()).getLTEDLTestModelScenario((TestListener)listener, cellId, tmId, this.getEarfcn(cell), phyCellId);
                        scenario.execute();
                        if (!this.myTestStarted) {
                            this.scheduleTimeOutTask((TestListener)listener, 150000, connectionInfo, result);
                        }
                        if (this.myTestStarted && !this.myIsTimeOut) {
                            try {
                                ((Object)((Object)listener)).wait(duration * 1000);
                            }
                            catch (Exception e) {
                                Logger.getLogger(this.getClass()).error((Object)e.getMessage());
                            }
                            scenario.abort();
                            if (!this.myFinished) {
                                this.scheduleTimeOutTask((TestListener)listener, this.myTimeout, connectionInfo, result);
                            }
                            if (!this.myIsTimeOut) {
                                if (this.myType == TestType.RX) {
                                    result.setRXResults(this.myRXResults);
                                    result.setOffset(String.valueOf(offset));
                                    result.setFrequency(Integer.valueOf(cell.getCustomAttributeValue(UL_CARRIER_FREQUENCY)));
                                } else if (this.myType == TestType.TX) {
                                    LocalTime timeOfDay = LocalTime.ofSecondOfDay(duration);
                                    String time = timeOfDay.toString();
                                    TXTestResult tXResult = new TXTestResult("" + cell.getCellId(), tmId, this.getDLCarrierFrequency(cell), "" + phyCellId, "", time.substring(3));
                                    result.setTXResult(tXResult);
                                }
                            }
                        } else {
                            result.setOK(false);
                            result.setFeedback(this.myFailReason);
                            result.setExitCode(105);
                        }
                    }
                }
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private String getDLCarrierFrequency(Cell cell) {
        String freqString = cell.getCustomAttributeValue("DLCarrierFrequency");
        return String.valueOf(Double.valueOf(freqString) / 10.0) + " MHz";
    }

    private int getEarfcn(Cell cell) {
        String earfcnString = cell.getCustomAttributeValue(EARFCN);
        switch (this.myType) {
            case RX: {
                return Integer.valueOf(cell.getCustomAttributeValue(EARFCN_UL) != null ? cell.getCustomAttributeValue(EARFCN_UL) : earfcnString);
            }
            case TX: {
                return Integer.valueOf(cell.getCustomAttributeValue(EARFCN_DL) != null ? cell.getCustomAttributeValue(EARFCN_DL) : earfcnString);
            }
        }
        return 0;
    }

    private TestType getTestType(String type) {
        try {
            return TestType.valueOf(type.toUpperCase());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getSuccessText(int successCode) {
        switch (successCode) {
            case -1: {
                return "Unexpected code";
            }
            case 2: {
                return "No test";
            }
            case 3: {
                return "Access denied";
            }
            case 4: {
                return "Busy";
            }
            case 5: {
                return "File write error";
            }
            case 6: {
                return "Invalid parameter";
            }
            case 7: {
                return "File transfer error";
            }
            case 8: {
                return "Invalid parameter";
            }
            case 28: {
                return "Invalid message";
            }
            case 10: {
                return "Telecom not responding";
            }
            case 11: {
                return "Telecom rejecting";
            }
            case 12: {
                return "Invalid state";
            }
            case 13: {
                return "Existing test referenced";
            }
            case 14: {
                return "Interrupted by user";
            }
            case 15: {
                return "RROM not responding";
            }
            case 16: {
                return "RROM rejecting";
            }
            case 17: {
                return "Unknown host";
            }
            case 18: {
                return "RFSW rejecting";
            }
        }
        return String.valueOf(successCode);
    }

    private void cancelTimeOutTask() {
        if (this.myTimeOutTask != null) {
            this.myTimeOutTask.cancel();
        }
    }

    private synchronized void scheduleTimeOutTask(TestListener listener, int milSecond, ConnectionInformation conn, FeedbackResult result) {
        try {
            this.cancelTimeOutTask();
            this.myTimeOutTask = new TimeOutTask(listener, conn, result);
            this.myTimer.schedule((TimerTask)this.myTimeOutTask, milSecond);
            listener.wait();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)e.getMessage());
        }
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }

    private final class SiteTestListener
    extends TestAdapter {
        private SiteTestListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testAborted(int cellId, int successCode) {
            if (!TestModelSingle.this.myFinished) {
                TestModelSingle.this.myFinished = true;
                if (successCode != 1) {
                    TestModelSingle.this.myFailReason = TestModelSingle.this.getSuccessText(successCode);
                    Console.error("Failed to stop " + (Object)((Object)TestModelSingle.this.myType) + " test (" + TestModelSingle.this.myFailReason + ") in " + TestModelSingle.this.myAddress);
                } else {
                    Console.info((Object)((Object)TestModelSingle.this.myType) + " test finished in " + TestModelSingle.this.myAddress);
                }
            }
            SiteTestListener siteTestListener = this;
            synchronized (siteTestListener) {
                TestModelSingle.this.cancelTimeOutTask();
                ((Object)((Object)this)).notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testModelStarted(String testModel, int cellId, int successCode) {
            if (successCode != 1) {
                TestModelSingle.this.myFailReason = TestModelSingle.this.getSuccessText(successCode);
                Console.error("Failed to start " + (Object)((Object)TestModelSingle.this.myType) + " test (" + TestModelSingle.this.myFailReason + ") in " + TestModelSingle.this.myAddress);
                TestModelSingle.this.myTestStarted = false;
            } else {
                TestModelSingle.this.myTestStarted = true;
                Console.info((Object)((Object)TestModelSingle.this.myType) + " test started in " + TestModelSingle.this.myAddress);
            }
            SiteTestListener siteTestListener = this;
            synchronized (siteTestListener) {
                TestModelSingle.this.cancelTimeOutTask();
                ((Object)((Object)this)).notify();
            }
        }
    }

    private final class SiteTestReportListener
    extends TestReportAdapter {
        private SiteTestReportListener() {
        }

        public void testReportBERLTETPReceived(String resultStatus, int lcrId, float throughputPercentage, long receivedBits, long defectedBits, long receivedBlocks, long unreceivedBlocks) {
            TestModelSingle.this.myRXResults.add(new RXTestResult(new Date(), resultStatus, lcrId, throughputPercentage, receivedBits, defectedBits, receivedBlocks, unreceivedBlocks));
        }
    }

    static enum TestType {
        RX,
        TX;

    }

    private final class TimeOutTask
    extends TimerTask {
        TestListener listener;
        FeedbackResult result;

        TimeOutTask(TestListener listener, ConnectionInformation conn, FeedbackResult result) {
            this.listener = listener;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TestListener testListener = this.listener;
            synchronized (testListener) {
                Console.error(" Test execute time out ");
                TestModelSingle.this.myIsTimeOut = true;
                this.listener.notify();
                this.result.setOK(false);
                this.result.setExitCode(8);
            }
        }
    }
}

