/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.FilesFetcher;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.DomParserHelper;
import com.nokia.em.bts.coreasset.application.util.ProductInfo;
import com.nokia.em.bts.coreasset.application.util.SiteEMFileParser;
import com.nokia.em.bts.coreasset.commissioning.CommissioningAdapter;
import com.nokia.em.bts.coreasset.commissioning.CommissioningListener;
import com.nokia.em.bts.coreasset.commissioning.CommissioningManager;
import com.nokia.em.bts.coreasset.configuration.BTSConfigurationManager;
import com.nokia.em.bts.coreasset.configuration.ModelAdapter;
import com.nokia.em.bts.coreasset.configuration.ModelListener;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.message.BTSMessageFactory;
import com.nokia.em.bts.coreasset.message.CreateDatabaseFile;
import com.nokia.em.bts.coreasset.message.DatabaseFileCreated;
import com.nokia.em.bts.coreasset.scenario.ScenarioManager;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.fileoperation.GetFileFromBTSAdapter;
import com.nokia.em.bts.coreasset.scenario.fileoperation.GetFileFromBTSListener;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.DirectAccessStatusListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSConnectionImpl;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoAdapter;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoListener;
import com.nokia.em.bts.rp.master.connection.HandShakeAdapter;
import com.nokia.em.bts.rp.master.connection.HandShakeListener;
import com.nokia.em.bts.rp.master.connection.MessageFactory;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.message.ActiveConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.message.LoginUserProfile;
import com.nokia.em.bts.rp.master.message.TRSRequest;
import com.nokia.em.bts.rp.master.message.TRSResponse;
import com.nokia.em.bts.rp.master.security.AuthenticationAdapter;
import com.nokia.em.bts.rp.master.security.AuthenticationListener;
import com.nokia.em.bts.rp.master.security.AuthenticationManager;
import com.nokia.em.bts.rp.master.security.AuthenticationManagerImpl;
import com.nokia.em.bts.rp.master.time.TimeZoneChangeAdapter;
import com.nokia.em.bts.rp.master.time.TimeZoneChangeListener;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.comm.ftp.FtpClient;
import com.nokia.em.poseidon.comm.ftp.FtpException;
import com.nokia.em.poseidon.comm.http.HttpConstants;
import com.nokia.em.poseidon.comm.http.client.HttpClient;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.util.PCmdLineParams;
import com.nokia.em.poseidon.util.TextUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipFile;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ToolBase {
    private static final String ARG_SSH = "ssh";
    private static final int SSH_USERNAME_INDEX = 0;
    private static final int SSH_PASSWORD_INDEX = 1;
    protected static final int RETRY_COUNT = 6;
    protected static final long RETRY_DELAY = 10000L;
    private static final int SSH_KEX_TIMEOUT = 3000;
    private static final int SSH_CONNECT_TIMEOUT = 2000;
    private static final String STATUS_LOGIN_FAILED = "Login failed";
    private static final String STATUS_UNREACHABLE = "Unreachable";
    private static final String STATUS_RESERVED = "Reserved";
    private static final String STATUS_PASSWORD_EXPIRED = "Password expired";
    protected static final String ARG_PORT = "port";
    private static final int TRS_HTTPS_PORT = 6001;
    private static final String TRS_STATUS = "status";
    private static final String TRS_FILE_NAME = "fileName";
    private static final String TRS_IP_ADDRESS = "ipAddress";
    private static final String TRS_PASSWORD = "password";
    private static final String TRS_USER_ID = "userId";
    private static final String TRS_PROTOCOL = "protocol";
    private static final String TRS_FILE_RETRIEVAL_INFO = "fileRetrievalInfo";
    private static final String TRS_RETRIEVE_PARAMETER_RSP = "retrieveParameterRsp";
    private static final String BS_ADDRESS = "_bsAddress";
    private static final String HTTPS = "https";
    private static final String TRS_OK = "ok";
    private static final String HTTP = "HTTP";
    private static final int TIMEOUT_TEN_SECONDS = 10000;
    protected static final String ARG_PW = "pw";
    protected static final String ARG_NE = "ne";
    protected static final String ARG_TIMEOUT = "timeout";
    private static final String ARG_CONNECT_TIMEOUT = "connectout";
    protected static final String ARG_VERBOSE = "verbose";
    protected static final String ARG_OUTDIR = "outdir";
    protected static final String ARG_DEBUG = "debug";
    protected static final int FTP_PORT = 21;
    private static final int TELNET_PORT = 23;
    protected static final int SSH_PORT = 22;
    protected static final int HTTPS_PORT = 443;
    private static final int TEST_PORT = 15008;
    private static final int RECONNECT_DELAY = 5000;
    private static final String SITECONF_XML = "siteconf.xml";
    private static final String LOCAL_FCM_ADDRESS = "192.168.255.16";
    private static final String LOCAL_ADDRESS_PREFIX = "192.168.255";
    private static final String NETWORK_TYPE = "_networkType";
    private static final String _BSID = "_bsId";
    private static final String _ID = "_id";
    private static final String CELL = "Cell";
    private static final String UNIT = "Unit";
    protected static final int TIMEOUT_ONE_MINUTE = 60000;
    protected static final int DEFAULT_PORT = 12000;
    private static final String UNIT_TYPE = "_unitType";
    private static final String FSM = "FSM";
    private static final String HW_RELEASE = "HW.Release";
    protected static final String RELEASE_PREFIX_TL = "TL";
    protected static final String RELEASE_PREFIX_FL = "FL";
    protected static final String RELEASE_PREFIX_LN = "LN";
    protected static final String RELEASE_PREFIX_LNZ = "LNZ";
    protected static final String RELEASE_PREFIX_LNT = "LNT";
    protected String myUsername = "";
    protected String myPassword = "";
    protected boolean myOngoing = true;
    protected boolean myVerbose = false;
    private boolean myLoginTimeouted;
    private boolean myConnectTimeouted;
    private Socket mySocket;
    private OutputStream myOutputStream;
    private InputStream myInputStream;
    private static final int TELENT_WAIT_TIME = 5000;
    protected int myTimeout = 60000;
    private int myConnectTimeout = 60000;
    protected String myOutDir = null;
    protected static final String LF = System.getProperty("line.separator");
    protected static final String RAM = "/ram/";
    protected static final String RAWALARMS = "RawAlarmHistory.txt";
    private static final String DISABLE_CGI_COMMAND = "Disable";
    private static final String ENABLE_CGI_COMMAND = "Enable";
    protected static final String EXTENDED_SETTINGS_CGI = "protected/ExtendedSettings.cgi";
    private static final String CGI_PATH_PREFIX = "protected/";
    private static final String REMOTE_FCM_SSH_CGI = "RemoteFcmSSH.cgi";
    private static final String SSH_CGI = "Ssh.cgi";
    private static final String ENABLEFTM_SSH_PAGE = "EnableFTM_Ssh.html";
    private static final String SSH_SERVICE_PAGE = "sshservice.html";
    private static final int INVALID_DAYS_TO_EXPIRY = -1;
    private static final int INVALID_GRACE_LOGIN_LEFT = -1;
    protected String mySSHUsername = "";
    protected String mySSHPassword = "";
    private boolean myConnectionOk;
    private boolean myLoginOk;
    protected boolean myDebug = false;
    private int myKeepconn;
    protected static final String FS = System.getProperty("file.separator");
    public static final String CLI = "cli";
    public static final String TMP = ".tmp";
    private static final String KEEPCONNECTION = "keepconn";
    private static final int ONE_SECOND_MILLI = 1000;
    private String myConnectionType;
    protected static final String ARG_CONNECTION_TYPE = "conntype";
    protected static final String CONNECTION_TYPE_READONLY = "read-only";
    protected static final String CONNECTION_TYPE_WRITE = "write";
    private boolean isSkipFTP = false;

    public abstract OperationResult run(ConnectionInformation var1, BTSInformation var2, PCmdLineParams var3);

    protected ConnectionInformation connect(String btsAddress, String username, String password) {
        return this.connect(btsAddress, username, password, new LinkedHashMap<String, String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionInformation connect(String btsAddress, String username, String password, Map<String, String> credentials) {
        ConnectionInformation connectionInformation;
        block19: {
            Iterator<String> iterator = credentials.keySet().iterator();
            connectionInformation = new ConnectionInformation();
            connectionInformation.setAddress(btsAddress);
            int port = 12000;
            if (PoseidonRuntime.getRuntime().getParameters().isDefined(ARG_PORT)) {
                port = Integer.valueOf(PoseidonRuntime.getRuntime().getParameters().getFirstValue(ARG_PORT));
            }
            Console.info("Connecting to " + btsAddress + "...");
            while (true) {
                Object object;
                this.myConnectionOk = true;
                this.myLoginOk = true;
                BTSConnectionImpl connection = new BTSConnectionImpl();
                connection.addMessageFactory((MessageFactory)new BTSMessageFactory());
                connection.start();
                connectionInformation.setConnection((BTSConnection)connection);
                AuthenticationManagerImpl authenticationManager = new AuthenticationManagerImpl((BTSConnection)connection);
                AuthListener authenticationListener = new AuthListener(btsAddress, (AuthenticationManager)authenticationManager, connectionInformation);
                ConnectionListener connectionInfoListener = new ConnectionListener(connectionInformation, btsAddress);
                connection.addConnectionInfoListener((ConnectionInfoListener)connectionInfoListener);
                HandShakeAdapter handShakeListener = new HandShakeAdapter((AuthenticationManager)authenticationManager, connectionInformation, username, (AuthenticationListener)authenticationListener, btsAddress, credentials, password, (ConnectionInfoListener)connectionInfoListener, iterator){
                    private final /* synthetic */ AuthenticationManager val$authenticationManager;
                    private final /* synthetic */ ConnectionInformation val$connectionInformation;
                    private final /* synthetic */ String val$username;
                    private final /* synthetic */ AuthenticationListener val$authenticationListener;
                    private final /* synthetic */ String val$btsAddress;
                    private final /* synthetic */ Map val$credentials;
                    private final /* synthetic */ String val$password;
                    private final /* synthetic */ ConnectionInfoListener val$connectionInfoListener;
                    private final /* synthetic */ Iterator val$iterator;
                    {
                        this.val$authenticationManager = authenticationManager;
                        this.val$connectionInformation = connectionInformation;
                        this.val$username = string;
                        this.val$authenticationListener = authenticationListener;
                        this.val$btsAddress = string2;
                        this.val$credentials = map;
                        this.val$password = string3;
                        this.val$connectionInfoListener = connectionInfoListener;
                        this.val$iterator = iterator;
                    }

                    public void authorisationRequired(boolean required) {
                        new LoginThread(this.val$authenticationManager, this.val$connectionInformation, this.val$username, required, this.val$authenticationListener, this.val$btsAddress, this.val$credentials, this.val$password, this.val$connectionInfoListener, this.val$iterator).start();
                    }
                };
                connection.addHandShakeListener((HandShakeListener)handShakeListener);
                BTSInformation btsInformation = this.parseBTSAddressFromSiteEMXML(btsAddress);
                if (btsInformation == null) {
                    Console.error("Unable to get siteEM from address: " + btsAddress);
                    connectionInformation.setConnected(false);
                    return connectionInformation;
                }
                if (btsInformation.getBTSAddress() == null) {
                    btsInformation.setBTSAddress(btsAddress);
                }
                this.injectInterfaceFlags(connectionInformation, btsInformation);
                try {
                    object = connectionInfoListener;
                    synchronized (object) {
                        this.myConnectTimeouted = true;
                        connection.connect(btsInformation.getBTSAddress(), port);
                        ((Object)((Object)connectionInfoListener)).wait(this.myConnectTimeout);
                        if (this.myConnectTimeouted) {
                            this.myConnectionOk = false;
                        }
                    }
                }
                catch (InterruptedException ie) {
                    Logger.getLogger(this.getClass()).debug((Object)"Connect wait interrupted", (Throwable)ie);
                }
                if (this.myConnectionOk && this.myLoginOk) break block19;
                connectionInformation.setConnected(false);
                try {
                    connection.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.myLoginOk) break;
                if (!iterator.hasNext()) {
                    connectionInformation.setLoggedIn(false);
                    Logger.getLogger(this.getClass()).debug((Object)"Stop trying");
                    return connectionInformation;
                }
                try {
                    object = this;
                    synchronized (object) {
                        this.wait(5000L);
                        continue;
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
            Logger.getLogger(this.getClass()).debug((Object)"Other failure");
            return connectionInformation;
        }
        Console.info("Connected to " + btsAddress);
        connectionInformation.setConnected(true);
        connectionInformation.setUsername(this.myUsername);
        connectionInformation.setPassword(this.myPassword);
        return connectionInformation;
    }

    private void injectInterfaceFlags(ConnectionInformation connectionInformation, BTSInformation btsInformation) {
        connectionInformation.setTRSAddress(btsInformation.getTRSAddress());
        connectionInformation.setFileTransferProtocolQueryNeeded(btsInformation.isFileTransferProtocolQueryNeeded());
        connectionInformation.setProduct(btsInformation.getProduct());
        connectionInformation.setGzippedCommissioningFileNeeded(btsInformation.isGzippedCommissioningFileNeeded());
        connectionInformation.setNewTechlogIF(btsInformation.isNewTechlogIF());
    }

    public void connectTelnet(String serverAddress, int serverPort) throws Exception {
        this.mySocket = new Socket(serverAddress, serverPort);
        this.mySocket.setSoTimeout(10000);
        this.myInputStream = this.mySocket.getInputStream();
        this.myOutputStream = this.mySocket.getOutputStream();
        Thread.sleep(5000L);
        Logger.getLogger(this.getClass()).debug((Object)("Telnet connection created to " + serverAddress + " using port " + serverPort));
    }

    public void disconnectTelnet() {
        try {
            this.mySocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.getLogger(this.getClass()).debug((Object)"Telnet disconnected");
    }

    protected void disconnect(ConnectionInformation connectionInfo, boolean disconnect) {
        if (disconnect && connectionInfo != null && connectionInfo.getConnection() != null) {
            String address = connectionInfo.getAddress();
            this.sleep(address);
            Console.info("Disconnected from " + address);
            connectionInfo.getConnection().disconnect();
        }
    }

    private void sleep(String address) {
        try {
            if (this.myKeepconn > 0) {
                Console.info("Connection to " + address + " will be kept for " + this.myKeepconn + " seconds");
                Thread.sleep(this.myKeepconn * 1000);
            }
        }
        catch (InterruptedException e) {
            Console.warn("Failed to keep connection to " + address, e);
        }
    }

    public String sendTelnet(String message) throws Exception {
        String m = message;
        if (!m.endsWith("\r\n")) {
            m = m.concat("\r\n");
        }
        return new String(this.sendTelnet(m.getBytes()));
    }

    public byte[] sendTelnet(ByteBuffer message) throws Exception {
        return this.sendTelnet(message.array());
    }

    public byte[] sendTelnet(byte[] message) throws Exception {
        this.myOutputStream.write(message);
        this.myOutputStream.flush();
        this.logBytes("Sent via telnet: ", message);
        Thread.sleep(5000L);
        return this.readTelnet();
    }

    private byte[] readTelnet() throws Exception {
        int c;
        ArrayList<Byte> responseBytes = new ArrayList<Byte>();
        while ((c = this.myInputStream.read()) != -1) {
            responseBytes.add((byte)c);
            if (this.myInputStream.available() == 0) break;
        }
        byte[] response = new byte[responseBytes.size()];
        int i = 0;
        while (i < response.length) {
            response[i] = (Byte)responseBytes.get(i);
            ++i;
        }
        Logger.getLogger(this.getClass()).debug((Object)(" Read message: " + new String(response)));
        return response;
    }

    protected void logBytes(String s, byte[] data) {
        String toLog = "";
        int i = 0;
        while (i < data.length) {
            if (i % 8 == 0) {
                toLog = String.valueOf(toLog) + "\n";
            } else if (i > 0) {
                toLog = String.valueOf(toLog) + ", ";
            }
            int tmp = 0xFF & data[i];
            if (tmp < 16) {
                toLog = String.valueOf(toLog) + "0";
            }
            toLog = String.valueOf(toLog) + Integer.toHexString(tmp);
            ++i;
        }
        Logger.getLogger(this.getClass()).debug((Object)(String.valueOf(s) + toLog));
    }

    protected boolean copyFile(File from, File to) {
        boolean ok = true;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int length;
            in = new FileInputStream(from);
            out = new FileOutputStream(to, false);
            byte[] buffer = new byte[4096];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
        }
        catch (Exception e) {
            Console.error("Writing file " + to.getName() + " failed", e);
        }
        try {
            ((OutputStream)out).close();
            ((InputStream)in).close();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Closing stream(s) failed", (Throwable)e);
        }
        return ok;
    }

    public boolean isOngoing() {
        return this.myOngoing;
    }

    private BTSInformation parseBTSAddressFromSiteEMXML(String siteAddress) {
        try {
            return new SiteEMFileParser().getAddress(siteAddress);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)("Failed to get SiteEM.xml from " + siteAddress), (Throwable)e);
            return null;
        }
    }

    protected String getBTSAddress(File f) {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f).getElementsByTagName(BS_ADDRESS).item(0).getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to get BTS address from siteconf", (Throwable)e);
            return null;
        }
    }

    protected File getTRSXMLFile(BTSConnection connection, String address) {
        int seqnum = connection.createScenario();
        connection.sendToBTS((BTSMessage)new TRSRequest(seqnum, "<retrieveParameterReq><scope>confFile</scope></retrieveParameterReq>"));
        BTSMessage response = connection.receiveFromBTS(seqnum, (long)this.myTimeout);
        if (response instanceof TRSResponse) {
            Node content = ((TRSResponse)response).getTRSResponse();
            DomParserHelper.StringTarget protocol = new DomParserHelper.StringTarget(TRS_RETRIEVE_PARAMETER_RSP, TRS_FILE_RETRIEVAL_INFO, TRS_PROTOCOL);
            DomParserHelper.StringTarget username = new DomParserHelper.StringTarget(TRS_RETRIEVE_PARAMETER_RSP, TRS_FILE_RETRIEVAL_INFO, TRS_USER_ID);
            DomParserHelper.CharArrayTarget password = new DomParserHelper.CharArrayTarget(TRS_RETRIEVE_PARAMETER_RSP, TRS_FILE_RETRIEVAL_INFO, TRS_PASSWORD);
            DomParserHelper.StringTarget ipAddress = new DomParserHelper.StringTarget(TRS_RETRIEVE_PARAMETER_RSP, TRS_FILE_RETRIEVAL_INFO, TRS_IP_ADDRESS);
            DomParserHelper.StringTarget filename = new DomParserHelper.StringTarget(TRS_RETRIEVE_PARAMETER_RSP, TRS_FILE_RETRIEVAL_INFO, TRS_FILE_NAME);
            DomParserHelper.StringTarget status = new DomParserHelper.StringTarget(TRS_RETRIEVE_PARAMETER_RSP, TRS_STATUS);
            DomParserHelper.parseTarget(content, protocol, username, ipAddress, password, filename, status);
            if (status == null || status.getValue() == null || !((String)status.getValue()).equalsIgnoreCase(TRS_OK)) {
                Logger.getLogger(this.getClass()).error((Object)"Failed to get TRS.xml");
            } else {
                if (((String)protocol.getValue()).toUpperCase().startsWith(HTTP)) {
                    int port = com.nokia.em.poseidon.comm.http.Tools.getTransferPort((String)((String)ipAddress.getValue()), (int)6001);
                    String host = com.nokia.em.poseidon.comm.http.Tools.getTransferIPAddress((String)((String)ipAddress.getValue()));
                    HttpClient http = new HttpClient(host, port);
                    http.setSecure(((String)protocol.getValue()).equalsIgnoreCase(HTTPS));
                    http.setUserName((String)username.getValue());
                    http.setPassword(String.valueOf((char[])password.getValue()));
                    http.setAuthentication(HttpConstants.Authentication.AUTHENTICATION_BASIC);
                    http.setTrustManager(new X509TrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }
                    });
                    File f = null;
                    try {
                        File t = File.createTempFile(CLI, TMP);
                        t.deleteOnExit();
                        f = http.getFileSynchronously((String)filename.getValue(), t.getAbsolutePath());
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass()).error((Object)"Failed to get TRS.xml", (Throwable)e);
                    }
                    return f;
                }
                Logger.getLogger(this.getClass()).error((Object)"Protocol is not HTTP, other protocols are not supported.");
            }
        } else {
            Logger.getLogger(this.getClass()).error((Object)"Failed to get proper response for TRSRequest");
        }
        return null;
    }

    protected BTSConfigurationManager getConfigurationManager(BTSConnection connection) {
        return CoreAsset.startBTSConfigurationManager((BTSConnection)connection, (TimeZoneChangeListener)new TimeZoneChangeAdapter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Site buildHWModel(BTSConnection connection) {
        final BTSConfigurationManager configurationManager = this.getConfigurationManager(connection);
        final Site[] site = new Site[1];
        configurationManager.buildHWModel((ModelListener)new ModelAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void buildSucceeded() {
                site[0] = configurationManager.getSite();
                BTSConfigurationManager bTSConfigurationManager = configurationManager;
                synchronized (bTSConfigurationManager) {
                    configurationManager.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void buildFailed() {
                BTSConfigurationManager bTSConfigurationManager = configurationManager;
                synchronized (bTSConfigurationManager) {
                    configurationManager.notify();
                }
            }
        });
        try {
            BTSConfigurationManager bTSConfigurationManager = configurationManager;
            synchronized (bTSConfigurationManager) {
                configurationManager.wait();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dealWithConfigurationManager(configurationManager);
        return site[0];
    }

    protected void dealWithConfigurationManager(BTSConfigurationManager configurationManager) {
    }

    protected int getSiteId(File f) {
        try {
            return Integer.valueOf(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f).getElementsByTagName(_BSID).item(0).getFirstChild().getNodeValue());
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to get site id from siteconf", (Throwable)e);
            return 0;
        }
    }

    protected FSMType getFSMType(File f) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f);
            NodeList units = doc.getElementsByTagName(UNIT);
            int i = 0;
            while (i < units.getLength()) {
                NodeList unitnodes = units.item(i).getChildNodes();
                boolean found = false;
                boolean rel3 = false;
                int o = 0;
                while (o < unitnodes.getLength()) {
                    Node n = unitnodes.item(o);
                    if (n.getNodeName().equals(UNIT_TYPE) && n.hasChildNodes() && FSM.equalsIgnoreCase(n.getFirstChild().getNodeValue())) {
                        found = true;
                    } else if (n.getNodeName().equals(HW_RELEASE) && n.hasChildNodes() && FSMType.REL3.toString().equalsIgnoreCase(n.getFirstChild().getNodeValue())) {
                        rel3 = true;
                    }
                    ++o;
                }
                if (found) {
                    return rel3 ? FSMType.REL3 : FSMType.REL2;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to get system module type from siteconf", (Throwable)e);
        }
        return FSMType.REL2;
    }

    protected List<Integer> getCellIds(File f) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f);
            NodeList cells = doc.getElementsByTagName(CELL);
            int i = 0;
            while (i < cells.getLength()) {
                NodeList cellnodes = cells.item(i).getChildNodes();
                int o = 0;
                while (o < cellnodes.getLength()) {
                    Node n = cellnodes.item(o);
                    if (n.getNodeName().equals(_ID) && n.hasChildNodes()) {
                        ids.add(Integer.valueOf(n.getFirstChild().getNodeValue()));
                    }
                    ++o;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to get cell ids from siteconf", (Throwable)e);
        }
        return ids;
    }

    protected String getTechtype(File f) {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f).getElementsByTagName(NETWORK_TYPE).item(0).getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to get tech type from siteconf", (Throwable)e);
            return null;
        }
    }

    protected File getSiteconf(BTSConnection c) {
        File[] file = new File[1];
        int seqNumber = c.createScenario();
        CreateDatabaseFile createDb = new CreateDatabaseFile(seqNumber, 11, SITECONF_XML);
        c.sendToBTS((BTSMessage)createDb);
        BTSMessage response = c.receiveFromBTS(seqNumber, 60000L);
        if (response instanceof DatabaseFileCreated) {
            DatabaseFileCreated temp = (DatabaseFileCreated)response;
            try {
                FTPTransferInfo ftpTransferInfo = temp.getFTPTransferInfo();
                if (ftpTransferInfo != null && ftpTransferInfo.getFileId() != null) {
                    FileTransferClient client = c.getFileTransferFactory().getFileTransferClient();
                    client.setFTPTransferInfo(ftpTransferInfo);
                    file[0] = client.getFile();
                    file[0].deleteOnExit();
                    c.sendToBTS((BTSMessage)new FileLoadCompleted(seqNumber, new String[]{ftpTransferInfo.getFileId()}));
                } else {
                    ftpTransferInfo = ScenarioManagerImpl.getFTPTransferInfo();
                    ftpTransferInfo.setFileName(temp.getFileId());
                    FileTransferClient client = c.getFileTransferFactory().getFileTransferClient();
                    client.setFTPTransferInfo(ftpTransferInfo);
                    file[0] = client.getFile();
                    file[0].deleteOnExit();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        c.deleteScenario(seqNumber);
        return file[0];
    }

    protected File getBTSSCF(ConnectionInformation connectionInfo, ScenarioManager scenarioManager) {
        int count = 0;
        File f = null;
        while (f == null && count++ < 6) {
            f = this.getCommissioningInformation(connectionInfo, scenarioManager);
            if (f != null) continue;
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getCommissioningInformation(ConnectionInformation connectionInfo, ScenarioManager scenarioManager) {
        final File[] file = new File[1];
        final BTSConnection c = connectionInfo.getConnection();
        final String address = connectionInfo.getAddress();
        if (!connectionInfo.isFileTransferProtocolQueryNeeded()) {
            Logger.getLogger(this.getClass()).debug((Object)"Getting comissioning file old style");
            CommissioningManager commManager = CoreAsset.startCommissioningManager((BTSConnection)c);
            final FilesFetcher.CommissioningFileTransferListener l2 = new FilesFetcher.CommissioningFileTransferListener();
            try {
                FilesFetcher.CommissioningFileTransferListener commissioningFileTransferListener = l2;
                synchronized (commissioningFileTransferListener) {
                    commManager.updateCommissioningInformation((CommissioningListener)new CommissioningAdapter(){

                        public void commissioningInformationUpdated(List<FTPTransferInfo> ftpTransferInfoList) {
                            try {
                                FTPTransferInfo ftpTransferInfo = ftpTransferInfoList.get(0);
                                if (ftpTransferInfo != null && ftpTransferInfo.getFileId() != null) {
                                    FileTransferClient client = c.getFileTransferFactory().getFileTransferClient();
                                    client.setFTPTransferInfo(ftpTransferInfo);
                                    file[0] = client.getFile((FileTransferListener)l2);
                                } else {
                                    ftpTransferInfo = ScenarioManagerImpl.getFTPTransferInfo();
                                    ftpTransferInfo.setFileName(ftpTransferInfoList.get(0).getFileId());
                                    FileTransferClient client = c.getFileTransferFactory().getFileTransferClient();
                                    client.setFTPTransferInfo(ftpTransferInfo);
                                    file[0] = client.getFile((FileTransferListener)l2);
                                }
                            }
                            catch (Exception e) {
                                Logger.getLogger(((Object)((Object)this)).getClass()).fatal((Object)("Getting commissioning file failed from " + address), (Throwable)e);
                            }
                        }
                    });
                    ((Object)((Object)l2)).wait(this.myTimeout);
                    if (file[0] == null) {
                        Logger.getLogger(this.getClass()).fatal((Object)("Getting commissioning file failed for timeout from " + address));
                    } else {
                        Logger.getLogger(this.getClass()).debug((Object)("Commisioning file received from " + address));
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).fatal((Object)("Getting commissioning file failed from " + address));
            }
        } else {
            Logger.getLogger(this.getClass()).debug((Object)"Getting comissioning file new style");
            GetFileFromBTSAdapter l = new GetFileFromBTSAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileTransferSucceeded(String tempFileName, String originalFileName) {
                    file[0] = new File(tempFileName);
                    5 var3_3 = this;
                    synchronized (var3_3) {
                        ((Object)((Object)this)).notify();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileTransferSucceeded(String tempFileName, String originalFileName, int failReason) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).fatal((Object)("Getting commissioning file failed for reason " + failReason + " from " + address));
                    5 var4_4 = this;
                    synchronized (var4_4) {
                        ((Object)((Object)this)).notify();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void filesetTransferFailed(int failReason) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).fatal((Object)("Getting commissioning file failed for reason " + failReason + " from " + address));
                    5 var2_2 = this;
                    synchronized (var2_2) {
                        ((Object)((Object)this)).notify();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileTransferFailed(String originalFileName) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).fatal((Object)("Getting commissioning file failed from " + address));
                    5 var2_2 = this;
                    synchronized (var2_2) {
                        ((Object)((Object)this)).notify();
                    }
                }
            };
            try {
                GetFileFromBTSAdapter l2 = l;
                synchronized (l2) {
                    scenarioManager.getGetFileFromBTSScenario((GetFileFromBTSListener)l, ProductInfo.isWBTS(connectionInfo.getProduct()) ? 96 : 97).execute();
                    l.wait(this.myTimeout);
                    if (file[0] == null) {
                        Logger.getLogger(this.getClass()).fatal((Object)("Getting commissioning file failed from " + address));
                    } else {
                        Logger.getLogger(this.getClass()).debug((Object)("Commissioning file received from " + address));
                        if (Tools.isGZipFile((File)file[0])) {
                            File f = Tools.gunZip((File)file[0]);
                            if (!file[0].delete()) {
                                file[0].deleteOnExit();
                            }
                            return f;
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).fatal((Object)"Getting commissioning file failed", (Throwable)e);
            }
        }
        return file[0];
    }

    protected File getFile(FtpClient ftpClient, String ftmAddress, String btsAddress, String fileType, String path) {
        return this.getFile(ftpClient, ftmAddress, btsAddress, fileType, path, true);
    }

    protected File getFile(FtpClient ftpClient, String ftmAddress, String btsAddress, String fileType, String path, boolean sshExactMatch) {
        File file = null;
        if (this.mySSHUsername.length() > 0 && this.mySSHPassword.length() > 0) {
            file = this.getFileWithSSH(ftmAddress, 22, fileType, path, sshExactMatch);
            if (file == null) {
                file = this.getFileWithSSH(ftmAddress, 15008, fileType, path, sshExactMatch);
            }
            if (file == null && ftmAddress.startsWith(LOCAL_ADDRESS_PREFIX)) {
                file = this.getFileWithSSH(LOCAL_FCM_ADDRESS, 22, fileType, path, sshExactMatch);
            }
        }
        if (file == null && !this.isSkipFTP) {
            file = this.getFileWithFTPInTime(ftpClient, ftmAddress, fileType, path);
        }
        if (file == null && this.mySSHUsername.length() > 0 && this.mySSHPassword.length() > 0) {
            file = this.getFileWithTelnet(this.mySSHUsername, this.mySSHPassword, btsAddress, 23, fileType, path);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileWithFTPInTime(final FtpClient ftpClient, final String ftmAddress, final String fileType, final String path) {
        final FTPFileThread t = new FTPFileThread(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.setReturnFile(this.getFileWithFTP(ftpClient, ftmAddress, fileType, path));
                6 var1_1 = this;
                synchronized (var1_1) {
                    this.notify();
                }
            }
        };
        Timer timeoutTimer = new Timer();
        TimerTask task = null;
        task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Console.warn("Timeout to get FTP data from " + ftmAddress);
                    ToolBase.this.isSkipFTP = true;
                    ftpClient.disconnect();
                }
                catch (FtpException e) {
                    Logger.getLogger(this.getClass()).error((Object)("FTP client disconnect failed." + (Object)((Object)e)));
                }
                FTPFileThread fTPFileThread = t;
                synchronized (fTPFileThread) {
                    t.notify();
                }
            }
        };
        timeoutTimer.schedule(task, 180000L);
        t.start();
        FTPFileThread fTPFileThread = t;
        synchronized (fTPFileThread) {
            try {
                t.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        timeoutTimer.cancel();
        task.cancel();
        return t.getReturnFile();
    }

    private File getFileWithFTP(FtpClient ftpClient, String ftmAddress, String fileType, String path) {
        File file = null;
        try {
            File f = File.createTempFile(CLI, TMP);
            f.deleteOnExit();
            ftpClient.getFile(String.valueOf(path) + fileType, f.getAbsolutePath());
            file = f;
            Logger.getLogger(this.getClass()).debug((Object)("Successfully got " + fileType + " via FTP from " + ftmAddress));
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)("Failed to get " + fileType + " via FTP from " + ftmAddress), (Throwable)e);
        }
        return file;
    }

    protected boolean isSSHEnabled(String address, int port) {
        try {
            Connection c = new Connection(address, port);
            c.connect(null, 2000, 3000);
            c.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private File getFileWithSSH(String address, int port, String fileName, String path, boolean exactMatch) {
        File file;
        block15: {
            file = null;
            try (Connection c = null;){
                try {
                    c = new Connection(address, port);
                    c.connect(null, 60000, 180000);
                    if (c.authenticateWithPassword(this.mySSHUsername, this.mySSHPassword)) {
                        Logger.getLogger(this.getClass()).debug((Object)("SSH login successfully to " + address + ":" + port + " with " + this.mySSHUsername));
                        Session s = c.openSession();
                        if (exactMatch) {
                            s.execCommand("cat /../.." + path + fileName);
                        } else {
                            s.execCommand("ls /../.." + path + "*" + fileName + "* 2>/dev/null | tail -1 | xargs cat");
                        }
                        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new StreamGobbler(s.getStdout())));
                        StringBuffer sb = new StringBuffer();
                        String line = br.readLine();
                        while (line != null) {
                            sb.append(line).append(LF);
                            line = br.readLine();
                        }
                        br.close();
                        String str = sb.toString().trim();
                        if (str.length() == 0) {
                            Logger.getLogger(this.getClass()).warn((Object)("Empty string received for " + fileName + " via SSH from " + address + ":" + port + ", file probably missing."));
                        } else {
                            File f = File.createTempFile(CLI, TMP);
                            f.deleteOnExit();
                            try {
                                FileWriter out = new FileWriter(f, false);
                                out.write(str);
                                out.close();
                                file = f;
                                Logger.getLogger(this.getClass()).debug((Object)("Successfully got " + fileName + " via SSH from " + address + ":" + port));
                            }
                            catch (Exception e3) {
                                Logger.getLogger(this.getClass()).error((Object)("Writing file " + fileName + " failed from " + address + ":" + port), (Throwable)e3);
                            }
                        }
                        s.close();
                        break block15;
                    }
                    Logger.getLogger(this.getClass()).error((Object)("SSH login failed to " + address + ":" + port + " with " + this.mySSHUsername));
                }
                catch (Exception e2) {
                    Logger.getLogger(this.getClass()).error((Object)("Failed to get " + fileName + " via SSH from " + address + ":" + port), (Throwable)e2);
                    if (c != null) {
                        c.close();
                    }
                }
            }
        }
        return file;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getFileWithTelnet(String username, String password, String address, int port, String fileType, String path) {
        file = null;
        try {
            this.connectTelnet(address, port);
            if (!new String(this.readTelnet()).trim().endsWith("login:")) {
                return null;
            }
            repString = this.sendTelnet(username);
            if (!repString.trim().endsWith("Password:")) {
                return null;
            }
            repString = this.sendTelnet(password);
            if (repString.trim().isEmpty()) {
                Thread.sleep(5000L);
                repString = new String(this.readTelnet());
            }
            if (repString.contains("Login incorrect")) {
                Logger.getLogger(this.getClass()).error((Object)"Telnet login failed");
                return null;
            }
            command = "cat " + path + fileType;
            str = this.sendTelnet(command);
            if (str.length() <= 0) ** GOTO lbl38
            if (str.indexOf("No such file or directory") > 0) {
                return null;
            }
            if (str.trim().equals(command)) {
                Logger.getLogger(this.getClass()).error((Object)"Telnet login failed");
                return null;
            }
            str = str.substring(str.indexOf("\r\n") + 1, str.lastIndexOf("\r\n") - 1);
            f = File.createTempFile("cli", ".tmp");
            f.deleteOnExit();
            try {
                out = new FileWriter(f, false);
                out.write(str);
                out.close();
                file = f;
                Logger.getLogger(this.getClass()).debug((Object)("Successfully got " + fileType + " via Telnet from " + address + "."));
                return file;
            }
            catch (Exception e3) {
                Logger.getLogger(this.getClass()).error((Object)("Writing file " + fileType + " failed from " + address), (Throwable)e3);
                return file;
            }
lbl38:
            // 1 sources

            Logger.getLogger(this.getClass()).error((Object)("Empty string received for " + fileType + " via Telnet from " + address + ", file probably missing."));
            return file;
        }
        catch (Exception e2) {
            Logger.getLogger(this.getClass()).error((Object)("Failed to get " + fileType + " via Telnet from " + address), (Throwable)e2);
            return file;
        }
        finally {
            this.disconnectTelnet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean enableDirectAccess(ScenarioManager s) {
        DirectAccessStatusListener listener;
        final Boolean[] timeout = new Boolean[]{false};
        final boolean[] returnValue = new boolean[]{true};
        DirectAccessStatusListener directAccessStatusListener = listener = new DirectAccessStatusListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void statusChanged() {
                8 var1_1 = this;
                synchronized (var1_1) {
                    timeout[0] = false;
                    this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void statusChangeFailed(int i) {
                returnValue[0] = false;
                8 var2_2 = this;
                synchronized (var2_2) {
                    timeout[0] = false;
                    this.notify();
                }
            }
        };
        synchronized (directAccessStatusListener) {
            try {
                s.getChangeDirectAccessStatusScenario(listener, true).execute();
                listener.wait(15000L);
                if (timeout[0].booleanValue()) {
                    returnValue[0] = false;
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).fatal((Object)"Changing direct access failed", (Throwable)e);
            }
        }
        return returnValue[0];
    }

    protected String removePathFromFilename(String filename) {
        if (filename.indexOf("/") > -1) {
            return filename.substring(filename.lastIndexOf("/") + 1);
        }
        if (filename.indexOf("\\") > -1) {
            return filename.substring(filename.lastIndexOf("\\") + 1);
        }
        return filename;
    }

    protected File unzip(File f) throws Exception {
        ZipFile zipFile = new ZipFile(f);
        File file = this.extract(new BufferedInputStream(zipFile.getInputStream(zipFile.entries().nextElement())));
        zipFile.close();
        return file;
    }

    protected File gunzip(File f) throws Exception {
        return this.extract(new BufferedInputStream(new GZIPInputStream(new FileInputStream(f))));
    }

    private File extract(BufferedInputStream in) throws Exception {
        int size;
        byte[] buffer = new byte[2048];
        File tempFile = File.createTempFile(CLI, TMP);
        tempFile.deleteOnExit();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile), buffer.length);
        while ((size = in.read(buffer, 0, buffer.length)) != -1) {
            ((OutputStream)out).write(buffer, 0, size);
        }
        ((OutputStream)out).close();
        in.close();
        return tempFile;
    }

    protected String getDetails(String operationFeedback) {
        try {
            RAMLValidationContext c;
            if (operationFeedback != null && !operationFeedback.trim().isEmpty() && (c = new RAMLValidationContext(this.getClass().getName(), operationFeedback)).getResults().size() > 0) {
                return ((RAMLValidationResult)c.getResults().get(0)).getDetails();
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).fatal((Object)("Failed to extract details from " + operationFeedback), (Throwable)e);
        }
        return null;
    }

    protected String getFailReasonText(int failReason) {
        switch (failReason) {
            case 40: {
                return "access denied";
            }
            case 27: {
                return "busy";
            }
            case 110: {
                return "disconnected";
            }
            case 30: {
                return "execution error";
            }
            case 37: {
                return "failed";
            }
            case 89: {
                return "file activation failure";
            }
            case 66: {
                return "file not found";
            }
            case 65: {
                return "invalid data";
            }
            case 28: {
                return "invalid message";
            }
            case 86: {
                return "out of range";
            }
            case 68: {
                return ARG_TIMEOUT;
            }
            case 88: {
                return "validation failure";
            }
            case 31: {
                return "unknown object";
            }
            case 117: {
                return "unauthorized";
            }
            case 300: {
                return "port in use";
            }
            case 301: {
                return "failed in BTS";
            }
            case 302: {
                return "rejected by BTS";
            }
            case 303: {
                return "unknown host";
            }
            case 304: {
                return "no files to zip";
            }
            case -1: {
                return "unexpected code";
            }
        }
        return String.valueOf(failReason);
    }

    protected String getOperationalStateText(Site site) {
        int state = site != null ? site.getOperationalState() : -1;
        switch (state) {
            case 38: {
                return "Commissioned";
            }
            case 39: {
                return "Configured";
            }
            case 40: {
                return "Integrated to RAN";
            }
            case 37: {
                return "Not Commissioned";
            }
            case 41: {
                return "On Air";
            }
            case 42: {
                return "Test Dedicated";
            }
        }
        return "Unknown";
    }

    protected Map<String, String> getCredentialsFrom(PCmdLineParams args) {
        String credentials = args.getFirstValue(ARG_PW);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            if (credentials != null) {
                if (credentials.contains(",")) {
                    StringTokenizer st = new StringTokenizer(credentials, ",");
                    while (st.hasMoreTokens()) {
                        String s = st.nextToken();
                        if (!s.contains(":")) continue;
                        String username = s.split(":")[0];
                        String password = s.split(":")[1];
                        map.put(username, password);
                    }
                } else if (credentials.contains(":")) {
                    String userName = credentials.split(":")[0];
                    String password = credentials.split(":")[1];
                    map.put(userName, password);
                } else {
                    Console.error("Invalid parameter format for -pw, username:password expected.");
                }
            }
        }
        catch (Exception e) {
            Console.error("Invalid parameter format for -pw, username:password expected.");
        }
        return map;
    }

    public void setOngoing(boolean b) {
        this.myOngoing = b;
    }

    protected void createUnconnectedResult(OperationResult result, ConnectionInformation connectionInfo) {
        result.setConnected(false);
        result.setOK(false);
        String operationalStatus = "";
        String address = connectionInfo.getAddress();
        if (connectionInfo.isReserved()) {
            result.setReserved(true);
            result.setExitCode(5);
            operationalStatus = STATUS_RESERVED;
        } else if (connectionInfo.isLoggedIn()) {
            Console.error("Cannot connect to " + address);
            operationalStatus = STATUS_UNREACHABLE;
            result.setExitCode(4);
        } else if (connectionInfo.isPwdExpired()) {
            operationalStatus = STATUS_PASSWORD_EXPIRED;
            result.setExitCode(9);
            result.setLoggedIn(false);
        } else {
            operationalStatus = STATUS_LOGIN_FAILED;
            result.setExitCode(6);
            result.setLoggedIn(false);
        }
        result.setAddress(address);
        result.setOperationalState(operationalStatus);
    }

    protected File decompress(File f) {
        try {
            File file = this.unzip(f);
            f.deleteOnExit();
            return file;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)("Unzipping " + f.getName() + " failed"), (Throwable)e);
            try {
                File file = this.gunzip(f);
                f.deleteOnExit();
                return file;
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass()).error((Object)("Gunzipping " + f.getName() + " failed"), (Throwable)ex);
                return f;
            }
        }
    }

    protected boolean enableRemoteAccess(String httpAddress, String httpUsername, String httpPassword) {
        return this.changeRemoteAccess(httpAddress, httpUsername, httpPassword, ENABLE_CGI_COMMAND);
    }

    protected boolean disableRemoteAccess(String httpAddress, String httpUsername, String httpPassword) {
        return this.changeRemoteAccess(httpAddress, httpUsername, httpPassword, DISABLE_CGI_COMMAND);
    }

    private boolean changeRemoteAccess(String httpAddress, String httpUsername, String httpPassword, String s) {
        try {
            HttpClient http = new HttpClient(httpAddress, 443);
            http.setSecure(true);
            http.setAuthentication(HttpConstants.Authentication.AUTHENTICATION_BASIC);
            http.setTrustManager(new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            });
            http.setUserName(httpUsername);
            http.setPassword(httpPassword);
            String hiddenParams = this.getSSHParams(http, ENABLEFTM_SSH_PAGE, SSH_SERVICE_PAGE);
            byte[] resp = http.getByteArraySynchronously(CGI_PATH_PREFIX + s + TextUtils.encodeHTML((String)REMOTE_FCM_SSH_CGI) + hiddenParams);
            if (resp == null && (resp = http.getByteArraySynchronously(CGI_PATH_PREFIX + s + TextUtils.encodeHTML((String)SSH_CGI) + hiddenParams)) == null) {
                resp = http.getByteArraySynchronously(CGI_PATH_PREFIX + s.toLowerCase() + TextUtils.encodeHTML((String)SSH_CGI) + hiddenParams);
            }
            return resp != null;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).fatal((Object)("Failed to " + s + " remote access:"), (Throwable)e);
            return false;
        }
    }

    protected String getSSHParams(HttpClient http, String url, String bkUrl) throws FileNotFoundException, IOException {
        http.setUseUrlEncoding(false);
        String hiddenParams = "";
        File sshHtml = http.getFileSynchronously(CGI_PATH_PREFIX + TextUtils.encodeHTML((String)url));
        if (sshHtml == null || this.readFileContent(sshHtml).isEmpty()) {
            Logger.getLogger(this.getClass()).info((Object)(String.valueOf(url) + " is not found"));
            sshHtml = http.getFileSynchronously(CGI_PATH_PREFIX + TextUtils.encodeHTML((String)bkUrl));
        }
        if (sshHtml != null && !this.readFileContent(sshHtml).isEmpty()) {
            if (this.myDebug) {
                Logger.getLogger(this.getClass()).info((Object)("Page " + url + "Content: " + this.readFileContent(sshHtml)));
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(sshHtml)));
            String line = "";
            String stampValue = "";
            String tokenValue = "";
            String frameValue = "";
            while ((line = reader.readLine()) != null) {
                int end;
                int start;
                if (line.indexOf("hidden") <= 0) continue;
                if (line.indexOf("stamp") > 0) {
                    start = line.indexOf("value") + 7;
                    end = line.length() - 2;
                    stampValue = line.substring(start, end);
                    continue;
                }
                if (line.indexOf("token") > 0) {
                    start = line.indexOf("value") + 7;
                    end = line.length() - 2;
                    tokenValue = line.substring(start, end);
                    continue;
                }
                if (line.indexOf("frame") <= 0) continue;
                start = line.indexOf("value") + 7;
                end = line.length() - 2;
                frameValue = line.substring(start, end);
            }
            if (!tokenValue.isEmpty()) {
                hiddenParams = "?stamp=" + stampValue + "&token=" + tokenValue + "&frame=" + frameValue;
            }
            reader.close();
        } else {
            Logger.getLogger(this.getClass()).debug((Object)"SSH service page is not connectable");
        }
        Logger.getLogger(this.getClass()).debug((Object)(" ssh hidden params are " + hiddenParams));
        return hiddenParams;
    }

    private String readFileContent(File file) {
        try {
            StringBuffer buffer = new StringBuffer();
            FileInputStream is = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append(LF);
                line = reader.readLine();
            }
            reader.close();
            ((InputStream)is).close();
            return buffer.toString().trim();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)("Exception happened when parse File " + file.getName()));
            return "";
        }
    }

    protected void parseCommonParamsFrom(PCmdLineParams args) {
        this.myVerbose = args.isDefined(ARG_VERBOSE);
        this.myDebug = args.isDefined(ARG_DEBUG);
        if (args.getFirstValue(ARG_TIMEOUT) != null) {
            this.myTimeout = 1000 * Integer.parseInt(args.getFirstValue(ARG_TIMEOUT));
            if (this.myTimeout < 0) {
                this.myTimeout = 0;
            }
        }
        if (args.getFirstValue(ARG_CONNECT_TIMEOUT) != null) {
            this.myConnectTimeout = 1000 * Integer.parseInt(args.getFirstValue(ARG_CONNECT_TIMEOUT));
            if (this.myConnectTimeout < 0) {
                this.myConnectTimeout = 0;
            }
        }
        if (args.getFirstValue(ARG_OUTDIR) != null) {
            this.myOutDir = args.getFirstValue(ARG_OUTDIR);
            while (this.myOutDir.startsWith("\"")) {
                this.myOutDir = this.myOutDir.substring(1);
            }
            while (this.myOutDir.endsWith("\"")) {
                this.myOutDir = this.myOutDir.substring(0, this.myOutDir.length() - 1);
            }
            if (this.myOutDir.length() > 0) {
                if (!new File(this.myOutDir).mkdirs() && !new File(this.myOutDir).exists()) {
                    Console.error("Failed to create output directory " + this.myOutDir);
                    this.myOutDir = null;
                }
            } else {
                this.myOutDir = null;
            }
        }
        this.parseConnectionType(args);
        this.parseKeepconn(args);
    }

    protected void parseConnectionType(PCmdLineParams args) {
        String connType = args.getFirstValue(ARG_CONNECTION_TYPE);
        if (connType != null) {
            if (CONNECTION_TYPE_READONLY.equalsIgnoreCase(connType)) {
                this.myConnectionType = CONNECTION_TYPE_READONLY;
            } else if (CONNECTION_TYPE_WRITE.equalsIgnoreCase(connType)) {
                this.myConnectionType = CONNECTION_TYPE_WRITE;
            } else {
                Console.warn("Unrecognized connection type " + connType);
                this.myConnectionType = this.getDefaultConnectionType();
            }
        } else {
            this.myConnectionType = this.getDefaultConnectionType();
        }
    }

    private void parseKeepconn(PCmdLineParams args) {
        String keepconn;
        if (args.getFirstValue(KEEPCONNECTION) != null && TextUtils.isNumeric((String)(keepconn = args.getFirstValue(KEEPCONNECTION)))) {
            this.myKeepconn = Integer.parseInt(keepconn);
        }
    }

    protected String getOutDir() {
        return this.myOutDir != null ? String.valueOf(this.myOutDir) + FS : "";
    }

    protected FeedbackResult getInvalidParameterFeedbackResult(FeedbackResult result, String text) {
        Console.error(text);
        result.setOK(false);
        result.setFeedback(text);
        result.setExitCode(3);
        return result;
    }

    protected String getSSHUsernameFrom(PCmdLineParams args) {
        return this.getSSHInformationFrom(args, 0);
    }

    protected String getSSHPasswordFrom(PCmdLineParams args) {
        return this.getSSHInformationFrom(args, 1);
    }

    protected String getSSHInformationFrom(PCmdLineParams args, int index) {
        String sshCredentials = args.getFirstValue(ARG_SSH);
        if (sshCredentials != null) {
            if (sshCredentials.contains(":")) {
                return sshCredentials.split(":")[index];
            }
            Console.error("Invalid parameter format for -ssh, username:password expected.");
        }
        return "";
    }

    protected boolean isSupportReadonlyConnection(ConnectionInformation ci) {
        return ProductInfo.isAfterLTEOrSC15A(ci.getProduct());
    }

    protected boolean isVersionBiggerThan16(String releaseVersion) {
        int version = this.getDigitFrom(releaseVersion);
        return version == 0 || version >= 16;
    }

    private int getDigitFrom(String str) {
        String digitString = "";
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (Character.isDigit(c)) {
                digitString = String.valueOf(digitString) + c;
            }
            ++i;
        }
        if (digitString.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(digitString);
    }

    protected boolean isAfterRL70(ConnectionInformation c) {
        return ProductInfo.isSinceRL70(c.getProduct());
    }

    protected boolean isLTEMacroAfter15A(ConnectionInformation c) {
        return ProductInfo.isAfterLTE15A(c.getProduct());
    }

    private int getFirstDigitFrom(String str) {
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (Character.isDigit(c)) {
                return c - 48;
            }
            ++i;
        }
        return -1;
    }

    protected abstract String getDefaultConnectionType();

    private int getDaysToPasswordExpiry(LoginUserProfile userProfile) {
        String dayString = userProfile.getDaysToPasswordExpiry();
        if (dayString != null && !dayString.isEmpty()) {
            try {
                int num = Integer.valueOf(dayString);
                return num;
            }
            catch (NumberFormatException e) {
                Logger.getLogger(this.getClass()).error((Object)("Invalid daysToPasswordExpiry value: " + dayString + ", it should be number"));
            }
        }
        return -1;
    }

    private int getGraceLoginLeft(LoginUserProfile userProfile) {
        String left = userProfile.getGraceLoginsLeft();
        if (left != null && !left.isEmpty()) {
            try {
                int num = Integer.valueOf(left);
                return num;
            }
            catch (NumberFormatException e) {
                Logger.getLogger(this.getClass()).error((Object)("Invalid graceLoginsLeft value: " + left + ", it should be number"));
            }
        }
        return -1;
    }

    protected void reset() {
    }

    private final class AuthListener
    extends AuthenticationAdapter {
        private String myBtsAddress;
        private AuthenticationManager myAuthenticationManager;
        private ConnectionInformation myConnInfo;

        public AuthListener(String btsAddress, AuthenticationManager authenticationManager, ConnectionInformation connInfo) {
            this.myBtsAddress = btsAddress;
            this.myAuthenticationManager = authenticationManager;
            this.myConnInfo = connInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loginDenied(int intReason) {
            AuthListener authListener = this;
            synchronized (authListener) {
                ToolBase.this.myLoginTimeouted = false;
                ToolBase.this.myLoginOk = false;
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append("Login failed to ").append(this.myBtsAddress).append(": ");
                switch (intReason) {
                    case 116: {
                        Console.error(errorMsg.append(this.generateWriteAccessReserveredMsg()).toString());
                        break;
                    }
                    case 118: {
                        Console.error(errorMsg.append("Access denied due to pending login delay.").toString());
                        break;
                    }
                    case 75: {
                        Console.error(errorMsg.append("Incorrect user name or password.").toString());
                        break;
                    }
                    case 141: {
                        Console.error(errorMsg.append("BTS has started up after reset and a restricted login period is active for 30 seconds.").toString());
                        break;
                    }
                    case 140: {
                        this.myConnInfo.setPwdExpired(true);
                        Console.error(errorMsg.append(this.generatePwdExpiredMsg()).toString());
                        break;
                    }
                    case 30: {
                        Console.error(errorMsg.append("Execution error").toString());
                        break;
                    }
                    case 142: {
                        Console.error(errorMsg.append("BTS local account is blocked. Contact your system administrator.").toString());
                        break;
                    }
                    default: {
                        Console.error(errorMsg.append("Unknown failed code: " + intReason).toString());
                    }
                }
                ((Object)((Object)this)).notify();
            }
        }

        private String generateWriteAccessReserveredMsg() {
            String user = "";
            String ipAddress = "";
            ActiveConnection activeConnection = this.myAuthenticationManager.getActiveConnection();
            if (activeConnection != null) {
                user = activeConnection.getUserName();
                ipAddress = activeConnection.getIpAddress();
            }
            return "User " + user + " with write access rights is already connected to the BTS from address " + ipAddress;
        }

        private String generatePwdExpiredMsg() {
            LoginUserProfile profile = this.myAuthenticationManager.getUserProfile();
            if (profile.isLocalAccountNonSSO()) {
                return "BTS local password has expired. Please change the password.";
            }
            if (profile.isLocalAccountSSO() || profile.isCentralizedAccount()) {
                return "Your password has expired. Please contact your network administrator to get the password changed.";
            }
            return "BTS local password has expired.";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loginFailed() {
            AuthListener authListener = this;
            synchronized (authListener) {
                ToolBase.this.myLoginTimeouted = false;
                ToolBase.this.myLoginOk = false;
                ((Object)((Object)this)).notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loginGranted() {
            AuthListener authListener = this;
            synchronized (authListener) {
                ToolBase.this.myLoginTimeouted = false;
                ToolBase.this.myLoginOk = true;
                ((Object)((Object)this)).notify();
            }
        }
    }

    private final class ConnectionListener
    extends ConnectionInfoAdapter {
        private final String myAddress;
        private final ConnectionInformation myConnectionInfo;

        private ConnectionListener(ConnectionInformation connectionInformation, String btsAddress) {
            this.myAddress = btsAddress;
            this.myConnectionInfo = connectionInformation;
        }

        public void btsDisconnected() {
            Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)("Disconnected from " + this.myAddress));
        }

        public void btsConnected() {
            Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)("Connected to " + this.myAddress));
        }

        public void disconnectingFailed() {
            Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)("Disconnecting failed from " + this.myAddress));
        }

        public void disconnectingSucceeded() {
            Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)("Disconnecting succeeded from " + this.myAddress));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void btsCertificateRejected() {
            Console.error("BTS certificate rejected to " + this.myAddress);
            ToolBase.this.myConnectTimeouted = false;
            ToolBase.this.myConnectionOk = false;
            ConnectionListener connectionListener = this;
            synchronized (connectionListener) {
                ((Object)((Object)this)).notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void btsConnectionRefused(String strAddress) {
            if (ToolBase.this.isSupportReadonlyConnection(this.myConnectionInfo)) {
                Console.error("Connection to " + this.myAddress + " refused. Maximum number of connections has exceeded.");
            } else {
                Console.error("Connection to " + this.myAddress + " refused. Connection already exists.");
            }
            this.myConnectionInfo.setReserved(true);
            ToolBase.this.myConnectionOk = false;
            ToolBase.this.myConnectTimeouted = false;
            ConnectionListener connectionListener = this;
            synchronized (connectionListener) {
                ((Object)((Object)this)).notify();
            }
        }

        public boolean btsRequestUnsecureConnection() {
            return true;
        }
    }

    static enum FSMType {
        REL2,
        REL3;

    }

    class FTPFileThread
    extends Thread {
        private File returnFile;

        FTPFileThread() {
        }

        public File getReturnFile() {
            return this.returnFile;
        }

        public void setReturnFile(File returnFile) {
            this.returnFile = returnFile;
        }
    }

    private final class LoginThread
    extends Thread {
        private final AuthenticationManager authenticationManager;
        private final ConnectionInformation connectionInformation;
        private final String username;
        private final boolean required;
        private final AuthenticationListener authenticationListener;
        private final String btsAddress;
        private final Map<String, String> credentials;
        private final String password;
        private final ConnectionInfoListener connectionInfoListener;
        private final Iterator<String> iterator;

        private LoginThread(AuthenticationManager authenticationManager, ConnectionInformation connectionInformation, String username, boolean required, AuthenticationListener authenticationListener, String btsAddress, Map<String, String> credentials, String password, ConnectionInfoListener connectionInfoListener, Iterator<String> iterator) {
            this.authenticationManager = authenticationManager;
            this.connectionInformation = connectionInformation;
            this.username = username;
            this.required = required;
            this.authenticationListener = authenticationListener;
            this.btsAddress = btsAddress;
            this.credentials = credentials;
            this.password = password;
            this.connectionInfoListener = connectionInfoListener;
            this.iterator = iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConnectionInfoListener connectionInfoListener = this.connectionInfoListener;
            synchronized (connectionInfoListener) {
                if (!ToolBase.this.myConnectionOk) {
                    return;
                }
                ToolBase.this.myUsername = this.username;
                ToolBase.this.myPassword = this.password;
                if ((ToolBase.this.myUsername.length() < 1 || ToolBase.this.myPassword.length() < 1) && this.iterator.hasNext()) {
                    ToolBase.this.myUsername = this.iterator.next();
                    ToolBase.this.myPassword = this.credentials.get(ToolBase.this.myUsername);
                }
                if (this.required) {
                    if (ToolBase.this.myUsername.length() > 0 && ToolBase.this.myPassword.length() > 0) {
                        AuthenticationListener authenticationListener = this.authenticationListener;
                        synchronized (authenticationListener) {
                            ToolBase.this.myLoginTimeouted = true;
                            boolean needReadonlyConnection = false;
                            if (ToolBase.this.isSupportReadonlyConnection(this.connectionInformation)) {
                                needReadonlyConnection = ToolBase.CONNECTION_TYPE_READONLY.equals(ToolBase.this.myConnectionType);
                                this.authenticationManager.logIn(this.authenticationListener, ToolBase.this.myUsername, ToolBase.this.myPassword.toCharArray(), needReadonlyConnection);
                            } else {
                                this.authenticationManager.logIn(this.authenticationListener, ToolBase.this.myUsername, ToolBase.this.myPassword.toCharArray());
                            }
                            try {
                                this.authenticationListener.wait(ToolBase.this.myConnectTimeout);
                            }
                            catch (Exception e) {
                                Console.error("Authentication error to " + this.btsAddress, e);
                            }
                            if (ToolBase.this.myLoginTimeouted) {
                                ToolBase.this.myLoginOk = false;
                            }
                            if (ToolBase.this.myLoginOk) {
                                this.checkLoginConnType(needReadonlyConnection);
                                this.checkPwdExpiredWarning();
                            }
                        }
                    }
                    ToolBase.this.myLoginOk = false;
                }
                ToolBase.this.myConnectTimeouted = false;
                this.connectionInfoListener.notify();
            }
        }

        protected void checkLoginConnType(boolean needReadonlyConnection) {
            LoginUserProfile userProfile = this.authenticationManager.getUserProfile();
            if (userProfile != null) {
                if (userProfile.isReadOnly() && !needReadonlyConnection) {
                    ToolBase.this.myLoginOk = false;
                    Console.error("Create write connection failed to " + this.btsAddress);
                } else if (userProfile != null && userProfile.isReadOnly()) {
                    Console.info("Create read-only connection to " + this.btsAddress);
                } else {
                    Console.info("Create write connection to " + this.btsAddress);
                }
            }
        }

        protected void checkPwdExpiredWarning() {
            LoginUserProfile userProfile = this.authenticationManager.getUserProfile();
            if (userProfile != null) {
                int dayToExpiry = ToolBase.this.getDaysToPasswordExpiry(userProfile);
                int graceLogin = ToolBase.this.getGraceLoginLeft(userProfile);
                String addressString = String.valueOf(this.btsAddress) + ": ";
                if (userProfile.isLocalAccountNonSSO() && dayToExpiry != -1) {
                    Console.warn(String.valueOf(addressString) + MessageFormat.format("Your password will expire in {0} days.", dayToExpiry));
                }
                if (userProfile.isLocalAccountSSO() && dayToExpiry != -1) {
                    Console.warn(String.valueOf(addressString) + MessageFormat.format("Your password will expire in {0} days. Please contact your network administrator to get the password changed.", dayToExpiry));
                }
                if (userProfile.isCentralizedAccount()) {
                    if (dayToExpiry == -1) {
                        if (graceLogin != -1) {
                            Console.warn(String.valueOf(addressString) + MessageFormat.format("Your password has expired and you have {0} grace logins left. Please contact your network administrator to get the password changed.", graceLogin));
                        }
                    } else {
                        Console.warn(String.valueOf(addressString) + MessageFormat.format("Your password will expire in {0} days. Please contact your network administrator to get the password changed.", dayToExpiry));
                    }
                }
            }
        }
    }
}

