/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.BatchOperationResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.TextFormattingUtils;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class ToolImpl {
    protected static final String OK = "OK";
    protected static final String NOK = "Not OK";
    protected static final String FAILED = "Failed";
    protected static final String SUCCESSFUL = "Successful";
    private static final String COLUMN_B = "B";
    private static final String COLUMN_A = "A";
    protected static final String UNREACHABLE = "Unreachable";
    protected static final String LOGIN_FAILED = "Login failed";
    protected static final String RESERVED = "Reserved";
    protected static final String CONNECTED = "Connected";
    protected static final String TOTAL_SITES = "Total sites";
    protected static final String DURATION = "Duration";
    protected static final String ENDED = "Ended";
    protected static final String STARTED = "Started";
    protected static final String ARG_IPFILE = "ipfile";
    protected static final String ARG_NE = "ne";
    protected static final String ARG_CONCURRENT = "concurrent";
    protected static final String ARG_OUTDIR = "outdir";
    private static final String ARG_ATTEMPTS = "attempts";
    private static final String ARG_NOSUMMARY = "nosummary";
    protected int mySuccessCount = 0;
    protected int myOngoing = 0;
    protected int myCount = 0;
    protected int myTotalCount;
    protected int myMaxConcurrentSites = 10;
    protected int myConnectedCount = 0;
    protected int myLoginFailedCount = 0;
    protected int myReservedCount = 0;
    protected Date myStartTime;
    protected Date myEndTime;
    protected static final String LF = System.getProperty("line.separator");
    protected static final String FS = System.getProperty("file.separator");
    protected static final String TAB = "\t";
    private static final String SUMMARY = "_Summary_";
    protected static final String SUMMARY_FILE_EXTENSION = ".txt";
    protected static final String COLUMN_STATUS = "Site Status";
    protected static final String COLUMN_SITE = "Site";
    private static final long BYTES_TO_MEGAS = 0x100000L;
    protected static final SimpleDateFormat SUMMARY_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    protected boolean myVerbose = false;
    protected int myTimeout = 60000;
    protected String myOutDir = null;
    protected List<ToolBase> mySingletools = new ArrayList<ToolBase>();
    private int myMaxRetryCount = 3;
    private int myExitCode = 0;
    private Object lock = new Object();
    private Object lock2 = new Object();

    public ToolImpl(String outdir) {
        this.myOutDir = outdir;
    }

    public abstract String getName();

    public abstract String getVersion();

    public abstract String getFilePrefix();

    public abstract String getResults();

    public abstract String getShortResult();

    protected abstract ToolBase getNewSingleTool();

    protected abstract void updateResults(OperationResult var1);

    protected List<BTSInformation> getAddressesFrom(PCmdLineParams args) {
        String ne = args.getFirstValue(ARG_NE);
        String ipfile = args.getFirstValue(ARG_IPFILE);
        if (ne != null) {
            ArrayList<BTSInformation> l = new ArrayList<BTSInformation>();
            l.add(new BTSInformation(ne, "", ""));
            return l;
        }
        if (ipfile != null) {
            try {
                return this.readIPAddresses(ipfile);
            }
            catch (Exception e) {
                Console.error("Cannot read IP address file " + ipfile + ": " + e.getMessage(), e);
            }
        } else {
            Console.error("No IP address or address file given");
            this.myExitCode = 3;
        }
        return new ArrayList<BTSInformation>();
    }

    protected void parseCommonParamsFrom(PCmdLineParams args) {
        String attempts;
        this.myOutDir = args.getFirstValue(ARG_OUTDIR);
        String concurrent = args.getFirstValue(ARG_CONCURRENT);
        if (concurrent != null) {
            this.myMaxConcurrentSites = Integer.parseInt(concurrent);
        }
        if ((attempts = args.getFirstValue(ARG_ATTEMPTS)) != null) {
            this.myMaxRetryCount = Integer.parseInt(attempts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult execute(final ConnectionInformation connectionInfo, final PCmdLineParams args) {
        String prefix;
        boolean isLaunchedFromBatch;
        this.parseCommonParamsFrom(args);
        Console.info(String.valueOf(this.getName()) + " Tool version " + this.getVersion());
        List<Object> btsInformations = new ArrayList<BTSInformation>();
        boolean bl = isLaunchedFromBatch = connectionInfo != null;
        if (isLaunchedFromBatch) {
            btsInformations.add(new BTSInformation(connectionInfo.getAddress(), connectionInfo.getUsername(), connectionInfo.getPassword()));
        } else {
            btsInformations = this.getAddressesFrom(args);
        }
        this.myTotalCount = this.myCount = btsInformations.size();
        this.myStartTime = new Date();
        while (this.myCount > 0) {
            for (final BTSInformation bTSInformation : btsInformations) {
                while (this.myCount > 0 && (this.myOngoing > this.myMaxConcurrentSites - 1 || this.myOngoing == this.myCount)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Logger.getLogger(this.getClass()).debug((Object)("myCount: " + this.myCount + " myOnging: " + this.myOngoing + " address: " + bTSInformation.getBTSAddress()));
                Logger.getLogger(this.getClass()).debug((Object)("Memory consumption: " + Runtime.getRuntime().totalMemory() / 0x100000L + "MB"));
                if (bTSInformation == null || bTSInformation.getRetryCount() >= this.myMaxRetryCount || bTSInformation.isOngoing()) continue;
                Object object = this.lock;
                synchronized (object) {
                    ++this.myOngoing;
                    this.lock.notifyAll();
                }
                bTSInformation.setOngoing(true);
                bTSInformation.setRetryCount(bTSInformation.getRetryCount() + 1);
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object;
                        block23: {
                            ToolBase tool = null;
                            String address = bTSInformation.getBTSAddress();
                            try {
                                object = ToolImpl.this.mySingletools;
                                synchronized (object) {
                                    for (ToolBase t : ToolImpl.this.mySingletools) {
                                        if (t.isOngoing()) continue;
                                        tool = t;
                                    }
                                    if (tool == null) {
                                        tool = ToolImpl.this.getNewSingleTool();
                                        ToolImpl.this.mySingletools.add(tool);
                                    } else {
                                        tool.setOngoing(true);
                                    }
                                }
                                Logger.getLogger(this.getClass()).debug((Object)("Tool run begin for address: " + bTSInformation.getBTSAddress()));
                                OperationResult result = tool.run(connectionInfo, bTSInformation, args);
                                Logger.getLogger(this.getClass()).debug((Object)("Tool run end for address: " + bTSInformation.getBTSAddress()));
                                tool.setOngoing(false);
                                tool.reset();
                                if (result.isConnected() && result.isLoggedIn()) {
                                    bTSInformation.setRetryCount(ToolImpl.this.myMaxRetryCount);
                                    ++ToolImpl.this.myConnectedCount;
                                    this.processResults(result);
                                } else if (bTSInformation.getRetryCount() >= ToolImpl.this.myMaxRetryCount) {
                                    if (result.isReserved()) {
                                        ++ToolImpl.this.myReservedCount;
                                    } else if (!result.isLoggedIn()) {
                                        ++ToolImpl.this.myLoginFailedCount;
                                    }
                                    this.processResults(result);
                                } else if (!result.isLoggedIn()) {
                                    bTSInformation.setRetryCount(ToolImpl.this.myMaxRetryCount);
                                    ++ToolImpl.this.myLoginFailedCount;
                                    this.processResults(result);
                                }
                            }
                            catch (Exception e) {
                                tool.setOngoing(false);
                                tool.disconnect(connectionInfo, true);
                                tool.reset();
                                Console.error("Unexpected error during a connection to " + address, e);
                                if (bTSInformation.getRetryCount() < ToolImpl.this.myMaxRetryCount) break block23;
                                ToolImpl.this.myExitCode = ToolImpl.this.determineExitCode(7);
                            }
                        }
                        object = ToolImpl.this.lock;
                        synchronized (object) {
                            --ToolImpl.this.myOngoing;
                            ToolImpl.this.lock.notifyAll();
                        }
                        bTSInformation.setOngoing(false);
                        if (bTSInformation.getRetryCount() >= ToolImpl.this.myMaxRetryCount) {
                            object = ToolImpl.this.lock2;
                            synchronized (object) {
                                --ToolImpl.this.myCount;
                                ToolImpl.this.lock2.notifyAll();
                            }
                        }
                    }

                    private void processResults(OperationResult result) {
                        ToolImpl.this.updateResults(result);
                        if (result.getExitCode() != 0) {
                            ToolImpl.this.myExitCode = ToolImpl.this.determineExitCode(result.getExitCode());
                        }
                    }
                }.start();
            }
        }
        while (this.myOngoing > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myEndTime = new Date();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTarget(isLaunchedFromBatch, args.getFirstValue(ARG_IPFILE), btsInformations)).append(LF).append(LF);
        stringBuilder.append(this.getTimes()).append(LF).append(LF);
        stringBuilder.append(this.getCounts()).append(LF).append(LF);
        stringBuilder.append(this.getResults());
        String string = prefix = isLaunchedFromBatch ? String.valueOf(((BTSInformation)btsInformations.get(0)).getBTSAddress()) + "_" : "";
        if (!args.isDefined(ARG_NOSUMMARY)) {
            this.writeSummaryFile(prefix, stringBuilder.toString());
        }
        Console.info(this.getToolFinishedText());
        return new BatchOperationResult(this.getShortResult(), this.myExitCode);
    }

    private int determineExitCode(int code) {
        return this.myTotalCount > 1 ? 1 : code;
    }

    private String getToolFinishedText() {
        return String.valueOf(this.getName()) + " Tool finished" + (this.myExitCode == 0 ? "" : " with error code " + this.myExitCode);
    }

    private String getTarget(boolean isLaunchedFromBatch, String ipFileName, List<BTSInformation> btsInformations) {
        if (isLaunchedFromBatch || ipFileName == null) {
            if (btsInformations.size() > 0) {
                return "IP address: " + btsInformations.get(0).getBTSAddress();
            }
            return "Unknown address";
        }
        return "IP filename: " + ipFileName;
    }

    private String getCounts() {
        ToolSummaryTable t = new ToolSummaryTable(false);
        t.addColumn(COLUMN_A, TOTAL_SITES, CONNECTED, RESERVED, LOGIN_FAILED, UNREACHABLE);
        t.addColumn(COLUMN_B, String.valueOf(this.myTotalCount), String.valueOf(this.myConnectedCount), String.valueOf(this.myReservedCount), String.valueOf(this.myLoginFailedCount), String.valueOf(this.myTotalCount - this.myConnectedCount - this.myLoginFailedCount - this.myReservedCount));
        return t.toString();
    }

    private String getTimes() {
        ToolSummaryTable t = new ToolSummaryTable(false);
        t.addColumn(COLUMN_A, STARTED, ENDED, DURATION);
        t.addColumn(COLUMN_B, TextFormattingUtils.applyLongTimeZoneFormat(this.myStartTime), TextFormattingUtils.applyLongTimeZoneFormat(this.myEndTime), TextFormattingUtils.formatExecutionTime(this.myEndTime.getTime() - this.myStartTime.getTime()));
        return t.toString();
    }

    private void writeSummaryFile(String prefix, String summary) {
        BufferedWriter out = null;
        try {
            try {
                String dir = this.getOutDir();
                if (dir.length() == 0 || new File(dir).exists() || new File(dir).mkdirs()) {
                    out = new BufferedWriter(new FileWriter(new File(String.valueOf(dir) + prefix + this.getFilePrefix() + SUMMARY + SUMMARY_DATE_FORMAT.format(new Date()) + SUMMARY_FILE_EXTENSION), false));
                    out.write(summary);
                }
            }
            catch (Exception e) {
                Console.error("Failed to create results file", e);
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected String getOutDir() {
        return this.myOutDir != null ? String.valueOf(this.myOutDir) + FS : "";
    }

    protected String getStatusText(OperationResult result) {
        String status = UNREACHABLE;
        if (result.isConnected()) {
            status = result.getOperationalState();
        } else if (!result.isLoggedIn()) {
            status = LOGIN_FAILED;
        } else if (result.isReserved()) {
            status = RESERVED;
        }
        return status;
    }

    private List<BTSInformation> readIPAddresses(String ipFile) throws IOException {
        String inputLine;
        ArrayList<BTSInformation> btsInformations = new ArrayList<BTSInformation>();
        BufferedReader reader = new BufferedReader(new FileReader(ipFile));
        while ((inputLine = reader.readLine()) != null) {
            if ((inputLine = inputLine.trim()).length() <= 0 || inputLine.startsWith("#")) continue;
            String userName = "";
            String password = "";
            StringTokenizer tokenizer = new StringTokenizer(inputLine, " ");
            String address = tokenizer.nextToken();
            if (tokenizer.hasMoreElements()) {
                userName = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                password = tokenizer.nextToken();
            }
            btsInformations.add(new BTSInformation(address, userName, password));
        }
        reader.close();
        return btsInformations;
    }

    public static List<String> parseTxtConfigFile(String configFile) throws IOException {
        String inputLine;
        ArrayList<String> rows = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(configFile));
        while ((inputLine = reader.readLine()) != null) {
            if ((inputLine = inputLine.trim()).length() <= 0 || inputLine.startsWith("#")) continue;
            rows.add(inputLine);
        }
        reader.close();
        return rows;
    }

    protected void saveFile(String filename, String content) throws IOException {
        String dir = this.getOutDir();
        if (dir.length() == 0 || new File(dir).exists() || new File(dir).mkdirs()) {
            BufferedWriter out = new BufferedWriter(new FileWriter(new File(String.valueOf(dir) + filename), false));
            out.write(content);
            out.close();
        }
    }
}

