/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.GetSiteResult;
import com.nokia.em.bts.coreasset.application.tools.GetSiteSingle;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import com.nokia.em.bts.coreasset.configuration.Link;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.Unit;

public class TransmissionStatusImpl
extends ToolImpl {
    private static final String UNKNOWN = "Unknown";
    static final String STATUS_CONNECTED = "Connected";
    static final String STATUS_DISCONNECTED = "Disconnected";
    private static final String COLUMN_OAM_STATE = "Link Status";
    private ToolSummaryTable mySummaryTable = new ToolSummaryTable("Site", "Site Status", "Link Status");

    public TransmissionStatusImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return COLUMN_OAM_STATE;
    }

    @Override
    public String getVersion() {
        return "2.0";
    }

    @Override
    public String getFilePrefix() {
        return "CheckLinkStatus";
    }

    @Override
    public String getResults() {
        return this.mySummaryTable.toString();
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new GetSiteSingle();
    }

    @Override
    protected void updateResults(OperationResult result) {
        GetSiteResult siteResult = (GetSiteResult)result;
        if (siteResult.getSite() == null) {
            result.setExitCode(46);
        }
        this.mySummaryTable.addRow(siteResult.getAddress(), this.getStatusText(siteResult), this.getOAMState(siteResult.getSite()));
        String oamState = this.getOAMState(siteResult.getSite());
        if (!oamState.equalsIgnoreCase(UNKNOWN)) {
            Console.info("Successfully got link status (" + oamState + ") from " + result.getAddress());
        } else {
            Console.info("Failed to get link status from " + result.getAddress());
            result.setExitCode(47);
        }
    }

    @Override
    public String getShortResult() {
        if (this.mySummaryTable.getRowCount() <= 0) {
            return UNKNOWN;
        }
        return this.mySummaryTable.getValueAt(0, 2).toString();
    }

    private String getOAMState(Site site) {
        boolean commissioned;
        Link oamLink = this.getOAMLink(site);
        if (oamLink == null) {
            return UNKNOWN;
        }
        String linkStatus = oamLink.isLinkConnected() ? STATUS_CONNECTED : STATUS_DISCONNECTED;
        int btsState = site.getOperationalState();
        boolean bl = commissioned = btsState != 37;
        if (commissioned) {
            return linkStatus;
        }
        String state = site.getCustomAttributeValue("AutoconnectionState");
        if ("Connecting".equals(state)) {
            linkStatus = "Connecting";
        } else if (STATUS_DISCONNECTED.equals(state)) {
            linkStatus = STATUS_DISCONNECTED;
        } else if ("Completed".equals(state)) {
            linkStatus = STATUS_CONNECTED;
        } else if ("Registered".equals(state)) {
            linkStatus = String.valueOf(linkStatus) + " - Registered";
        } else if ("Rejected".equals(state)) {
            linkStatus = String.valueOf(linkStatus) + " - No autoconnection";
        } else if ("Registered-NOK".equals(state)) {
            linkStatus = String.valueOf(linkStatus) + " - Registration failure";
        }
        return linkStatus;
    }

    private Link getOAMLink(Site site) {
        if (site == null) {
            return null;
        }
        for (Unit unit : site.getCabinet().getUnits()) {
            if (!this.isMasterSystemModule(unit) && !"CORE_FSM".equalsIgnoreCase(unit.getUnitType())) continue;
            for (Link link : unit.getLinks()) {
                if (!"OAM".equalsIgnoreCase(link.getLinkType())) continue;
                return link;
            }
        }
        return null;
    }

    private boolean isMasterSystemModule(Unit unit) {
        return unit.getUnitType().equals("FSM") && !unit.getUnitName().equals("FSMX") && !"Extension".equalsIgnoreCase(unit.getCustomAttributeValue("FSM.Mode"));
    }
}

