/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.message.BlockOperationsCompleted;
import com.nokia.em.bts.coreasset.message.ChangeObjectBlockingStateRequest;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.poseidon.util.PCmdLineParams;

public class UnblockSingle
extends ToolBase {
    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        this.myTimeout = 120000;
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        String address = btsInformation.getBTSAddress();
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(address, btsInformation.getUserName(), btsInformation.getPassword(), this.getCredentialsFrom(args));
            disconnect = true;
        }
        OperationResult result = new OperationResult();
        if (connectionInfo.isConnected()) {
            BTSConnection connection = connectionInfo.getConnection();
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connection);
            }
            result.setOperationalState(this.getOperationalStateText(site));
            result.setAddress(connectionInfo.getAddress());
            try {
                int id = site.getId();
                if (this.unblockSite(connection, id)) {
                    Console.info("Successfully unblocked " + address);
                } else {
                    Console.error("Failed to unblock " + address);
                    result.setOK(false);
                    result.setExitCode(69);
                }
            }
            catch (Exception e) {
                Console.error("Failed to unblock " + address);
                result.setOK(false);
                result.setExitCode(69);
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private boolean unblockSite(BTSConnection c, int siteId) {
        int seqNumber = c.createScenario();
        ChangeObjectBlockingStateRequest request = new ChangeObjectBlockingStateRequest(seqNumber, siteId, 7, 13);
        c.sendToBTS((BTSMessage)request);
        BTSMessage response = c.receiveFromBTS(seqNumber, (long)this.myTimeout);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            if (!ackResponse.getAck()) {
                c.deleteScenario(seqNumber);
                return false;
            }
            response = c.receiveFromBTS(seqNumber, (long)this.myTimeout);
            c.deleteScenario(seqNumber);
            if (response instanceof BlockOperationsCompleted) {
                return ((BlockOperationsCompleted)response).getSuccessCode() == 36;
            }
            if (response == null) {
                return true;
            }
        }
        c.deleteScenario(seqNumber);
        return false;
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }
}

