/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ResetUnitSingle;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.util.ArrayList;
import java.util.List;

public class UnblockUnitImpl
extends ToolImpl {
    private static final String COLUMN_RESET = "Unit Unblocked";
    private List<OperationResult> myResults = new ArrayList<OperationResult>();

    public UnblockUnitImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return "Unblock Unit";
    }

    @Override
    public String getVersion() {
        return "5.0";
    }

    @Override
    public String getFilePrefix() {
        return "UnblockUnit";
    }

    @Override
    public String getShortResult() {
        if (this.myResults.size() > 0) {
            return this.myResults.get(0).isOK() ? "OK" : "Not OK";
        }
        return "No results";
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new ResetUnitSingle(ResetUnitSingle.Operation.UNBLOCK);
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add(result);
    }

    @Override
    public String getResults() {
        ToolSummaryTable table = new ToolSummaryTable();
        this.generateColumnsTo(table);
        this.generateRowsTo(table);
        return table.toString();
    }

    private void generateColumnsTo(ToolSummaryTable table) {
        table.addColumn("Site");
        table.addColumn("Site Status");
        table.addColumn(COLUMN_RESET);
    }

    private void generateRowsTo(ToolSummaryTable table) {
        for (OperationResult results : this.myResults) {
            this.generateRow(table, results);
        }
    }

    private void generateRow(ToolSummaryTable table, OperationResult results) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(results.getAddress());
        if (results.isConnected()) {
            this.insertToolResults(values, results);
        } else if (!results.isLoggedIn()) {
            values.add("Login failed");
        } else if (results.isReserved()) {
            values.add("Reserved");
        } else {
            values.add("Unreachable");
        }
        table.addRow(values);
    }

    private void insertToolResults(List<String> values, OperationResult results) {
        values.add(results.getOperationalState());
        values.add(results.isOK() ? "OK" : "Not OK");
    }
}

