/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.util;

import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.RP3LinkModel;
import com.nokia.em.bts.coreasset.configuration.Cabinet;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.Unit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class HwModelUtil {
    public static final String SITECONF_PROPERTIES_CONNECTIONLIST = "connectionList";
    public static final String SITECONF_PROPERTIES_DETECTEDCONNECTIONLIST = "DetectedConnectionList";
    private static final String SITECONF_PROPERTIES_LINKMASTERID = "LinkMasterID";
    private static final String SITECONF_PROPERTIES_LINKMASTERRP3INTERFACE = "LinkMasterRP3Interface";
    private static final String SITECONF_PROPERTIES_POSITIONINCHAIN = "PositionInChain";
    public static final String SITECONF_PROPERTIES_LOGICAL_ID = "_logicalId";

    public static Unit findUnitByRP3LinkModelNewThanLN70(Site site, String targetUnitType, RP3LinkModel targetRP3LinkModel) {
        for (Unit u : site.getCabinet().getUnits()) {
            String connectionList;
            List<RP3LinkModel> rp3LinkModels;
            if (!targetUnitType.equalsIgnoreCase(u.getUnitType()) && !targetUnitType.equalsIgnoreCase(u.getUnitName()) && !targetUnitType.equalsIgnoreCase(String.valueOf(u.getUnitType()) + u.getVariant()) || !targetRP3LinkModel.isSamePosition((rp3LinkModels = HwModelUtil.parseConnectionList(connectionList = u.getCommissionedStatus() != false ? u.getCustomAttributeValue(SITECONF_PROPERTIES_CONNECTIONLIST) : u.getCustomAttributeValue(SITECONF_PROPERTIES_DETECTEDCONNECTIONLIST))).get(0))) continue;
            return u;
        }
        return null;
    }

    public static Unit findUnitByRP3LinkModelOlderThanLN70(Site site, String targetUnitType, RP3LinkModel targetRP3LinkModel) {
        for (Unit u : site.getCabinet().getUnits()) {
            if (!targetUnitType.equalsIgnoreCase(u.getUnitType()) && !targetUnitType.equalsIgnoreCase(u.getUnitName()) && !targetUnitType.equalsIgnoreCase(String.valueOf(u.getUnitType()) + u.getVariant())) continue;
            int LinkMasterNumber = 0;
            int LinkMasterRP3Interface = 0;
            int PositionInChain = 0;
            try {
                LinkMasterNumber = HwModelUtil.generateLinkMasterNumber(site, Integer.parseInt(u.getCustomAttributeValue(SITECONF_PROPERTIES_LINKMASTERID)));
                LinkMasterRP3Interface = Integer.parseInt(u.getCustomAttributeValue(SITECONF_PROPERTIES_LINKMASTERRP3INTERFACE));
                PositionInChain = Integer.parseInt(u.getCustomAttributeValue(SITECONF_PROPERTIES_POSITIONINCHAIN));
            }
            catch (Exception e) {
                String logicId = u.getCustomAttributeValue(SITECONF_PROPERTIES_LOGICAL_ID);
                logicId = logicId.replaceAll("[a-z]|[A-Z]", "");
                String[] logicIdSegments = logicId.split("_");
                LinkMasterNumber = Integer.parseInt(logicIdSegments[0]);
                LinkMasterRP3Interface = u.getNumber();
                PositionInChain = Integer.parseInt(logicIdSegments[2]);
            }
            StringBuilder fakeConnectionList = new StringBuilder();
            fakeConnectionList.append(LinkMasterNumber);
            fakeConnectionList.append(".");
            fakeConnectionList.append(LinkMasterRP3Interface);
            fakeConnectionList.append(".");
            fakeConnectionList.append(PositionInChain);
            RP3LinkModel rp3LinkModel = HwModelUtil.generateRP3LinkModel(fakeConnectionList.toString());
            if (!targetRP3LinkModel.isSamePosition(rp3LinkModel)) continue;
            return u;
        }
        return null;
    }

    public static RP3LinkModel generateRP3LinkModel(String conectionList) {
        RP3LinkModel rp3LinkModel = null;
        try {
            String[] rp3ModelInfos = conectionList.split("\\.");
            rp3LinkModel = rp3ModelInfos.length == 3 ? new RP3LinkModel(Integer.valueOf(rp3ModelInfos[0]), 0, Integer.valueOf(rp3ModelInfos[1]), Integer.valueOf(rp3ModelInfos[2])) : new RP3LinkModel(Integer.valueOf(rp3ModelInfos[0]), Integer.valueOf(rp3ModelInfos[1]), Integer.valueOf(rp3ModelInfos[2]), Integer.valueOf(rp3ModelInfos[3]));
        }
        catch (Exception e) {
            Console.error("Exception occurred when parsing the connectionlist " + conectionList);
        }
        return rp3LinkModel;
    }

    public static int generateLinkMasterNumber(Site site, int linkMasterId) {
        for (Unit u : site.getCabinet().getUnits()) {
            String unitType = u.getUnitType();
            if (!"FSM".equals(unitType) && !"ESM".equals(unitType) || u.getId() != linkMasterId) continue;
            return u.getNumber();
        }
        return 1;
    }

    public static List<RP3LinkModel> parseConnectionList(String connectionList) {
        String[] connectionlistInfos;
        ArrayList<RP3LinkModel> rp3LinkModels = new ArrayList<RP3LinkModel>();
        String[] stringArray = connectionlistInfos = connectionList.split(";");
        int n = connectionlistInfos.length;
        int n2 = 0;
        while (n2 < n) {
            String connectionlistInfo = stringArray[n2];
            RP3LinkModel tmpRP3LinkModel = HwModelUtil.generateRP3LinkModel(connectionlistInfo);
            if (tmpRP3LinkModel != null) {
                rp3LinkModels.add(tmpRP3LinkModel);
            }
            ++n2;
        }
        Collections.sort(rp3LinkModels);
        return rp3LinkModels;
    }

    public static boolean hasRel4IndoorBBModel(Cabinet cabinet) {
        for (Unit u : cabinet.getUnits()) {
            if (!"FSM".equals(u.getUnitType()) || !HwModelUtil.isRelease4Unit(u) || !HwModelUtil.isIndoorUnit(u) || HwModelUtil.isSingleBoxUnit(u)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIndoorUnit(Unit u) {
        return "TRUE".equalsIgnoreCase(u.getCustomAttributeValue("FSM.Indoor"));
    }

    public static boolean isRelease4Unit(Unit u) {
        return "4".equals(u.getCustomAttributeValue("HW.Release"));
    }

    public static boolean isRelease3Unit(Unit u) {
        return "3".equals(u.getCustomAttributeValue("HW.Release"));
    }

    public static boolean isSingleBoxUnit(Unit u) {
        return "TRUE".equalsIgnoreCase(u.getCustomAttributeValue("Single.Box.Unit"));
    }

    public static boolean isRel3OutdoorUnit(Unit bbModel) {
        return HwModelUtil.isRelease3Unit(bbModel) && !HwModelUtil.isIndoorUnit(bbModel);
    }

    public static boolean isPluginUnit(Unit fsp) {
        return "TRUE".equalsIgnoreCase(fsp.getCustomAttributeValue("Plug.In.Unit"));
    }

    public static int getFspSmodId(Unit fsp) {
        String smodId = fsp.getCommissionedStatus() != false ? fsp.getCustomAttributeValue("sModId") : fsp.getCustomAttributeValue("DetectedSmodId");
        return smodId != null ? Integer.parseInt(smodId) : 1;
    }

    public static int getFspNumber(Unit fsp) {
        String number = fsp.getCommissionedStatus() != false ? fsp.getCustomAttributeValue("sModPort") : fsp.getCustomAttributeValue("DetectedSmodPort");
        return number != null ? Integer.parseInt(number) : 1;
    }

    public static boolean isAnotherTechnology(Unit bbUnit) {
        return "false".equalsIgnoreCase(bbUnit.getCustomAttributeValue("ownedByThisBts")) || "2G".equalsIgnoreCase(HwModelUtil.getValidUnitName(bbUnit)) || "3G".equalsIgnoreCase(HwModelUtil.getValidUnitName(bbUnit)) || "LTE".equalsIgnoreCase(HwModelUtil.getValidUnitName(bbUnit));
    }

    public static String getValidUnitName(Unit bbUnit) {
        if (bbUnit.getUnitName() != null && !bbUnit.getUnitName().trim().isEmpty() && !"Coreasset_Unknown".equals(bbUnit.getUnitName())) {
            return bbUnit.getUnitName();
        }
        String varient = "";
        if (bbUnit.getVariant() != null && !bbUnit.getVariant().trim().isEmpty() && !"Coreasset_Unknown".equals(bbUnit.getVariant())) {
            varient = bbUnit.getVariant();
        }
        return String.valueOf(bbUnit.getUnitType()) + varient;
    }

    public static boolean isRadioModuleUnit(Unit unit) {
        return "FR".equals(unit.getUnitType());
    }

    public static boolean isFSPModule(Unit u) {
        return "FSP".equals(u.getUnitType());
    }

    public static Unit getBBModel(Cabinet cabinet, int linkMasterId) {
        for (Unit u : cabinet.getUnits()) {
            if (u.getUnitId() != linkMasterId) continue;
            return u;
        }
        return null;
    }

    public static Unit getMasterBBModel(Cabinet cabinet) {
        List<Unit> bbList = HwModelUtil.getAllBBModelUnits(cabinet);
        if (bbList.size() == 1) {
            return bbList.get(0);
        }
        for (Unit u : bbList) {
            if (!"Master".equals(u.getCustomAttributeValue("FSM.Mode"))) continue;
            return u;
        }
        return null;
    }

    public static List<Unit> getAllFSP(Cabinet cabinet) {
        ArrayList<Unit> list = new ArrayList<Unit>();
        for (Unit u : cabinet.getUnits()) {
            if (!"FSP".equals(u.getUnitType())) continue;
            list.add(u);
        }
        return list;
    }

    public static List<Unit> getAllBBModelUnits(Cabinet cabinet) {
        ArrayList<Unit> smLists = new ArrayList<Unit>();
        for (Unit u : cabinet.getUnits()) {
            if (!HwModelUtil.isSystemModule(u)) continue;
            smLists.add(u);
        }
        return smLists;
    }

    public static boolean isSystemModule(Unit u) {
        return "FSM".equals(u.getUnitType());
    }
}

