/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.util;

import com.nokia.em.bts.coreasset.application.util.JSONRPCError;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class JSONRPCObject
extends JSONObject {
    private static final String VERSION = "2.0";
    private static final String RESULT = "result";
    private static final String ID = "id";
    private static final String METHOD = "method";
    private static final String PARAMS = "params";
    private static final String JSONRPC = "jsonrpc";
    private static final String ERROR = "error";

    public JSONRPCObject() {
        this.put(JSONRPC, VERSION);
        this.put(ID, null);
    }

    public JSONRPCObject(String received) {
        super(received);
    }

    public void setResult(Object result) {
        this.put(RESULT, result);
    }

    public Object getResult() {
        return this.get(RESULT);
    }

    public void setId(int id) {
        this.put(ID, id);
    }

    public int getId() {
        return this.getInt(ID);
    }

    public void setMethod(String method) {
        this.put(METHOD, method);
    }

    public String getMethod() {
        return this.getString(METHOD);
    }

    public void setError(JSONRPCError error) {
        this.put(ERROR, (Object)error);
    }

    public boolean isOk() {
        return this.getError() == null;
    }

    public JSONRPCError getError() {
        try {
            JSONObject obj = this.getJSONObject(ERROR);
            String code = "0";
            String message = "";
            for (Object o : obj.keySet()) {
                String key = o.toString();
                if ("code".equalsIgnoreCase(key)) {
                    code = obj.get(key).toString();
                    continue;
                }
                if (!"message".equalsIgnoreCase(key)) continue;
                message = obj.get(key).toString();
            }
            return new JSONRPCError(Integer.valueOf(code), message);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setNamedParameters(Map<String, Object> params) {
        this.put(PARAMS, new JSONObject(params));
    }

    public Map<String, Object> getNamedParameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject params = this.getJSONObject(PARAMS);
        for (Object obj : params.keySet()) {
            String key = obj.toString();
            map.put(key, params.get(key));
        }
        return map;
    }
}

