/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.util;

import com.nokia.em.bts.coreasset.application.util.HwModelUtil;
import com.nokia.em.bts.coreasset.application.util.RFModel;
import com.nokia.em.bts.coreasset.application.util.RP3LinkModel;
import com.nokia.em.bts.coreasset.configuration.Unit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

public class LTERFModel
extends RFModel {
    private DetectedLinkComparator detectedLinkComparator = new DetectedLinkComparator();

    public LTERFModel(Unit unit) {
        super(unit);
    }

    @Override
    public Unit getRadioMaster() {
        if (this.isConnectedToFSP()) {
            for (Unit fsp : HwModelUtil.getAllFSP(this.myUnit.getCabinet())) {
                if (!HwModelUtil.isPluginUnit(fsp) || !this.isConnectedToSpecifyFSP(fsp)) continue;
                if ("Coreasset_Unknown".equals(fsp.getCustomAttributeValue("linkList"))) {
                    return null;
                }
                if (!this.isRadioMaster(fsp)) continue;
                return fsp;
            }
        } else if (this.isRadioMaster(HwModelUtil.getMasterBBModel(this.myUnit.getCabinet()))) {
            return HwModelUtil.getMasterBBModel(this.myUnit.getCabinet());
        }
        if (HwModelUtil.getMasterBBModel(this.myUnit.getCabinet()).getCustomAttributeValue("linkList") == null) {
            return null;
        }
        for (Unit u : HwModelUtil.getAllBBModelUnits(this.myUnit.getCabinet())) {
            if (!HwModelUtil.isAnotherTechnology(u) || !"3G".equalsIgnoreCase(HwModelUtil.getValidUnitName(u))) continue;
            return u;
        }
        return null;
    }

    @Override
    public int getlinkIdInterfaceForRadioMaster() {
        if (HwModelUtil.isSingleBoxUnit(HwModelUtil.getMasterBBModel(this.myUnit.getCabinet()))) {
            return this.myUnit.getNumber();
        }
        return this.getSmallestConnectionList().getInterfaceNumber();
    }

    public boolean isConnectedToSpecifyFSP(Unit fspModel) {
        List<RP3LinkModel> connectionList = this.getConnectionList();
        for (RP3LinkModel rp3LinkModel : connectionList) {
            if (rp3LinkModel.getFSPNumber() != HwModelUtil.getFspNumber(fspModel) || rp3LinkModel.getFSMNumber() != HwModelUtil.getFspSmodId(fspModel)) continue;
            return true;
        }
        return false;
    }

    public List<RP3LinkModel> getConnectionList() {
        try {
            if (!this.isCommissioned() && this.myUnit.getCustomAttributeValue("DetectedConnectionList") != null) {
                return this.getDetectedConnectionList();
            }
            if (this.isCommissioned() && this.myUnit.getCustomAttributeValue("connectionList") != null) {
                List<RP3LinkModel> list = HwModelUtil.parseConnectionList(this.myUnit.getCustomAttributeValue("connectionList"));
                Collections.sort(list);
                return list;
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to get connect list", (Throwable)e);
        }
        return new ArrayList<RP3LinkModel>();
    }

    public RP3LinkModel getSmallestConnectionList() {
        try {
            if (!this.isCommissioned() && this.myUnit.getCustomAttributeValue("DetectedConnectionList") != null) {
                return this.getDetectedConnectionList().get(0);
            }
            if (this.isCommissioned() && this.myUnit.getCustomAttributeValue("connectionList") != null) {
                List<RP3LinkModel> list = HwModelUtil.parseConnectionList(this.myUnit.getCustomAttributeValue("connectionList"));
                Collections.sort(list);
                return list.get(0);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to get connect list", (Throwable)e);
        }
        return new RP3LinkModel();
    }

    public boolean isConnectedToFSP() {
        return this.getSmallestConnectionList().getFSPNumber() > 0;
    }

    private List<RP3LinkModel> getDetectedConnectionList() {
        List<RP3LinkModel> list = HwModelUtil.parseConnectionList(this.myUnit.getCustomAttributeValue("DetectedConnectionList"));
        Collections.sort(list);
        if (this.getLinkMaster() != null && HwModelUtil.isRel3OutdoorUnit(this.getLinkMaster())) {
            Collections.sort(list, this.detectedLinkComparator);
        }
        return list;
    }

    @Override
    public Unit getLinkMaster() {
        return HwModelUtil.getBBModel(this.myUnit.getCabinet(), this.getFSMNumber());
    }

    public int getFSMNumber() {
        return HwModelUtil.hasRel4IndoorBBModel(this.myUnit.getCabinet()) ? this.getSmallestConnectionList().getFSMNumber() : 1;
    }

    public boolean isCommissioned() {
        return this.myUnit.getCommissionedStatus() == null ? false : this.myUnit.getCommissionedStatus();
    }

    class DetectedLinkComparator
    implements Comparator<RP3LinkModel> {
        DetectedLinkComparator() {
        }

        @Override
        public int compare(RP3LinkModel o1, RP3LinkModel o2) {
            if (o1.getFSMNumber() == o2.getFSMNumber()) {
                if (o1.getInterfaceNumber() == 6 && o2.getInterfaceNumber() != 6) {
                    return 1;
                }
                if (o2.getInterfaceNumber() == 6 && o1.getInterfaceNumber() != 6) {
                    return -1;
                }
            }
            return o1.getComparableNumber() - o2.getComparableNumber();
        }
    }
}

