/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.fusesource.jansi.AnsiConsole;

public class LogWriter {
    public static final String INFO_TEXT = "  INFO ";
    public static final String WARN_TEXT = "  WARN ";
    public static final String ERROR_TEXT = " ERROR ";
    public static final String DEBUG_TEXT = " DEBUG ";
    public static final String CONSOLE_TEXT = "  USER ";
    private String myFilename;
    private FileWriter myFileWriter;
    private boolean myAppend;
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM HH:mm:ss");
    public static final String BLACK = "\u001b[0;30m";
    public static final String RED = "\u001b[0;31m";
    public static final String GREEN = "\u001b[0;32m";
    public static final String YELLOW = "\u001b[0;33m";
    public static final String BLUE = "\u001b[0;34m";
    public static final String MAGENTA = "\u001b[0;35m";
    public static final String CYAN = "\u001b[0;36m";
    public static final String WHITE = "\u001b[0;37m";

    public LogWriter(String filename, boolean append) {
        this.myFilename = filename;
        this.myAppend = append;
    }

    public synchronized void logError(String errorText) {
        this.log(LEVEL.ERROR, errorText);
    }

    public synchronized void logWarn(String warnText) {
        this.log(LEVEL.WARN, warnText);
    }

    public synchronized void logDebug(String debugText) {
        this.log(LEVEL.DEBUG, debugText);
    }

    public synchronized void logInfo(String infoText) {
        this.log(LEVEL.INFO, infoText);
    }

    private synchronized void log(LEVEL level, String text) {
        this.writeToFile(String.valueOf(DATE_FORMAT.format(new Date())) + this.getFileLevel(level) + text);
        AnsiConsole.out.println(String.valueOf(DATE_FORMAT.format(new Date())) + this.getConsoleLevel(level) + text);
    }

    public synchronized void writeToFile(String line) {
        if (this.myFilename != null && this.myFilename.length() > 0) {
            this.ensureFileExists();
            this.write(line);
        }
    }

    private synchronized void write(String line) {
        if (this.myFileWriter != null) {
            try {
                this.myFileWriter.write(String.valueOf(line) + System.getProperty("line.separator"));
                this.myFileWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void ensureFileExists() {
        if (this.myFileWriter == null) {
            try {
                this.startWriter();
            }
            catch (IOException e) {
                AnsiConsole.out.println(String.valueOf(DATE_FORMAT.format(new Date())) + " " + this.getConsoleLevel(LEVEL.ERROR) + " " + "Cannot create INFO writer: " + e.getMessage());
            }
        }
    }

    private String getConsoleLevel(LEVEL level) {
        switch (level) {
            case INFO: {
                return "\u001b[0;32m  INFO \u001b[0;37m";
            }
            case WARN: {
                return "\u001b[0;33m  WARN \u001b[0;37m";
            }
            case DEBUG: {
                return "\u001b[0;35m DEBUG \u001b[0;37m";
            }
            case ERROR: {
                return "\u001b[0;31m ERROR \u001b[0;37m";
            }
        }
        return "\u001b[0;32m  INFO \u001b[0;37m";
    }

    private String getFileLevel(LEVEL level) {
        switch (level) {
            case INFO: {
                return INFO_TEXT;
            }
            case WARN: {
                return WARN_TEXT;
            }
            case ERROR: {
                return ERROR_TEXT;
            }
        }
        return INFO_TEXT;
    }

    public synchronized void closeWriters() {
        try {
            this.myFileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startWriter() throws IOException {
        this.ensureDirectory();
        this.myFileWriter = new FileWriter(this.myFilename, this.myAppend);
    }

    private void ensureDirectory() {
        File file = new File(this.myFilename);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
    }

    static enum LEVEL {
        INFO,
        WARN,
        ERROR,
        DEBUG;

    }
}

