/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.util;

import java.util.HashMap;
import java.util.Map;

public class Product {
    private TechType myTechType;
    private int myMinorVersion;
    private String myReleaseVersion;
    private Map<String, String> myAdptVersionMap = new HashMap<String, String>();
    public static final String ADAPTATION_NOKLTE = "NOKLTE";
    public static Product LN70 = new Product(TechType.LTEBTS, 60, "LN7.0");
    public static Product LNF70 = new Product(TechType.BTSSC, 20, "LNF7.0");
    public static Product LNT50 = new Product(TechType.TDLTEBTS, 40, "LNT5.0");
    public static Product LNZ50 = new Product(TechType.TDBTSSC, 10, "LNZ5.0");
    public static Product FL15A = new Product(TechType.LTEBTS, 70, "FL15A");
    public static Product FL16 = new Product(TechType.LTEBTS, 80, "FL16");
    public static Product FL16A = new Product(TechType.LTEBTS, 85, "FL16A");
    public static Product TL15A = new Product(TechType.TDLTEBTS, 50, "TL15A");
    public static Product TL16 = new Product(TechType.TDLTEBTS, 60, "TL16");
    public static Product TL16A = new Product(TechType.TDLTEBTS, 65, "TL16A");
    public static Product FLF15A = new Product(TechType.BTSSC, 30, "FLF15A");
    public static Product FLF16 = new Product(TechType.BTSSC, 40, "FLF16");
    public static Product FLF16A = new Product(TechType.BTSSC, 45, "FLF16A");
    public static Product TLF15A = new Product(TechType.TDBTSSC, 20, "TLF15A");
    public static Product TLF16 = new Product(TechType.TDBTSSC, 30, "TLF16");
    public static Product TLF16A = new Product(TechType.TDBTSSC, 35, "TLF16A");
    public static Product FLAP15A = new Product(TechType.FLAPBTS, 0, "FLC15A");
    public static Product FLAP16 = new Product(TechType.FLAPBTS, 10, "FLC16");
    public static Product TLAP15A = new Product(TechType.TLAPBTS, 0, "TLC15A");
    public static Product TLAP16 = new Product(TechType.TLAPBTS, 10, "TLC16");
    public static Product WBTS16 = new Product(TechType.BTS, 70, "WBTS16");
    public static Product WBTS17 = new Product(TechType.BTS, 75, "WBTS17");

    public Product(TechType techType, int minor, String releaseVersion) {
        this.myTechType = techType;
        this.myMinorVersion = minor;
        this.myReleaseVersion = releaseVersion;
    }

    public TechType getTechType() {
        return this.myTechType;
    }

    public int getMinorVersion() {
        return this.myMinorVersion;
    }

    public String getReleaseVersion() {
        return this.myReleaseVersion;
    }

    public boolean isBefore(Product prod) {
        return this.getTechType() == prod.getTechType() && this.getMinorVersion() < prod.getMinorVersion();
    }

    public boolean isAfter(Product prod) {
        return this.getTechType() == prod.getTechType() && this.getMinorVersion() > prod.getMinorVersion();
    }

    public boolean isSince(Product prod) {
        return this.getTechType() == prod.getTechType() && this.getMinorVersion() >= prod.getMinorVersion();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Product) {
            Product prod = (Product)obj;
            return this.myTechType == prod.getTechType() && this.myMinorVersion == prod.getMinorVersion();
        }
        return false;
    }

    public Map<String, String> getAdptVersionMap() {
        return this.myAdptVersionMap;
    }

    public int hashCode() {
        return this.myTechType.toString().hashCode() + this.myMinorVersion;
    }

    public static enum TechType {
        BTS,
        WLBTS,
        LTEBTS,
        TDLTEBTS,
        BTSSC,
        TDBTSSC,
        FLCBTS,
        TLCBTS,
        FLAPBTS,
        TLAPBTS;

    }
}

