/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.util;

import com.nokia.em.bts.coreasset.application.util.Product;

public class ProductInfo {
    public static boolean isWN(Product prod) {
        return Product.TechType.BTS == prod.getTechType();
    }

    public static boolean isWL(Product prod) {
        return Product.TechType.WLBTS == prod.getTechType();
    }

    public static boolean isWBTS(Product prod) {
        return ProductInfo.isWN(prod) || ProductInfo.isWL(prod);
    }

    public static boolean isFDLTE(Product prod) {
        return Product.TechType.LTEBTS == prod.getTechType();
    }

    public static boolean isTDLTE(Product prod) {
        return Product.TechType.TDLTEBTS == prod.getTechType();
    }

    public static boolean isLTE(Product prod) {
        return ProductInfo.isFDLTE(prod) || ProductInfo.isTDLTE(prod);
    }

    public static boolean isFDSmallCell(Product prod) {
        return Product.TechType.BTSSC == prod.getTechType();
    }

    public static boolean isTDSmallCell(Product prod) {
        return Product.TechType.TDBTSSC == prod.getTechType();
    }

    public static boolean isFLAP(Product prod) {
        return Product.TechType.FLAPBTS == prod.getTechType();
    }

    public static boolean isTLAP(Product prod) {
        return Product.TechType.TLAPBTS == prod.getTechType();
    }

    public static boolean isFZCAP(Product prod) {
        return ProductInfo.isFLAP(prod) || ProductInfo.isTLAP(prod);
    }

    public static boolean isSmallCell(Product prod) {
        return ProductInfo.isFDSmallCell(prod) || ProductInfo.isTDSmallCell(prod) || ProductInfo.isFZCAP(prod);
    }

    public static boolean isLTEOrSmallCell(Product prod) {
        return ProductInfo.isLTE(prod) || ProductInfo.isSmallCell(prod);
    }

    public static boolean isBeforeLTEOrSC15A(Product prod) {
        return prod.isBefore(Product.FL15A) || prod.isBefore(Product.TL15A) || prod.isBefore(Product.FLF15A) || prod.isBefore(Product.TLF15A) || prod.isBefore(Product.FLAP15A) || prod.isBefore(Product.TLAP15A);
    }

    public static boolean isBeforeWBTS16(Product prod) {
        if (ProductInfo.isWL(prod)) {
            return true;
        }
        return prod.isBefore(Product.WBTS16);
    }

    public static boolean isAfterLTEOrSC15A(Product prod) {
        return prod.isAfter(Product.FL15A) || prod.isAfter(Product.TL15A) || prod.isAfter(Product.FLF15A) || prod.isAfter(Product.TLF15A) || prod.isAfter(Product.FLAP15A) || prod.isAfter(Product.TLAP15A);
    }

    public static boolean isSinceWBTS16(Product prod) {
        return prod.isSince(Product.WBTS16);
    }

    public static boolean isAfterLTE15A(Product prod) {
        return prod.isAfter(Product.FL15A) || prod.isAfter(Product.TL15A);
    }

    public static boolean isLTEOrSC15A(Product prod) {
        return prod.equals(Product.FL15A) || prod.equals(Product.TL15A) || prod.equals(Product.FLF15A) || prod.equals(Product.TLF15A) || prod.equals(Product.FLAP15A) || prod.equals(Product.TLAP15A);
    }

    public static boolean isSinceRL70(Product prod) {
        return prod.isSince(Product.LN70) || prod.isSince(Product.LNF70) || prod.isSince(Product.LNT50) || prod.isSince(Product.LNZ50);
    }

    public static boolean isSinceLTE16A(Product prod) {
        return prod.isSince(Product.FL16A) || prod.isSince(Product.TL16A);
    }
}

