/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.util;

import com.nokia.em.bts.coreasset.application.util.HwModelUtil;
import com.nokia.em.bts.coreasset.configuration.Unit;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RFModel {
    protected Unit myUnit;

    public RFModel(Unit unit) {
        this.myUnit = unit;
    }

    public Unit getRadioMaster() {
        List<Unit> smList = this.getConnectedBBModel();
        for (Unit sm : smList) {
            if (!this.isRadioMaster(sm)) continue;
            return sm;
        }
        return null;
    }

    public boolean isRadioMaster(Unit bbModel) {
        String[] items;
        String linkList = bbModel.getCustomAttributeValue("linkList");
        if (linkList == null || linkList.trim().isEmpty() || "Coreasset_Unknown".equalsIgnoreCase(linkList)) {
            return false;
        }
        String[] stringArray = items = linkList.split(";");
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            String[] values = item.split(",");
            if (String.valueOf(this.getlinkIdInterfaceForRadioMaster()).equals(values[0]) && item.toLowerCase().contains("true")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getlinkIdInterfaceForRadioMaster() {
        return this.myUnit.getNumber();
    }

    private List<Unit> getConnectedBBModel() {
        ArrayList<Unit> smList = new ArrayList<Unit>();
        for (Unit u : HwModelUtil.getAllBBModelUnits(this.myUnit.getCabinet())) {
            if (this.getLinkMaster() != u && (!this.isShard() || !HwModelUtil.isAnotherTechnology(u))) continue;
            smList.add(u);
        }
        return smList;
    }

    protected Unit getLinkMaster() {
        int linkMasterId;
        String linkMasterID = this.myUnit.getCustomAttributeValue("LinkMasterID");
        if (linkMasterID == null) {
            return HwModelUtil.getMasterBBModel(this.myUnit.getCabinet());
        }
        try {
            linkMasterId = Integer.parseInt(linkMasterID);
        }
        catch (NumberFormatException e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to parse LinkMasterID");
            return null;
        }
        return HwModelUtil.getBBModel(this.myUnit.getCabinet(), linkMasterId);
    }

    public boolean isShard() {
        return "Shared".equals(this.myUnit.getCustomAttributeValue("IPAddressUsage"));
    }

    protected Unit getUnit() {
        return this.myUnit;
    }

    protected void setUnit(Unit u) {
        this.myUnit = u;
    }
}

