/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.util;

import com.nokia.em.bts.coreasset.application.util.LogWriter;
import com.nokia.em.bts.coreasset.application.util.StringUtils;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Date;
import org.fusesource.jansi.AnsiConsole;

public class RemoteClient {
    private static String SERVER_ADDRESS = "server";
    private static String PORT = "port";
    public static String consoleUserPrefix = String.valueOf(LogWriter.DATE_FORMAT.format(new Date())) + "\u001b[0;36m" + "  USER " + "\u001b[0;37m";
    public static String consoleErrorPrefix = String.valueOf(LogWriter.DATE_FORMAT.format(new Date())) + "\u001b[0;31m" + " ERROR " + "\u001b[0;37m";
    public static String consoleInfoPrefix = String.valueOf(LogWriter.DATE_FORMAT.format(new Date())) + "\u001b[0;32m" + "  INFO " + "\u001b[0;37m";

    public static void main(String[] args) {
        PCmdLineParams params = new PCmdLineParams(args);
        String server = params.getFirstValue(SERVER_ADDRESS);
        if (!StringUtils.isValid(server)) {
            AnsiConsole.out.println(String.valueOf(consoleErrorPrefix) + "Parameter server should be defined");
            return;
        }
        int port = 0;
        try {
            port = Integer.parseInt(params.getFirstValue(PORT));
        }
        catch (NumberFormatException e2) {
            AnsiConsole.out.println(String.valueOf(consoleErrorPrefix) + "Parameter port should be integer");
            return;
        }
        try {
            Socket socket = new Socket(server, port);
            RemoteClient remoteClient = new RemoteClient();
            remoteClient.getClass();
            ReceiveThread receiveThread = remoteClient.new ReceiveThread(socket.getInputStream());
            receiveThread.start();
            BufferedReader sin = new BufferedReader(new InputStreamReader(System.in));
            PrintWriter os = new PrintWriter(socket.getOutputStream());
            AnsiConsole.out.print(consoleUserPrefix);
            AnsiConsole.out.flush();
            while (true) {
                String input = sin.readLine();
                os.println(input);
                os.flush();
            }
        }
        catch (Exception e) {
            AnsiConsole.out.println(String.valueOf(consoleErrorPrefix) + " Unexpected error: " + e);
            return;
        }
    }

    class ReceiveThread
    extends Thread {
        BufferedReader reader;

        public ReceiveThread(InputStream is) {
            this.reader = new BufferedReader(new InputStreamReader(is));
        }

        @Override
        public void run() {
            try {
                String content = "";
                while ((content = this.reader.readLine()) != null) {
                    AnsiConsole.out.println(String.valueOf(consoleInfoPrefix) + content);
                    AnsiConsole.out.print(consoleUserPrefix);
                    AnsiConsole.out.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

