/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.util;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.Product;
import com.nokia.em.bts.coreasset.application.util.XMLUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SiteEMFileParser {
    private static final String WN_PREFIX = "W";
    private static final String LN_PREFIX = "LN ";
    private static final String LNT_PREFIX = "LNT";
    private static final String SSL = "SSL";
    private static final String PUBLIC_IP = "publicIP";
    private static final String LOCAL_IP = "localIP";
    private static final String LOCAL_PREFIX = "192.168.255";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String SITE_EM_XML = "SiteEM.xml";
    private static final String TRS = "TRS";
    private static final String NAME = "name";
    private static final String NETWORK_ELEMENT = "networkElement";
    private static final String SITE_EM = "SiteEM";
    private static final String BTS = "BTS";
    private static final String CBTS = "CBTS";
    private static final String APBTS = "APBTS";
    private static final String MINOR = "minor";
    private static final String MAJOR = "major";
    private static final String VERSION = "version";
    private static final String ADAPTATION_VERSION_MAPPING = "adaptationVersionMapping";
    private static final String ADAPTATION = "adaptation";
    private static final int CONNECTION_TIMEOUT = 10000;
    private HttpURLConnection myConnection;
    private String mySiteEMdata;

    public BTSInformation getAddress(String siteAddress) throws Exception {
        try {
            Logger.getLogger(this.getClass()).debug((Object)"getting SiteEM from port 6001");
            this.connect(HTTPS, siteAddress, SITE_EM_XML, 6001);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to get SiteEM:", (Throwable)e);
            try {
                Logger.getLogger(this.getClass()).debug((Object)"getting SiteEM from port 80");
                this.connect(HTTP, siteAddress, SITE_EM_XML, 80);
            }
            catch (Exception e2) {
                Logger.getLogger(this.getClass()).error((Object)"Failed to get SiteEM:", (Throwable)e2);
                Logger.getLogger(this.getClass()).debug((Object)"getting SiteEM from port 6000");
                this.connect(HTTP, siteAddress, SITE_EM_XML, 6000);
            }
        }
        this.mySiteEMdata = this.readStream();
        BTSInformation address = siteAddress.startsWith(LOCAL_PREFIX) ? this.parseIP(LOCAL_IP) : this.parseIP(PUBLIC_IP);
        address.setBTSAddress(siteAddress);
        return address;
    }

    private void connect(String protocol, String ipAddress, String file, int port) throws Exception {
        URL elementAddress = new URL(protocol, ipAddress, port, "/" + file);
        if (protocol.equalsIgnoreCase(HTTP)) {
            this.myConnection = (HttpURLConnection)elementAddress.openConnection();
        } else {
            SSLContext sslctx = SSLContext.getInstance(SSL);
            sslctx.init(null, new X509TrustManager[]{new ToolTrustManager()}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslctx.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostname, SSLSession session) {
                    return true;
                }
            });
            this.myConnection = (HttpsURLConnection)elementAddress.openConnection();
        }
        this.myConnection.setDefaultUseCaches(true);
        this.myConnection.setConnectTimeout(10000);
        this.myConnection.setReadTimeout(10000);
        this.myConnection.connect();
        this.myConnection.disconnect();
    }

    private BTSInformation parseIP(String id) {
        BTSInformation ipaddress = new BTSInformation();
        Logger.getLogger(this.getClass()).debug((Object)this.mySiteEMdata);
        Document siteEMDocument = XMLUtils.parseDoc(this.mySiteEMdata.trim());
        Node networkElement = XMLUtils.getNodeByAttribute(siteEMDocument, SITE_EM, NETWORK_ELEMENT, NAME, BTS);
        if (networkElement != null) {
            if (XMLUtils.getNodeValue(networkElement, id) != null && XMLUtils.getNodeValue(networkElement, id).length() > 0) {
                ipaddress.setBTSAddress(XMLUtils.getNodeValue(networkElement, id));
            }
            Node version = XMLUtils.getNode(networkElement, VERSION);
            String nodeType = version.getParentNode().getAttributes().item(0).getFirstChild().getNodeValue();
            String releaseVersion = version.getAttributes().item(0).getFirstChild().getNodeValue();
            int major = Integer.parseInt(XMLUtils.getNodeValue(version, MAJOR));
            int minor = Integer.parseInt(XMLUtils.getNodeValue(version, MINOR));
            ipaddress.setFileTransferProtocolQueryNeeded(nodeType.equals(BTS) && (major > 2 || minor > 11) || !nodeType.equals(BTS));
            Product.TechType tech = null;
            try {
                tech = Product.TechType.valueOf(nodeType);
            }
            catch (Exception e) {
                Console.error("UnSupported Technology: " + nodeType);
                return null;
            }
            Product prod = new Product(tech, minor, releaseVersion);
            try {
                Node adaptVersionMap = XMLUtils.getNode(networkElement, ADAPTATION_VERSION_MAPPING);
                if (adaptVersionMap != null) {
                    NodeList nodes = adaptVersionMap.getChildNodes();
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Node adpt = nodes.item(i);
                        String name = "";
                        String adptVersion = "";
                        if (XMLUtils.getAttributeValue(adpt, NAME) != null) {
                            name = XMLUtils.getAttributeValue(adpt, NAME);
                        }
                        if (XMLUtils.getAttributeValue(adpt, VERSION) != null) {
                            adptVersion = XMLUtils.getAttributeValue(adpt, VERSION);
                        }
                        if (!name.isEmpty() && !adptVersion.isEmpty()) {
                            prod.getAdptVersionMap().put(name, adptVersion);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger(SiteEMFileParser.class).error((Object)"Failed to parse adaptation version mapping from siteem.xml");
            }
            ipaddress.setProduct(prod);
            ipaddress.setGzippedCommissioningFileNeeded(this.isGzipNeeded(releaseVersion));
            ipaddress.setNewTechlogIF(this.isNewTechlogIF(releaseVersion));
        } else {
            CoreAsset.setNeedsQueryFileTransferProtocol((boolean)true);
        }
        networkElement = XMLUtils.getNodeByAttribute(siteEMDocument, SITE_EM, NETWORK_ELEMENT, NAME, TRS);
        if (networkElement != null && XMLUtils.getNodeValue(networkElement, id) != null && XMLUtils.getNodeValue(networkElement, id).length() > 0) {
            ipaddress.setTRSAddress(XMLUtils.getNodeValue(networkElement, id));
        }
        return ipaddress;
    }

    private boolean isNewTechlogIF(String nodeValue) {
        try {
            Integer release = Integer.valueOf(nodeValue.substring(3, 4));
            if (nodeValue.startsWith(LNT_PREFIX)) {
                return release > 2;
            }
            if (nodeValue.startsWith(LN_PREFIX)) {
                return release > 4;
            }
            if (nodeValue.startsWith(WN_PREFIX)) {
                return release > 8;
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to check techlog IF version", (Throwable)e);
        }
        return true;
    }

    private boolean isGzipNeeded(String nodeValue) {
        try {
            Integer release = Integer.valueOf(nodeValue.substring(3, 4));
            if (nodeValue.startsWith(LNT_PREFIX)) {
                return release > 1;
            }
            if (nodeValue.startsWith(LN_PREFIX)) {
                return release > 2;
            }
            if (nodeValue.startsWith(WN_PREFIX)) {
                return false;
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to check SCF gzip IF version", (Throwable)e);
        }
        return true;
    }

    private String readStream() throws Exception {
        int character;
        BufferedReader inReader = null;
        StringBuilder message = null;
        inReader = new BufferedReader(new InputStreamReader(this.myConnection.getInputStream()));
        message = new StringBuilder();
        while ((character = inReader.read()) != -1) {
            message.append((char)character);
        }
        return message.toString();
    }

    private class ToolTrustManager
    implements X509TrustManager {
        private ToolTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

