/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.util;

import com.nokia.em.bts.rp.master.alarm.Alarm;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class TextFormattingUtils {
    private static final String LF = System.getProperty("line.separator");
    private static final String LONG_PATTERN_WITH_TIMEZONE = "dd.MM.yyyy HH:mm:ss Z";
    private static final DateFormat DATE_FORMATTER_FOR_MEDIUM = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss Z");

    public static String formatTableToText(String[][] data, String[] columnNames) {
        return TextFormattingUtils.formatTableToText(data, columnNames, true);
    }

    public static String formatTableToText(String[][] data, String[] columnNames, boolean header) {
        int[] columnLengths = TextFormattingUtils.calculateColumnWidths(data, columnNames);
        StringBuilder sb = new StringBuilder();
        if (header) {
            sb.append(TextFormattingUtils.formatTableRowToString(columnNames, columnLengths));
            sb.append(LF);
            sb.append(TextFormattingUtils.getHeaderSeparator(columnLengths));
            sb.append(LF);
        }
        int j = 0;
        while (j < data.length) {
            sb.append(TextFormattingUtils.formatTableRowToString(data[j], columnLengths));
            if (j < data.length - 1) {
                sb.append(LF);
            }
            ++j;
        }
        return sb.toString();
    }

    private static String getHeaderSeparator(int[] columnLengths) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < columnLengths.length) {
            char[] chars = new char[columnLengths[i]];
            Arrays.fill(chars, '-');
            sb.append(chars);
            if (i < columnLengths.length - 1) {
                sb.append("  ");
            }
            ++i;
        }
        return sb.toString();
    }

    public static String applyLongTimeZoneFormat(Calendar time) {
        if (time == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_PATTERN_WITH_TIMEZONE);
        dateFormat.setTimeZone(time.getTimeZone());
        return dateFormat.format(time.getTime());
    }

    public static String applyLongTimeZoneFormat(Date date) {
        if (date == null) {
            return "";
        }
        return DATE_FORMATTER_FOR_MEDIUM.format(date);
    }

    protected static String formatTableRowToString(String[] rowData, int[] columnLengths) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < rowData.length) {
            if (rowData[i] != null) {
                sb.append(rowData[i]);
                sb.append(TextFormattingUtils.getIndentation(columnLengths[i] - rowData[i].length()));
            } else {
                sb.append(TextFormattingUtils.getIndentation(columnLengths[i]));
            }
            sb.append("  ");
            ++i;
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    protected static String getIndentation(int indentation) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indentation) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    protected static int[] calculateColumnWidths(String[][] data, String[] columnNames) {
        int[] lengths = TextFormattingUtils.calculateColumnWidths(columnNames);
        int j = 0;
        while (j < data.length) {
            int[] dataLengths = TextFormattingUtils.calculateColumnWidths(data[j]);
            lengths = TextFormattingUtils.findMaxValues(lengths, dataLengths);
            ++j;
        }
        return lengths;
    }

    private static int[] findMaxValues(int[] aArray, int[] anotherArray) {
        int i = 0;
        while (i < aArray.length) {
            if (anotherArray.length > i) {
                aArray[i] = Math.max(aArray[i], anotherArray[i]);
            }
            ++i;
        }
        return aArray;
    }

    protected static int[] calculateColumnWidths(String[] row) {
        int[] lenghts = new int[row.length];
        int i = 0;
        while (i < row.length) {
            lenghts[i] = row[i] != null ? row[i].length() : 0;
            ++i;
        }
        return lenghts;
    }

    public static String formatExecutionTime(long time) {
        long duration = time / 1000L;
        long hours = duration / 3600L;
        long minutes = duration % 3600L / 60L;
        long seconds = duration % 60L;
        return String.valueOf(TextFormattingUtils.prefixNumber(hours)) + ":" + TextFormattingUtils.prefixNumber(minutes) + ":" + TextFormattingUtils.prefixNumber(seconds);
    }

    private static String prefixNumber(long number) {
        return String.valueOf(number < 10L ? "0" : "") + String.valueOf(number);
    }

    public static String getPlural(String prefix, long count) {
        return String.valueOf(prefix) + (count != 1L ? "s" : "");
    }

    public static String getAlarmCode(Alarm alarm) {
        long code = alarm.getAlarmNumber();
        try {
            code = Long.parseLong(Long.toHexString(code));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return String.valueOf(code);
    }
}

