/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.util;

import com.nokia.em.bts.coreasset.application.util.TextFormattingUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ToolSummaryTable {
    private Map<String, List<String>> myTableData = new LinkedHashMap<String, List<String>>();
    private boolean myShowHeader = true;

    public ToolSummaryTable() {
        this(true);
    }

    public ToolSummaryTable(boolean showHeader) {
        this.myShowHeader = showHeader;
    }

    public ToolSummaryTable(String ... columns) {
        this();
        int i = 0;
        while (i < columns.length) {
            this.myTableData.put(columns[i], new ArrayList());
            ++i;
        }
    }

    public ToolSummaryTable(String[] columns, String[][] data) {
        this(columns);
        int row = 0;
        while (row < data.length) {
            int column = 0;
            while (column < data[row].length) {
                this.myTableData.get(columns[column]).add(data[row][column]);
                ++column;
            }
            ++row;
        }
    }

    public int getRowCount() {
        int i = 0;
        for (List<String> columns : this.myTableData.values()) {
            i = Math.max(i, columns.size());
        }
        return i;
    }

    public int getColumnCount() {
        return this.myTableData.keySet().size();
    }

    public String getColumnName(int columnIndex) {
        int i = 0;
        for (String columnName : this.myTableData.keySet()) {
            if (i == columnIndex) {
                return columnName;
            }
            ++i;
        }
        return "";
    }

    public String getValueAt(int rowIndex, int columnIndex) {
        return this.getColumnData(columnIndex).get(rowIndex);
    }

    public void setValueAt(String aValue, int rowIndex, int columnIndex) {
        this.getColumnData(columnIndex).set(rowIndex, aValue);
    }

    public void addRow(List<String> rowValues) {
        int i = 0;
        for (String columnName : this.myTableData.keySet()) {
            this.myTableData.get(columnName).add(i < rowValues.size() ? rowValues.get(i) : "");
            ++i;
        }
    }

    public void addColumn(String columnName, List<String> rowValues) {
        this.myTableData.put(columnName, rowValues);
    }

    public void addColumn(String ... column) {
        if (column.length > 0) {
            ArrayList<String> values = new ArrayList<String>();
            int i = 1;
            while (i < column.length) {
                values.add(column[i]);
                ++i;
            }
            this.myTableData.put(column[0], values);
        }
    }

    public List<String> getColumnData(int i) {
        return this.myTableData.get(this.getColumnName(i));
    }

    public String toString() {
        String[] columnNames = this.myTableData.keySet().toArray(new String[0]);
        String[][] data = new String[this.getRowCount()][this.getColumnCount()];
        int i = 0;
        while (i < this.getColumnCount()) {
            String[] columnData = this.getColumnData(i).toArray(new String[0]);
            int j = 0;
            while (j < columnData.length) {
                data[j][i] = columnData[j];
                ++j;
            }
            ++i;
        }
        return TextFormattingUtils.formatTableToText(data, columnNames, this.myShowHeader);
    }

    public boolean hasColumn(String columnName) {
        return this.myTableData.get(columnName) != null;
    }

    public int getColumnIndex(String columnName) {
        String[] columnNames = this.myTableData.keySet().toArray(new String[0]);
        int i = 0;
        while (i < columnNames.length) {
            if (columnNames[i].equals(columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setValueAt(String value, int row, String columnName) {
        this.setValueAt(value, row, this.getColumnIndex(columnName));
    }

    public void setShowHeader(boolean showHeader) {
        this.myShowHeader = showHeader;
    }

    public void addRow(String ... rowData) {
        ArrayList<String> row = new ArrayList<String>();
        int i = 0;
        while (i < rowData.length) {
            row.add(rowData[i]);
            ++i;
        }
        this.addRow(row);
    }

    public void joinToTable(ToolSummaryTable anotherTable) {
        int i = 0;
        while (i < anotherTable.getRowCount()) {
            this.addRow(anotherTable.getRowData(i));
            ++i;
        }
    }

    private List<String> getRowData(int i) {
        ArrayList<String> rowData = new ArrayList<String>();
        int column = 0;
        while (column < this.getColumnCount()) {
            rowData.add(this.getValueAt(i, column));
            ++column;
        }
        return rowData;
    }
}

