/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.util;

import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUtils {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public static String docToString(Document doc) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StreamResult result = new StreamResult(new StringWriter());
        transformer.transform(new DOMSource(doc), result);
        return result.getWriter().toString();
    }

    public static synchronized Document parseDoc(String document) {
        InputSource i = new InputSource(new ByteArrayInputStream(document.getBytes()));
        DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
        docBF.setNamespaceAware(false);
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilder = docBF.newDocumentBuilder();
            docBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException exception) {
                    System.out.println("XML error: " + exception.getLocalizedMessage());
                }

                @Override
                public void fatalError(SAXParseException exception) {
                    System.out.println("XML fatalError: " + exception.getLocalizedMessage());
                }

                @Override
                public void warning(SAXParseException exception) {
                    System.out.println("XML warning: " + exception.getLocalizedMessage());
                }
            });
            doc = docBuilder.parse(i);
        }
        catch (Exception x) {
            System.out.println("Could not parse document: " + document + " error: " + x);
            doc = null;
        }
        return doc;
    }

    public static String getAttributeValue(Node node, String attributeName) {
        if (node.hasAttributes()) {
            NamedNodeMap map = node.getAttributes();
            Node attribute = null;
            if (map != null) {
                attribute = map.getNamedItem(attributeName);
            }
            if (attribute != null) {
                return attribute.getNodeValue();
            }
        }
        return null;
    }

    public static String getNodeValue(Node nodeParent, String strNodeName) {
        NodeList children = nodeParent.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node n = children.item(i);
            if (n.getNodeName().equalsIgnoreCase(strNodeName) && n.hasChildNodes()) {
                String retVal = n.getFirstChild().getNodeValue();
                return retVal.trim();
            }
            ++i;
        }
        return "";
    }

    public static Node getNode(Node parentNode, String strNodeName) {
        NodeList children = parentNode.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node n = children.item(i);
            if (n.getNodeName().equalsIgnoreCase(strNodeName)) {
                return n;
            }
            ++i;
        }
        return null;
    }

    public static final String getAttributeValue(Document doc, String strParentNode, String strNodeName, int intNodeIndex, String strAttribute) {
        return XMLUtils.getAttributeValue(doc, strParentNode, 1, strNodeName, intNodeIndex, strAttribute);
    }

    public static final Node getNodeByAttribute(Document doc, String strElementRoot, String strElementName, String strAttrName, String strAttrValue) {
        NodeList rootElements = doc.getElementsByTagName(strElementRoot);
        int numRootElements = rootElements.getLength();
        int i = 0;
        while (i < numRootElements) {
            NodeList nodes = rootElements.item(i).getChildNodes();
            int numNodes = nodes.getLength();
            int j = 0;
            while (j < numNodes) {
                Node n2 = nodes.item(j);
                if (n2.getNodeName().equalsIgnoreCase(strElementName) && n2.getAttributes().getNamedItem(strAttrName).getNodeValue().trim().toUpperCase().contains(strAttrValue.toUpperCase())) {
                    return n2;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static final String getNodeValueByNodeValue(Document doc, String strElementRoot, String strElementName, String strElementValue, String strTargetElement) {
        NodeList rootElements = doc.getElementsByTagName(strElementRoot);
        int numRootElements = rootElements.getLength();
        int i = 0;
        while (i < numRootElements) {
            NodeList nodes = rootElements.item(i).getChildNodes();
            int numNodes = nodes.getLength();
            int j = 0;
            while (j < numNodes) {
                Node n2 = nodes.item(j);
                if (n2.getNodeName().equalsIgnoreCase(strElementName) && n2.getFirstChild().getNodeValue() != null && n2.getFirstChild().getNodeValue().equalsIgnoreCase(strElementValue)) {
                    int numN = nodes.getLength();
                    int k = 0;
                    while (k < numN) {
                        if (nodes.item(k).getNodeName().equalsIgnoreCase(strTargetElement)) {
                            return nodes.item(k).getFirstChild().getNodeValue();
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return "";
    }

    public static final String getAttributeValue(Document doc, String strParentNode, int intParentIndex, String strNodeName, int intNodeIndex, String strAttribute) {
        try {
            Node node = XMLUtils.searchNode(doc, strParentNode, intParentIndex, strNodeName, intNodeIndex);
            if (node != null) {
                return node.getAttributes().getNamedItem(strAttribute).getNodeValue().trim();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to read attribute " + strAttribute + " in XML-file: " + e);
        }
        return "";
    }

    public static final String getNodeValue(Document doc, String strParentNode, int intParentIndex, String strNodeName) {
        return XMLUtils.getNodeValue(doc, strParentNode, intParentIndex, strNodeName, 1);
    }

    public static final String getNodeValue(Document doc, String strParentNode, int intParentIndex, String strNodeName, int intNodeIndex) {
        try {
            Node node = XMLUtils.searchNode(doc, strParentNode, intParentIndex, strNodeName, intNodeIndex);
            if (node != null && node.getFirstChild() != null) {
                return node.getFirstChild().getNodeValue().trim();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to read node " + strNodeName + ". Exception : " + e);
        }
        return "";
    }

    public static final String getNodeValue(Node nodeParent, String strNodeName, boolean trim) {
        NodeList children = nodeParent.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node n = children.item(i);
            if (n.getNodeName().equalsIgnoreCase(strNodeName) && n.hasChildNodes()) {
                String retVal = n.getFirstChild().getNodeValue();
                return trim ? retVal.trim() : retVal;
            }
            ++i;
        }
        return "";
    }

    public static final Document parseDoc(InputStream myStream, String schema, DefaultHandler handler) {
        try {
            DocumentBuilderFactory docBF = DocumentBuilderFactoryImpl.newInstance();
            DocumentBuilder docBuilder = docBF.newDocumentBuilder();
            if (handler != null) {
                docBF.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                docBF.setAttribute(JAXP_SCHEMA_SOURCE, schema);
                docBuilder.setErrorHandler(handler);
            }
            return docBuilder.parse(new InputSource(myStream));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String createRamlMessage(RAMLManagedObject ramlMo, String appInfo) {
        StringBuilder raml = new StringBuilder();
        raml.append("<managedObject distName=\"FTM-1/RAML-1\">");
        raml.append(XMLUtils.createRamlHeaderParameter("version", "1.0", ""));
        raml.append(XMLUtils.createRamlHeaderParameter("compression", "NONE", ""));
        raml.append(XMLUtils.createRamlHeaderParameter("encoding", "NONE", ""));
        raml.append(XMLUtils.createRamlHeaderParameter("RAMLFile", XMLUtils.createRamlFileData(ramlMo, appInfo), ""));
        raml.append("</managedObject>");
        return raml.toString();
    }

    private static String createRamlHeaderParameter(String name, String value, String preValue) {
        StringBuilder ramlParameter = new StringBuilder();
        ramlParameter.append("<parameter>");
        ramlParameter.append("<parameterName>").append(name).append("</parameterName>");
        ramlParameter.append("<newValue>").append(value).append("</newValue>");
        ramlParameter.append("<prevValue>").append(preValue).append("</prevValue>");
        ramlParameter.append("</parameter>");
        return ramlParameter.toString();
    }

    private static String createRamlFileData(RAMLManagedObject ramlMo, String appInfo) {
        StringBuilder ramlFileData = new StringBuilder();
        ramlFileData.append("<![CDATA[");
        ramlFileData.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ramlFileData.append("<raml version=\"2.1E\" xmlns=\"raml21E.xsd\">");
        ramlFileData.append("<cmData type=\"actual\">");
        ramlFileData.append("<header>");
        ramlFileData.append("<log action=\"modified\" dateTime=\"" + new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(System.currentTimeMillis()) + "\"" + " appInfo=\"" + appInfo + "\" />");
        ramlFileData.append("</header>");
        ramlFileData.append(ramlMo.toXmlString());
        ramlFileData.append("</cmData>");
        ramlFileData.append("</raml>]]>");
        return ramlFileData.toString();
    }

    private static final Node searchNode(Document doc, String strParentNode, int intParentIndex, String strNodeName, int intNodeIndex) throws Exception {
        Node retNode = null;
        try {
            Node parentNode = doc.getElementsByTagName(strParentNode).item(intParentIndex - 1);
            if (parentNode != null) {
                retNode = XMLUtils.searchChildByIndex(parentNode, strNodeName, intNodeIndex);
            }
        }
        catch (Exception e) {
            System.out.println("Error when searching node " + strNodeName + ". Exception: " + e);
            throw e;
        }
        return retNode;
    }

    private static final Node searchChildByIndex(Node parentNode, String strNodeName, int index) throws Exception {
        Node retNode = null;
        int intNodeIndex = index;
        try {
            NodeList childNodes = parentNode.getChildNodes();
            int numChildren = childNodes.getLength();
            int i = 0;
            while (i < numChildren) {
                Node node = childNodes.item(i);
                if (node.getNodeName().equalsIgnoreCase(strNodeName) && --intNodeIndex == 0) {
                    retNode = node;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Error when searching child " + strNodeName + e);
            throw e;
        }
        return retNode;
    }
}

