/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder;

import com.mathworks.toolbox.javabuilder.MWApplication;
import com.mathworks.toolbox.javabuilder.MWComponentOption;
import com.mathworks.toolbox.javabuilder.MWCtfExtractLocation;
import com.mathworks.toolbox.javabuilder.MWCtfSource;
import com.mathworks.toolbox.javabuilder.internal.MWMCR;
import java.io.PrintStream;
import java.util.concurrent.Callable;

public class MWComponentOptions {
    private MWCtfExtractLocation extractLocation = MWCtfExtractLocation.EXTRACT_TO_CACHE;
    private MWCtfSource ctfSource = null;
    private MWMCR executionContext = null;
    private boolean printStreamSpecified = false;
    private Callable<PrintStream> printStream = MWApplication.getDefaultOutputStream();
    private Callable<PrintStream> errorStream = MWApplication.getDefaultErrorStream();

    public MWComponentOptions() {
    }

    public MWComponentOptions(Object ... objectArray) {
        for (Object object : objectArray) {
            if (this.setUnnamedOption(object)) continue;
            throw new IllegalArgumentException("MWComponentOption not recognized: " + object.getClass().getName());
        }
    }

    private boolean setUnnamedOption(Object object) {
        if (object instanceof MWComponentOption) {
            ((MWComponentOption)object).apply(this);
        } else if (object instanceof PrintStream) {
            if (!this.printStreamSpecified) {
                this.setPrintStream((PrintStream)object);
            } else {
                this.setErrorStream((PrintStream)object);
            }
        } else {
            return false;
        }
        return true;
    }

    public MWComponentOptions(MWComponentOptions mWComponentOptions) {
        this.setCtfSource(mWComponentOptions.getCtfSource());
        this.setExtractLocation(mWComponentOptions.getExtractLocation());
        if (mWComponentOptions.getExecutionContext() != null) {
            this.setExecutionContext(mWComponentOptions.getExecutionContext().use());
        }
        this.setPrintStream(mWComponentOptions.getPrintStream());
        this.setErrorStream(mWComponentOptions.getErrorStream());
    }

    public MWCtfSource getCtfSource() {
        return this.ctfSource;
    }

    public MWCtfExtractLocation getExtractLocation() {
        return this.extractLocation;
    }

    public void setExtractLocation(MWCtfExtractLocation mWCtfExtractLocation) {
        this.extractLocation = mWCtfExtractLocation;
    }

    public void setCtfSource(MWCtfSource mWCtfSource) {
        this.ctfSource = mWCtfSource;
    }

    public MWMCR getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(MWMCR mWMCR) {
        this.executionContext = mWMCR;
    }

    public Callable<PrintStream> getPrintStream() {
        return this.printStream;
    }

    public void setPrintStream(final PrintStream printStream) {
        this.printStream = new Callable<PrintStream>(){

            @Override
            public PrintStream call() throws Exception {
                return printStream;
            }
        };
        this.printStreamSpecified = true;
    }

    public void setPrintStream(Callable<PrintStream> callable) {
        this.printStream = callable;
    }

    public Callable<PrintStream> getErrorStream() {
        return this.errorStream;
    }

    public void setErrorStream(final PrintStream printStream) {
        this.errorStream = new Callable<PrintStream>(){

            @Override
            public PrintStream call() throws Exception {
                return printStream;
            }
        };
    }

    public void setErrorStream(Callable<PrintStream> callable) {
        this.errorStream = callable;
    }
}

